// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.signer.serde

import aws.sdk.kotlin.services.signer.model.Category
import aws.sdk.kotlin.services.signer.model.GetSigningPlatformResponse
import aws.sdk.kotlin.services.signer.model.SignerException
import aws.sdk.kotlin.services.signer.model.SigningConfiguration
import aws.sdk.kotlin.services.signer.model.SigningImageFormat
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetSigningPlatformOperationDeserializer: HttpDeserialize<GetSigningPlatformResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetSigningPlatformResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetSigningPlatformError(context, call)
        }
        val builder = GetSigningPlatformResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetSigningPlatformOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetSigningPlatformError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SignerException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServiceErrorException" -> InternalServiceErrorExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        else -> SignerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetSigningPlatformOperationBody(builder: GetSigningPlatformResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CATEGORY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("category"))
    val DISPLAYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("displayName"))
    val MAXSIZEINMB_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("maxSizeInMB"))
    val PARTNER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("partner"))
    val PLATFORMID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("platformId"))
    val REVOCATIONSUPPORTED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("revocationSupported"))
    val SIGNINGCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("signingConfiguration"))
    val SIGNINGIMAGEFORMAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("signingImageFormat"))
    val TARGET_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("target"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CATEGORY_DESCRIPTOR)
        field(DISPLAYNAME_DESCRIPTOR)
        field(MAXSIZEINMB_DESCRIPTOR)
        field(PARTNER_DESCRIPTOR)
        field(PLATFORMID_DESCRIPTOR)
        field(REVOCATIONSUPPORTED_DESCRIPTOR)
        field(SIGNINGCONFIGURATION_DESCRIPTOR)
        field(SIGNINGIMAGEFORMAT_DESCRIPTOR)
        field(TARGET_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CATEGORY_DESCRIPTOR.index -> builder.category = deserializeString().let { Category.fromValue(it) }
                DISPLAYNAME_DESCRIPTOR.index -> builder.displayName = deserializeString()
                MAXSIZEINMB_DESCRIPTOR.index -> builder.maxSizeInMb = deserializeInt()
                PARTNER_DESCRIPTOR.index -> builder.partner = deserializeString()
                PLATFORMID_DESCRIPTOR.index -> builder.platformId = deserializeString()
                REVOCATIONSUPPORTED_DESCRIPTOR.index -> builder.revocationSupported = deserializeBoolean()
                SIGNINGCONFIGURATION_DESCRIPTOR.index -> builder.signingConfiguration = deserializeSigningConfigurationDocument(deserializer)
                SIGNINGIMAGEFORMAT_DESCRIPTOR.index -> builder.signingImageFormat = deserializeSigningImageFormatDocument(deserializer)
                TARGET_DESCRIPTOR.index -> builder.target = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
