// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.signer.model



public class PutSigningProfileRequest private constructor(builder: Builder) {
    /**
     * A subfield of `platform`. This specifies any different configuration options that you want to apply to the chosen platform (such as a different `hash-algorithm` or `signing-algorithm`).
     */
    public val overrides: aws.sdk.kotlin.services.signer.model.SigningPlatformOverrides? = builder.overrides
    /**
     * The ID of the signing platform to be created.
     */
    public val platformId: kotlin.String? = builder.platformId
    /**
     * The name of the signing profile to be created.
     */
    public val profileName: kotlin.String? = builder.profileName
    /**
     * The default validity period override for any signature generated using this signing profile. If unspecified, the default is 135 months.
     */
    public val signatureValidityPeriod: aws.sdk.kotlin.services.signer.model.SignatureValidityPeriod? = builder.signatureValidityPeriod
    /**
     * The AWS Certificate Manager certificate that will be used to sign code with the new signing profile.
     */
    public val signingMaterial: aws.sdk.kotlin.services.signer.model.SigningMaterial? = builder.signingMaterial
    /**
     * Map of key-value pairs for signing. These can include any information that you want to use during signing.
     */
    public val signingParameters: Map<String, String>? = builder.signingParameters
    /**
     * Tags to be associated with the signing profile that is being created.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.signer.model.PutSigningProfileRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutSigningProfileRequest(")
        append("overrides=$overrides,")
        append("platformId=$platformId,")
        append("profileName=$profileName,")
        append("signatureValidityPeriod=$signatureValidityPeriod,")
        append("signingMaterial=$signingMaterial,")
        append("signingParameters=$signingParameters,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = overrides?.hashCode() ?: 0
        result = 31 * result + (platformId?.hashCode() ?: 0)
        result = 31 * result + (profileName?.hashCode() ?: 0)
        result = 31 * result + (signatureValidityPeriod?.hashCode() ?: 0)
        result = 31 * result + (signingMaterial?.hashCode() ?: 0)
        result = 31 * result + (signingParameters?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutSigningProfileRequest

        if (overrides != other.overrides) return false
        if (platformId != other.platformId) return false
        if (profileName != other.profileName) return false
        if (signatureValidityPeriod != other.signatureValidityPeriod) return false
        if (signingMaterial != other.signingMaterial) return false
        if (signingParameters != other.signingParameters) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.signer.model.PutSigningProfileRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A subfield of `platform`. This specifies any different configuration options that you want to apply to the chosen platform (such as a different `hash-algorithm` or `signing-algorithm`).
         */
        public var overrides: aws.sdk.kotlin.services.signer.model.SigningPlatformOverrides? = null
        /**
         * The ID of the signing platform to be created.
         */
        public var platformId: kotlin.String? = null
        /**
         * The name of the signing profile to be created.
         */
        public var profileName: kotlin.String? = null
        /**
         * The default validity period override for any signature generated using this signing profile. If unspecified, the default is 135 months.
         */
        public var signatureValidityPeriod: aws.sdk.kotlin.services.signer.model.SignatureValidityPeriod? = null
        /**
         * The AWS Certificate Manager certificate that will be used to sign code with the new signing profile.
         */
        public var signingMaterial: aws.sdk.kotlin.services.signer.model.SigningMaterial? = null
        /**
         * Map of key-value pairs for signing. These can include any information that you want to use during signing.
         */
        public var signingParameters: Map<String, String>? = null
        /**
         * Tags to be associated with the signing profile that is being created.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.signer.model.PutSigningProfileRequest) : this() {
            this.overrides = x.overrides
            this.platformId = x.platformId
            this.profileName = x.profileName
            this.signatureValidityPeriod = x.signatureValidityPeriod
            this.signingMaterial = x.signingMaterial
            this.signingParameters = x.signingParameters
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.signer.model.PutSigningProfileRequest = PutSigningProfileRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.signer.model.SigningPlatformOverrides] inside the given [block]
         */
        public fun overrides(block: aws.sdk.kotlin.services.signer.model.SigningPlatformOverrides.Builder.() -> kotlin.Unit) {
            this.overrides = aws.sdk.kotlin.services.signer.model.SigningPlatformOverrides.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.signer.model.SignatureValidityPeriod] inside the given [block]
         */
        public fun signatureValidityPeriod(block: aws.sdk.kotlin.services.signer.model.SignatureValidityPeriod.Builder.() -> kotlin.Unit) {
            this.signatureValidityPeriod = aws.sdk.kotlin.services.signer.model.SignatureValidityPeriod.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.signer.model.SigningMaterial] inside the given [block]
         */
        public fun signingMaterial(block: aws.sdk.kotlin.services.signer.model.SigningMaterial.Builder.() -> kotlin.Unit) {
            this.signingMaterial = aws.sdk.kotlin.services.signer.model.SigningMaterial.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
