// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.signer.model

import aws.smithy.kotlin.runtime.time.Instant

public class DescribeSigningJobResponse private constructor(builder: Builder) {
    /**
     * Date and time that the signing job was completed.
     */
    public val completedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.completedAt
    /**
     * Date and time that the signing job was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The ID of the signing job on output.
     */
    public val jobId: kotlin.String? = builder.jobId
    /**
     * The IAM entity that initiated the signing job.
     */
    public val jobInvoker: kotlin.String? = builder.jobInvoker
    /**
     * The AWS account ID of the job owner.
     */
    public val jobOwner: kotlin.String? = builder.jobOwner
    /**
     * A list of any overrides that were applied to the signing operation.
     */
    public val overrides: aws.sdk.kotlin.services.signer.model.SigningPlatformOverrides? = builder.overrides
    /**
     * A human-readable name for the signing platform associated with the signing job.
     */
    public val platformDisplayName: kotlin.String? = builder.platformDisplayName
    /**
     * The microcontroller platform to which your signed code image will be distributed.
     */
    public val platformId: kotlin.String? = builder.platformId
    /**
     * The name of the profile that initiated the signing operation.
     */
    public val profileName: kotlin.String? = builder.profileName
    /**
     * The version of the signing profile used to initiate the signing job.
     */
    public val profileVersion: kotlin.String? = builder.profileVersion
    /**
     * The IAM principal that requested the signing job.
     */
    public val requestedBy: kotlin.String? = builder.requestedBy
    /**
     * A revocation record if the signature generated by the signing job has been revoked. Contains a timestamp and the ID of the IAM entity that revoked the signature.
     */
    public val revocationRecord: aws.sdk.kotlin.services.signer.model.SigningJobRevocationRecord? = builder.revocationRecord
    /**
     * Thr expiration timestamp for the signature generated by the signing job.
     */
    public val signatureExpiresAt: aws.smithy.kotlin.runtime.time.Instant? = builder.signatureExpiresAt
    /**
     * Name of the S3 bucket where the signed code image is saved by AWS Signer.
     */
    public val signedObject: aws.sdk.kotlin.services.signer.model.SignedObject? = builder.signedObject
    /**
     * The Amazon Resource Name (ARN) of your code signing certificate.
     */
    public val signingMaterial: aws.sdk.kotlin.services.signer.model.SigningMaterial? = builder.signingMaterial
    /**
     * Map of user-assigned key-value pairs used during signing. These values contain any information that you specified for use in your signing job.
     */
    public val signingParameters: Map<String, String>? = builder.signingParameters
    /**
     * The object that contains the name of your S3 bucket or your raw code.
     */
    public val source: aws.sdk.kotlin.services.signer.model.Source? = builder.source
    /**
     * Status of the signing job.
     */
    public val status: aws.sdk.kotlin.services.signer.model.SigningStatus? = builder.status
    /**
     * String value that contains the status reason.
     */
    public val statusReason: kotlin.String? = builder.statusReason

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.signer.model.DescribeSigningJobResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeSigningJobResponse(")
        append("completedAt=$completedAt,")
        append("createdAt=$createdAt,")
        append("jobId=$jobId,")
        append("jobInvoker=$jobInvoker,")
        append("jobOwner=$jobOwner,")
        append("overrides=$overrides,")
        append("platformDisplayName=$platformDisplayName,")
        append("platformId=$platformId,")
        append("profileName=$profileName,")
        append("profileVersion=$profileVersion,")
        append("requestedBy=$requestedBy,")
        append("revocationRecord=$revocationRecord,")
        append("signatureExpiresAt=$signatureExpiresAt,")
        append("signedObject=$signedObject,")
        append("signingMaterial=$signingMaterial,")
        append("signingParameters=$signingParameters,")
        append("source=$source,")
        append("status=$status,")
        append("statusReason=$statusReason")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = completedAt?.hashCode() ?: 0
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (jobId?.hashCode() ?: 0)
        result = 31 * result + (jobInvoker?.hashCode() ?: 0)
        result = 31 * result + (jobOwner?.hashCode() ?: 0)
        result = 31 * result + (overrides?.hashCode() ?: 0)
        result = 31 * result + (platformDisplayName?.hashCode() ?: 0)
        result = 31 * result + (platformId?.hashCode() ?: 0)
        result = 31 * result + (profileName?.hashCode() ?: 0)
        result = 31 * result + (profileVersion?.hashCode() ?: 0)
        result = 31 * result + (requestedBy?.hashCode() ?: 0)
        result = 31 * result + (revocationRecord?.hashCode() ?: 0)
        result = 31 * result + (signatureExpiresAt?.hashCode() ?: 0)
        result = 31 * result + (signedObject?.hashCode() ?: 0)
        result = 31 * result + (signingMaterial?.hashCode() ?: 0)
        result = 31 * result + (signingParameters?.hashCode() ?: 0)
        result = 31 * result + (source?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusReason?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeSigningJobResponse

        if (completedAt != other.completedAt) return false
        if (createdAt != other.createdAt) return false
        if (jobId != other.jobId) return false
        if (jobInvoker != other.jobInvoker) return false
        if (jobOwner != other.jobOwner) return false
        if (overrides != other.overrides) return false
        if (platformDisplayName != other.platformDisplayName) return false
        if (platformId != other.platformId) return false
        if (profileName != other.profileName) return false
        if (profileVersion != other.profileVersion) return false
        if (requestedBy != other.requestedBy) return false
        if (revocationRecord != other.revocationRecord) return false
        if (signatureExpiresAt != other.signatureExpiresAt) return false
        if (signedObject != other.signedObject) return false
        if (signingMaterial != other.signingMaterial) return false
        if (signingParameters != other.signingParameters) return false
        if (source != other.source) return false
        if (status != other.status) return false
        if (statusReason != other.statusReason) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.signer.model.DescribeSigningJobResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Date and time that the signing job was completed.
         */
        public var completedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Date and time that the signing job was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ID of the signing job on output.
         */
        public var jobId: kotlin.String? = null
        /**
         * The IAM entity that initiated the signing job.
         */
        public var jobInvoker: kotlin.String? = null
        /**
         * The AWS account ID of the job owner.
         */
        public var jobOwner: kotlin.String? = null
        /**
         * A list of any overrides that were applied to the signing operation.
         */
        public var overrides: aws.sdk.kotlin.services.signer.model.SigningPlatformOverrides? = null
        /**
         * A human-readable name for the signing platform associated with the signing job.
         */
        public var platformDisplayName: kotlin.String? = null
        /**
         * The microcontroller platform to which your signed code image will be distributed.
         */
        public var platformId: kotlin.String? = null
        /**
         * The name of the profile that initiated the signing operation.
         */
        public var profileName: kotlin.String? = null
        /**
         * The version of the signing profile used to initiate the signing job.
         */
        public var profileVersion: kotlin.String? = null
        /**
         * The IAM principal that requested the signing job.
         */
        public var requestedBy: kotlin.String? = null
        /**
         * A revocation record if the signature generated by the signing job has been revoked. Contains a timestamp and the ID of the IAM entity that revoked the signature.
         */
        public var revocationRecord: aws.sdk.kotlin.services.signer.model.SigningJobRevocationRecord? = null
        /**
         * Thr expiration timestamp for the signature generated by the signing job.
         */
        public var signatureExpiresAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Name of the S3 bucket where the signed code image is saved by AWS Signer.
         */
        public var signedObject: aws.sdk.kotlin.services.signer.model.SignedObject? = null
        /**
         * The Amazon Resource Name (ARN) of your code signing certificate.
         */
        public var signingMaterial: aws.sdk.kotlin.services.signer.model.SigningMaterial? = null
        /**
         * Map of user-assigned key-value pairs used during signing. These values contain any information that you specified for use in your signing job.
         */
        public var signingParameters: Map<String, String>? = null
        /**
         * The object that contains the name of your S3 bucket or your raw code.
         */
        public var source: aws.sdk.kotlin.services.signer.model.Source? = null
        /**
         * Status of the signing job.
         */
        public var status: aws.sdk.kotlin.services.signer.model.SigningStatus? = null
        /**
         * String value that contains the status reason.
         */
        public var statusReason: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.signer.model.DescribeSigningJobResponse) : this() {
            this.completedAt = x.completedAt
            this.createdAt = x.createdAt
            this.jobId = x.jobId
            this.jobInvoker = x.jobInvoker
            this.jobOwner = x.jobOwner
            this.overrides = x.overrides
            this.platformDisplayName = x.platformDisplayName
            this.platformId = x.platformId
            this.profileName = x.profileName
            this.profileVersion = x.profileVersion
            this.requestedBy = x.requestedBy
            this.revocationRecord = x.revocationRecord
            this.signatureExpiresAt = x.signatureExpiresAt
            this.signedObject = x.signedObject
            this.signingMaterial = x.signingMaterial
            this.signingParameters = x.signingParameters
            this.source = x.source
            this.status = x.status
            this.statusReason = x.statusReason
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.signer.model.DescribeSigningJobResponse = DescribeSigningJobResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.signer.model.SigningPlatformOverrides] inside the given [block]
         */
        public fun overrides(block: aws.sdk.kotlin.services.signer.model.SigningPlatformOverrides.Builder.() -> kotlin.Unit) {
            this.overrides = aws.sdk.kotlin.services.signer.model.SigningPlatformOverrides.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.signer.model.SigningJobRevocationRecord] inside the given [block]
         */
        public fun revocationRecord(block: aws.sdk.kotlin.services.signer.model.SigningJobRevocationRecord.Builder.() -> kotlin.Unit) {
            this.revocationRecord = aws.sdk.kotlin.services.signer.model.SigningJobRevocationRecord.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.signer.model.SignedObject] inside the given [block]
         */
        public fun signedObject(block: aws.sdk.kotlin.services.signer.model.SignedObject.Builder.() -> kotlin.Unit) {
            this.signedObject = aws.sdk.kotlin.services.signer.model.SignedObject.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.signer.model.SigningMaterial] inside the given [block]
         */
        public fun signingMaterial(block: aws.sdk.kotlin.services.signer.model.SigningMaterial.Builder.() -> kotlin.Unit) {
            this.signingMaterial = aws.sdk.kotlin.services.signer.model.SigningMaterial.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.signer.model.Source] inside the given [block]
         */
        public fun source(block: aws.sdk.kotlin.services.signer.model.Source.Builder.() -> kotlin.Unit) {
            this.source = aws.sdk.kotlin.services.signer.model.Source.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
