// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.signer

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.signer.auth.DefaultSignerAuthSchemeProvider
import aws.sdk.kotlin.services.signer.auth.SignerAuthSchemeProvider
import aws.sdk.kotlin.services.signer.endpoints.DefaultSignerEndpointProvider
import aws.sdk.kotlin.services.signer.endpoints.SignerEndpointParameters
import aws.sdk.kotlin.services.signer.endpoints.SignerEndpointProvider
import aws.sdk.kotlin.services.signer.model.AddProfilePermissionRequest
import aws.sdk.kotlin.services.signer.model.AddProfilePermissionResponse
import aws.sdk.kotlin.services.signer.model.CancelSigningProfileRequest
import aws.sdk.kotlin.services.signer.model.CancelSigningProfileResponse
import aws.sdk.kotlin.services.signer.model.DescribeSigningJobRequest
import aws.sdk.kotlin.services.signer.model.DescribeSigningJobResponse
import aws.sdk.kotlin.services.signer.model.GetRevocationStatusRequest
import aws.sdk.kotlin.services.signer.model.GetRevocationStatusResponse
import aws.sdk.kotlin.services.signer.model.GetSigningPlatformRequest
import aws.sdk.kotlin.services.signer.model.GetSigningPlatformResponse
import aws.sdk.kotlin.services.signer.model.GetSigningProfileRequest
import aws.sdk.kotlin.services.signer.model.GetSigningProfileResponse
import aws.sdk.kotlin.services.signer.model.ListProfilePermissionsRequest
import aws.sdk.kotlin.services.signer.model.ListProfilePermissionsResponse
import aws.sdk.kotlin.services.signer.model.ListSigningJobsRequest
import aws.sdk.kotlin.services.signer.model.ListSigningJobsResponse
import aws.sdk.kotlin.services.signer.model.ListSigningPlatformsRequest
import aws.sdk.kotlin.services.signer.model.ListSigningPlatformsResponse
import aws.sdk.kotlin.services.signer.model.ListSigningProfilesRequest
import aws.sdk.kotlin.services.signer.model.ListSigningProfilesResponse
import aws.sdk.kotlin.services.signer.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.signer.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.signer.model.PutSigningProfileRequest
import aws.sdk.kotlin.services.signer.model.PutSigningProfileResponse
import aws.sdk.kotlin.services.signer.model.RemoveProfilePermissionRequest
import aws.sdk.kotlin.services.signer.model.RemoveProfilePermissionResponse
import aws.sdk.kotlin.services.signer.model.RevokeSignatureRequest
import aws.sdk.kotlin.services.signer.model.RevokeSignatureResponse
import aws.sdk.kotlin.services.signer.model.RevokeSigningProfileRequest
import aws.sdk.kotlin.services.signer.model.RevokeSigningProfileResponse
import aws.sdk.kotlin.services.signer.model.SignPayloadRequest
import aws.sdk.kotlin.services.signer.model.SignPayloadResponse
import aws.sdk.kotlin.services.signer.model.StartSigningJobRequest
import aws.sdk.kotlin.services.signer.model.StartSigningJobResponse
import aws.sdk.kotlin.services.signer.model.TagResourceRequest
import aws.sdk.kotlin.services.signer.model.TagResourceResponse
import aws.sdk.kotlin.services.signer.model.UntagResourceRequest
import aws.sdk.kotlin.services.signer.model.UntagResourceResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "signer"
public const val SdkVersion: String = "1.0.75"
public const val ServiceApiVersion: String = "2017-08-25"

/**
 * AWS Signer is a fully managed code-signing service to help you ensure the trust and integrity of your code.
 *
 * Signer supports the following applications:
 *
 * With code signing for AWS Lambda, you can sign [AWS Lambda](http://docs.aws.amazon.com/lambda/latest/dg/) deployment packages. Integrated support is provided for [Amazon S3](http://docs.aws.amazon.com/AmazonS3/latest/gsg/), [Amazon CloudWatch](http://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/), and [AWS CloudTrail](http://docs.aws.amazon.com/awscloudtrail/latest/userguide/). In order to sign code, you create a signing profile and then use Signer to sign Lambda zip files in S3.
 *
 * With code signing for IoT, you can sign code for any IoT device that is supported by AWS. IoT code signing is available for [Amazon FreeRTOS](http://docs.aws.amazon.com/freertos/latest/userguide/) and [AWS IoT Device Management](http://docs.aws.amazon.com/iot/latest/developerguide/), and is integrated with [AWS Certificate Manager (ACM)](http://docs.aws.amazon.com/acm/latest/userguide/). In order to sign code, you import a third-party code-signing certificate using ACM, and use that to sign updates in Amazon FreeRTOS and AWS IoT Device Management.
 *
 * With Signer and the Notation CLI from the [Notary  Project](https://notaryproject.dev/), you can sign container images stored in a container registry such as Amazon Elastic Container Registry (ECR). The signatures are stored in the registry alongside the images, where they are available for verifying image authenticity and integrity.
 *
 * For more information about Signer, see the [AWS Signer Developer Guide](https://docs.aws.amazon.com/signer/latest/developerguide/Welcome.html).
 */
public interface SignerClient : SdkClient {
    /**
     * SignerClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, SignerClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "Signer",
                "SIGNER",
                "signer",
            )
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, SignerClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): SignerClient = DefaultSignerClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: SignerEndpointProvider = builder.endpointProvider ?: DefaultSignerEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: SignerAuthSchemeProvider = builder.authSchemeProvider ?: DefaultSignerAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "signer"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: SignerEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: SignerAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Adds cross-account permissions to a signing profile.
     */
    public suspend fun addProfilePermission(input: AddProfilePermissionRequest): AddProfilePermissionResponse

    /**
     * Changes the state of an `ACTIVE` signing profile to `CANCELED`. A canceled profile is still viewable with the `ListSigningProfiles` operation, but it cannot perform new signing jobs, and is deleted two years after cancelation.
     */
    public suspend fun cancelSigningProfile(input: CancelSigningProfileRequest): CancelSigningProfileResponse

    /**
     * Returns information about a specific code signing job. You specify the job by using the `jobId` value that is returned by the StartSigningJob operation.
     */
    public suspend fun describeSigningJob(input: DescribeSigningJobRequest): DescribeSigningJobResponse

    /**
     * Retrieves the revocation status of one or more of the signing profile, signing job, and signing certificate.
     */
    public suspend fun getRevocationStatus(input: GetRevocationStatusRequest): GetRevocationStatusResponse

    /**
     * Returns information on a specific signing platform.
     */
    public suspend fun getSigningPlatform(input: GetSigningPlatformRequest): GetSigningPlatformResponse

    /**
     * Returns information on a specific signing profile.
     */
    public suspend fun getSigningProfile(input: GetSigningProfileRequest): GetSigningProfileResponse

    /**
     * Lists the cross-account permissions associated with a signing profile.
     */
    public suspend fun listProfilePermissions(input: ListProfilePermissionsRequest): ListProfilePermissionsResponse

    /**
     * Lists all your signing jobs. You can use the `maxResults` parameter to limit the number of signing jobs that are returned in the response. If additional jobs remain to be listed, AWS Signer returns a `nextToken` value. Use this value in subsequent calls to `ListSigningJobs` to fetch the remaining values. You can continue calling `ListSigningJobs` with your `maxResults` parameter and with new values that Signer returns in the `nextToken` parameter until all of your signing jobs have been returned.
     */
    public suspend fun listSigningJobs(input: ListSigningJobsRequest = ListSigningJobsRequest { }): ListSigningJobsResponse

    /**
     * Lists all signing platforms available in AWS Signer that match the request parameters. If additional jobs remain to be listed, Signer returns a `nextToken` value. Use this value in subsequent calls to `ListSigningJobs` to fetch the remaining values. You can continue calling `ListSigningJobs` with your `maxResults` parameter and with new values that Signer returns in the `nextToken` parameter until all of your signing jobs have been returned.
     */
    public suspend fun listSigningPlatforms(input: ListSigningPlatformsRequest = ListSigningPlatformsRequest { }): ListSigningPlatformsResponse

    /**
     * Lists all available signing profiles in your AWS account. Returns only profiles with an `ACTIVE` status unless the `includeCanceled` request field is set to `true`. If additional jobs remain to be listed, AWS Signer returns a `nextToken` value. Use this value in subsequent calls to `ListSigningJobs` to fetch the remaining values. You can continue calling `ListSigningJobs` with your `maxResults` parameter and with new values that Signer returns in the `nextToken` parameter until all of your signing jobs have been returned.
     */
    public suspend fun listSigningProfiles(input: ListSigningProfilesRequest = ListSigningProfilesRequest { }): ListSigningProfilesResponse

    /**
     * Returns a list of the tags associated with a signing profile resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Creates a signing profile. A signing profile is a code-signing template that can be used to carry out a pre-defined signing job.
     */
    public suspend fun putSigningProfile(input: PutSigningProfileRequest): PutSigningProfileResponse

    /**
     * Removes cross-account permissions from a signing profile.
     */
    public suspend fun removeProfilePermission(input: RemoveProfilePermissionRequest): RemoveProfilePermissionResponse

    /**
     * Changes the state of a signing job to REVOKED. This indicates that the signature is no longer valid.
     */
    public suspend fun revokeSignature(input: RevokeSignatureRequest): RevokeSignatureResponse

    /**
     * Changes the state of a signing profile to REVOKED. This indicates that signatures generated using the signing profile after an effective start date are no longer valid.
     */
    public suspend fun revokeSigningProfile(input: RevokeSigningProfileRequest): RevokeSigningProfileResponse

    /**
     * Signs a binary payload and returns a signature envelope.
     */
    public suspend fun signPayload(input: SignPayloadRequest): SignPayloadResponse

    /**
     * Initiates a signing job to be performed on the code provided. Signing jobs are viewable by the `ListSigningJobs` operation for two years after they are performed. Note the following requirements:
     * +  You must create an Amazon S3 source bucket. For more information, see [Creating a Bucket](http://docs.aws.amazon.com/AmazonS3/latest/gsg/CreatingABucket.html) in the *Amazon S3 Getting Started Guide*.
     * + Your S3 source bucket must be version enabled.
     * + You must create an S3 destination bucket. AWS Signer uses your S3 destination bucket to write your signed code.
     * + You specify the name of the source and destination buckets when calling the `StartSigningJob` operation.
     * + You must also specify a request token that identifies your request to Signer.
     *
     * You can call the DescribeSigningJob and the ListSigningJobs actions after you call `StartSigningJob`.
     *
     * For a Java example that shows how to use this action, see [StartSigningJob](https://docs.aws.amazon.com/signer/latest/developerguide/api-startsigningjob.html).
     */
    public suspend fun startSigningJob(input: StartSigningJobRequest): StartSigningJobResponse

    /**
     * Adds one or more tags to a signing profile. Tags are labels that you can use to identify and organize your AWS resources. Each tag consists of a key and an optional value. To specify the signing profile, use its Amazon Resource Name (ARN). To specify the tag, use a key-value pair.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes one or more tags from a signing profile. To remove the tags, specify a list of tag keys.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun SignerClient.withConfig(block: SignerClient.Config.Builder.() -> Unit): SignerClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultSignerClient(newConfig)
}

/**
 * Adds cross-account permissions to a signing profile.
 */
public suspend inline fun SignerClient.addProfilePermission(crossinline block: AddProfilePermissionRequest.Builder.() -> Unit): AddProfilePermissionResponse = addProfilePermission(AddProfilePermissionRequest.Builder().apply(block).build())

/**
 * Changes the state of an `ACTIVE` signing profile to `CANCELED`. A canceled profile is still viewable with the `ListSigningProfiles` operation, but it cannot perform new signing jobs, and is deleted two years after cancelation.
 */
public suspend inline fun SignerClient.cancelSigningProfile(crossinline block: CancelSigningProfileRequest.Builder.() -> Unit): CancelSigningProfileResponse = cancelSigningProfile(CancelSigningProfileRequest.Builder().apply(block).build())

/**
 * Returns information about a specific code signing job. You specify the job by using the `jobId` value that is returned by the StartSigningJob operation.
 */
public suspend inline fun SignerClient.describeSigningJob(crossinline block: DescribeSigningJobRequest.Builder.() -> Unit): DescribeSigningJobResponse = describeSigningJob(DescribeSigningJobRequest.Builder().apply(block).build())

/**
 * Retrieves the revocation status of one or more of the signing profile, signing job, and signing certificate.
 */
public suspend inline fun SignerClient.getRevocationStatus(crossinline block: GetRevocationStatusRequest.Builder.() -> Unit): GetRevocationStatusResponse = getRevocationStatus(GetRevocationStatusRequest.Builder().apply(block).build())

/**
 * Returns information on a specific signing platform.
 */
public suspend inline fun SignerClient.getSigningPlatform(crossinline block: GetSigningPlatformRequest.Builder.() -> Unit): GetSigningPlatformResponse = getSigningPlatform(GetSigningPlatformRequest.Builder().apply(block).build())

/**
 * Returns information on a specific signing profile.
 */
public suspend inline fun SignerClient.getSigningProfile(crossinline block: GetSigningProfileRequest.Builder.() -> Unit): GetSigningProfileResponse = getSigningProfile(GetSigningProfileRequest.Builder().apply(block).build())

/**
 * Lists the cross-account permissions associated with a signing profile.
 */
public suspend inline fun SignerClient.listProfilePermissions(crossinline block: ListProfilePermissionsRequest.Builder.() -> Unit): ListProfilePermissionsResponse = listProfilePermissions(ListProfilePermissionsRequest.Builder().apply(block).build())

/**
 * Lists all your signing jobs. You can use the `maxResults` parameter to limit the number of signing jobs that are returned in the response. If additional jobs remain to be listed, AWS Signer returns a `nextToken` value. Use this value in subsequent calls to `ListSigningJobs` to fetch the remaining values. You can continue calling `ListSigningJobs` with your `maxResults` parameter and with new values that Signer returns in the `nextToken` parameter until all of your signing jobs have been returned.
 */
public suspend inline fun SignerClient.listSigningJobs(crossinline block: ListSigningJobsRequest.Builder.() -> Unit): ListSigningJobsResponse = listSigningJobs(ListSigningJobsRequest.Builder().apply(block).build())

/**
 * Lists all signing platforms available in AWS Signer that match the request parameters. If additional jobs remain to be listed, Signer returns a `nextToken` value. Use this value in subsequent calls to `ListSigningJobs` to fetch the remaining values. You can continue calling `ListSigningJobs` with your `maxResults` parameter and with new values that Signer returns in the `nextToken` parameter until all of your signing jobs have been returned.
 */
public suspend inline fun SignerClient.listSigningPlatforms(crossinline block: ListSigningPlatformsRequest.Builder.() -> Unit): ListSigningPlatformsResponse = listSigningPlatforms(ListSigningPlatformsRequest.Builder().apply(block).build())

/**
 * Lists all available signing profiles in your AWS account. Returns only profiles with an `ACTIVE` status unless the `includeCanceled` request field is set to `true`. If additional jobs remain to be listed, AWS Signer returns a `nextToken` value. Use this value in subsequent calls to `ListSigningJobs` to fetch the remaining values. You can continue calling `ListSigningJobs` with your `maxResults` parameter and with new values that Signer returns in the `nextToken` parameter until all of your signing jobs have been returned.
 */
public suspend inline fun SignerClient.listSigningProfiles(crossinline block: ListSigningProfilesRequest.Builder.() -> Unit): ListSigningProfilesResponse = listSigningProfiles(ListSigningProfilesRequest.Builder().apply(block).build())

/**
 * Returns a list of the tags associated with a signing profile resource.
 */
public suspend inline fun SignerClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Creates a signing profile. A signing profile is a code-signing template that can be used to carry out a pre-defined signing job.
 */
public suspend inline fun SignerClient.putSigningProfile(crossinline block: PutSigningProfileRequest.Builder.() -> Unit): PutSigningProfileResponse = putSigningProfile(PutSigningProfileRequest.Builder().apply(block).build())

/**
 * Removes cross-account permissions from a signing profile.
 */
public suspend inline fun SignerClient.removeProfilePermission(crossinline block: RemoveProfilePermissionRequest.Builder.() -> Unit): RemoveProfilePermissionResponse = removeProfilePermission(RemoveProfilePermissionRequest.Builder().apply(block).build())

/**
 * Changes the state of a signing job to REVOKED. This indicates that the signature is no longer valid.
 */
public suspend inline fun SignerClient.revokeSignature(crossinline block: RevokeSignatureRequest.Builder.() -> Unit): RevokeSignatureResponse = revokeSignature(RevokeSignatureRequest.Builder().apply(block).build())

/**
 * Changes the state of a signing profile to REVOKED. This indicates that signatures generated using the signing profile after an effective start date are no longer valid.
 */
public suspend inline fun SignerClient.revokeSigningProfile(crossinline block: RevokeSigningProfileRequest.Builder.() -> Unit): RevokeSigningProfileResponse = revokeSigningProfile(RevokeSigningProfileRequest.Builder().apply(block).build())

/**
 * Signs a binary payload and returns a signature envelope.
 */
public suspend inline fun SignerClient.signPayload(crossinline block: SignPayloadRequest.Builder.() -> Unit): SignPayloadResponse = signPayload(SignPayloadRequest.Builder().apply(block).build())

/**
 * Initiates a signing job to be performed on the code provided. Signing jobs are viewable by the `ListSigningJobs` operation for two years after they are performed. Note the following requirements:
 * +  You must create an Amazon S3 source bucket. For more information, see [Creating a Bucket](http://docs.aws.amazon.com/AmazonS3/latest/gsg/CreatingABucket.html) in the *Amazon S3 Getting Started Guide*.
 * + Your S3 source bucket must be version enabled.
 * + You must create an S3 destination bucket. AWS Signer uses your S3 destination bucket to write your signed code.
 * + You specify the name of the source and destination buckets when calling the `StartSigningJob` operation.
 * + You must also specify a request token that identifies your request to Signer.
 *
 * You can call the DescribeSigningJob and the ListSigningJobs actions after you call `StartSigningJob`.
 *
 * For a Java example that shows how to use this action, see [StartSigningJob](https://docs.aws.amazon.com/signer/latest/developerguide/api-startsigningjob.html).
 */
public suspend inline fun SignerClient.startSigningJob(crossinline block: StartSigningJobRequest.Builder.() -> Unit): StartSigningJobResponse = startSigningJob(StartSigningJobRequest.Builder().apply(block).build())

/**
 * Adds one or more tags to a signing profile. Tags are labels that you can use to identify and organize your AWS resources. Each tag consists of a key and an optional value. To specify the signing profile, use its Amazon Resource Name (ARN). To specify the tag, use a key-value pair.
 */
public suspend inline fun SignerClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes one or more tags from a signing profile. To remove the tags, specify a list of tag keys.
 */
public suspend inline fun SignerClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())
