// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.shield.transform

import aws.sdk.kotlin.services.shield.model.DisassociateDrtRoleResponse
import aws.sdk.kotlin.services.shield.model.ShieldException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class DisassociateDRTRoleOperationDeserializer: HttpDeserialize<DisassociateDrtRoleResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DisassociateDrtRoleResponse {
        if (!response.status.isSuccess()) {
            throwDisassociateDrtRoleError(context, response)
        }
        val builder = DisassociateDrtRoleResponse.Builder()

        return builder.build()
    }
}

private suspend fun throwDisassociateDrtRoleError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ShieldException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalErrorException" -> InternalErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidOperationException" -> InvalidOperationExceptionDeserializer().deserialize(context, wrappedResponse)
        "OptimisticLockException" -> OptimisticLockExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ShieldException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
