// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.shield.transform

import aws.sdk.kotlin.services.shield.model.CreateProtectionResponse
import aws.sdk.kotlin.services.shield.model.ShieldException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateProtectionOperationDeserializer: HttpDeserialize<CreateProtectionResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateProtectionResponse {
        if (!response.status.isSuccess()) {
            throwCreateProtectionError(context, response)
        }
        val builder = CreateProtectionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateProtectionOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateProtectionError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ShieldException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalErrorException" -> InternalErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidOperationException" -> InvalidOperationExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidResourceException" -> InvalidResourceExceptionDeserializer().deserialize(context, wrappedResponse)
        "LimitsExceededException" -> LimitsExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "OptimisticLockException" -> OptimisticLockExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceAlreadyExistsException" -> ResourceAlreadyExistsExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ShieldException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateProtectionOperationBody(builder: CreateProtectionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val PROTECTIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ProtectionId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(PROTECTIONID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                PROTECTIONID_DESCRIPTOR.index -> builder.protectionId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
