// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.shield.paginators

import aws.sdk.kotlin.services.shield.ShieldClient
import aws.sdk.kotlin.services.shield.model.AttackSummary
import aws.sdk.kotlin.services.shield.model.ListAttacksRequest
import aws.sdk.kotlin.services.shield.model.ListAttacksResponse
import aws.sdk.kotlin.services.shield.model.ListProtectionGroupsRequest
import aws.sdk.kotlin.services.shield.model.ListProtectionGroupsResponse
import aws.sdk.kotlin.services.shield.model.ListProtectionsRequest
import aws.sdk.kotlin.services.shield.model.ListProtectionsResponse
import aws.sdk.kotlin.services.shield.model.ListResourcesInProtectionGroupRequest
import aws.sdk.kotlin.services.shield.model.ListResourcesInProtectionGroupResponse
import aws.sdk.kotlin.services.shield.model.Protection
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListAttacksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAttacksRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAttacksResponse]
 */
public fun ShieldClient.listAttacksPaginated(initialRequest: ListAttacksRequest): Flow<ListAttacksResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAttacksPaginated.listAttacks(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAttacksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAttacksResponse]
 */
public fun ShieldClient.listAttacksPaginated(block: ListAttacksRequest.Builder.() -> Unit): Flow<ListAttacksResponse> =
    listAttacksPaginated(ListAttacksRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAttacksPaginated]
 * to access the nested member [AttackSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AttackSummary]
 */
@JvmName("listAttacksResponseAttackSummary")
public fun Flow<ListAttacksResponse>.attackSummaries(): Flow<AttackSummary> =
    transform() { response ->
        response.attackSummaries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListProtectionGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListProtectionGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListProtectionGroupsResponse]
 */
public fun ShieldClient.listProtectionGroupsPaginated(initialRequest: ListProtectionGroupsRequest): Flow<ListProtectionGroupsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listProtectionGroupsPaginated.listProtectionGroups(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListProtectionGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListProtectionGroupsResponse]
 */
public fun ShieldClient.listProtectionGroupsPaginated(block: ListProtectionGroupsRequest.Builder.() -> Unit): Flow<ListProtectionGroupsResponse> =
    listProtectionGroupsPaginated(ListProtectionGroupsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListProtectionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListProtectionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListProtectionsResponse]
 */
public fun ShieldClient.listProtectionsPaginated(initialRequest: ListProtectionsRequest): Flow<ListProtectionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listProtectionsPaginated.listProtections(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListProtectionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListProtectionsResponse]
 */
public fun ShieldClient.listProtectionsPaginated(block: ListProtectionsRequest.Builder.() -> Unit): Flow<ListProtectionsResponse> =
    listProtectionsPaginated(ListProtectionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listProtectionsPaginated]
 * to access the nested member [Protection]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Protection]
 */
@JvmName("listProtectionsResponseProtection")
public fun Flow<ListProtectionsResponse>.protections(): Flow<Protection> =
    transform() { response ->
        response.protections?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListResourcesInProtectionGroupResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListResourcesInProtectionGroupRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResourcesInProtectionGroupResponse]
 */
public fun ShieldClient.listResourcesInProtectionGroupPaginated(initialRequest: ListResourcesInProtectionGroupRequest): Flow<ListResourcesInProtectionGroupResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listResourcesInProtectionGroupPaginated.listResourcesInProtectionGroup(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListResourcesInProtectionGroupResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResourcesInProtectionGroupResponse]
 */
public fun ShieldClient.listResourcesInProtectionGroupPaginated(block: ListResourcesInProtectionGroupRequest.Builder.() -> Unit): Flow<ListResourcesInProtectionGroupResponse> =
    listResourcesInProtectionGroupPaginated(ListResourcesInProtectionGroupRequest.Builder().apply(block).build())
