// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.shield.model



/**
 * Specifies the action setting that Shield Advanced should use in the WAF rules that it creates on behalf of the protected resource in response to DDoS attacks. You specify this as part of the configuration for the automatic application layer DDoS mitigation feature, when you enable or update automatic mitigation. Shield Advanced creates the WAF rules in a Shield Advanced-managed rule group, inside the web ACL that you have associated with the resource.
 */
public class ResponseAction private constructor(builder: Builder) {
    /**
     * Specifies that Shield Advanced should configure its WAF rules with the WAF `Block` action.
     *
     * You must specify exactly one action, either `Block` or `Count`.
     */
    public val block: aws.sdk.kotlin.services.shield.model.BlockAction? = builder.block
    /**
     * Specifies that Shield Advanced should configure its WAF rules with the WAF `Count` action.
     *
     * You must specify exactly one action, either `Block` or `Count`.
     */
    public val count: aws.sdk.kotlin.services.shield.model.CountAction? = builder.count

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.shield.model.ResponseAction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResponseAction(")
        append("block=$block,")
        append("count=$count")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = block?.hashCode() ?: 0
        result = 31 * result + (count?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResponseAction

        if (block != other.block) return false
        if (count != other.count) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.shield.model.ResponseAction = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies that Shield Advanced should configure its WAF rules with the WAF `Block` action.
         *
         * You must specify exactly one action, either `Block` or `Count`.
         */
        public var block: aws.sdk.kotlin.services.shield.model.BlockAction? = null
        /**
         * Specifies that Shield Advanced should configure its WAF rules with the WAF `Count` action.
         *
         * You must specify exactly one action, either `Block` or `Count`.
         */
        public var count: aws.sdk.kotlin.services.shield.model.CountAction? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.shield.model.ResponseAction) : this() {
            this.block = x.block
            this.count = x.count
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.shield.model.ResponseAction = ResponseAction(this)

        /**
         * construct an [aws.sdk.kotlin.services.shield.model.BlockAction] inside the given [block]
         */
        public fun block(block: aws.sdk.kotlin.services.shield.model.BlockAction.Builder.() -> kotlin.Unit) {
            this.block = aws.sdk.kotlin.services.shield.model.BlockAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.shield.model.CountAction] inside the given [block]
         */
        public fun count(block: aws.sdk.kotlin.services.shield.model.CountAction.Builder.() -> kotlin.Unit) {
            this.count = aws.sdk.kotlin.services.shield.model.CountAction.invoke(block)
        }
    }
}
