// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.shield.model



public class ListProtectionsRequest private constructor(builder: Builder) {
    /**
     * Narrows the set of protections that the call retrieves. You can retrieve a single protection by providing its name or the ARN (Amazon Resource Name) of its protected resource. You can also retrieve all protections for a specific resource type. You can provide up to one criteria per filter type. Shield Advanced returns protections that exactly match all of the filter criteria that you provide.
     */
    public val inclusionFilters: aws.sdk.kotlin.services.shield.model.InclusionProtectionFilters? = builder.inclusionFilters
    /**
     * The greatest number of objects that you want Shield Advanced to return to the list request. Shield Advanced might return fewer objects than you indicate in this setting, even if more objects are available. If there are more objects remaining, Shield Advanced will always also return a `NextToken` value in the response.
     *
     * The default setting is 20.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * When you request a list of objects from Shield Advanced, if the response does not include all of the remaining available objects, Shield Advanced includes a `NextToken` value in the response. You can retrieve the next batch of objects by requesting the list again and providing the token that was returned by the prior call in your request.
     *
     * You can indicate the maximum number of objects that you want Shield Advanced to return for a single call with the `MaxResults` setting. Shield Advanced will not return more than `MaxResults` objects, but may return fewer, even if more objects are still available.
     *
     * Whenever more objects remain that Shield Advanced has not yet returned to you, the response will include a `NextToken` value.
     *
     * On your first call to a list operation, leave this setting empty.
     */
    public val nextToken: kotlin.String? = builder.nextToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.shield.model.ListProtectionsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListProtectionsRequest(")
        append("inclusionFilters=$inclusionFilters,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = inclusionFilters?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListProtectionsRequest

        if (inclusionFilters != other.inclusionFilters) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.shield.model.ListProtectionsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Narrows the set of protections that the call retrieves. You can retrieve a single protection by providing its name or the ARN (Amazon Resource Name) of its protected resource. You can also retrieve all protections for a specific resource type. You can provide up to one criteria per filter type. Shield Advanced returns protections that exactly match all of the filter criteria that you provide.
         */
        public var inclusionFilters: aws.sdk.kotlin.services.shield.model.InclusionProtectionFilters? = null
        /**
         * The greatest number of objects that you want Shield Advanced to return to the list request. Shield Advanced might return fewer objects than you indicate in this setting, even if more objects are available. If there are more objects remaining, Shield Advanced will always also return a `NextToken` value in the response.
         *
         * The default setting is 20.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * When you request a list of objects from Shield Advanced, if the response does not include all of the remaining available objects, Shield Advanced includes a `NextToken` value in the response. You can retrieve the next batch of objects by requesting the list again and providing the token that was returned by the prior call in your request.
         *
         * You can indicate the maximum number of objects that you want Shield Advanced to return for a single call with the `MaxResults` setting. Shield Advanced will not return more than `MaxResults` objects, but may return fewer, even if more objects are still available.
         *
         * Whenever more objects remain that Shield Advanced has not yet returned to you, the response will include a `NextToken` value.
         *
         * On your first call to a list operation, leave this setting empty.
         */
        public var nextToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.shield.model.ListProtectionsRequest) : this() {
            this.inclusionFilters = x.inclusionFilters
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.shield.model.ListProtectionsRequest = ListProtectionsRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.shield.model.InclusionProtectionFilters] inside the given [block]
         */
        public fun inclusionFilters(block: aws.sdk.kotlin.services.shield.model.InclusionProtectionFilters.Builder.() -> kotlin.Unit) {
            this.inclusionFilters = aws.sdk.kotlin.services.shield.model.InclusionProtectionFilters.invoke(block)
        }
    }
}
