// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.shield

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.shield.endpoints.DefaultEndpointProvider
import aws.sdk.kotlin.services.shield.endpoints.EndpointParameters
import aws.sdk.kotlin.services.shield.endpoints.EndpointProvider
import aws.sdk.kotlin.services.shield.model.AssociateDrtLogBucketRequest
import aws.sdk.kotlin.services.shield.model.AssociateDrtLogBucketResponse
import aws.sdk.kotlin.services.shield.model.AssociateDrtRoleRequest
import aws.sdk.kotlin.services.shield.model.AssociateDrtRoleResponse
import aws.sdk.kotlin.services.shield.model.AssociateHealthCheckRequest
import aws.sdk.kotlin.services.shield.model.AssociateHealthCheckResponse
import aws.sdk.kotlin.services.shield.model.AssociateProactiveEngagementDetailsRequest
import aws.sdk.kotlin.services.shield.model.AssociateProactiveEngagementDetailsResponse
import aws.sdk.kotlin.services.shield.model.CreateProtectionGroupRequest
import aws.sdk.kotlin.services.shield.model.CreateProtectionGroupResponse
import aws.sdk.kotlin.services.shield.model.CreateProtectionRequest
import aws.sdk.kotlin.services.shield.model.CreateProtectionResponse
import aws.sdk.kotlin.services.shield.model.CreateSubscriptionRequest
import aws.sdk.kotlin.services.shield.model.CreateSubscriptionResponse
import aws.sdk.kotlin.services.shield.model.DeleteProtectionGroupRequest
import aws.sdk.kotlin.services.shield.model.DeleteProtectionGroupResponse
import aws.sdk.kotlin.services.shield.model.DeleteProtectionRequest
import aws.sdk.kotlin.services.shield.model.DeleteProtectionResponse
import aws.sdk.kotlin.services.shield.model.DeleteSubscriptionRequest
import aws.sdk.kotlin.services.shield.model.DeleteSubscriptionResponse
import aws.sdk.kotlin.services.shield.model.DescribeAttackRequest
import aws.sdk.kotlin.services.shield.model.DescribeAttackResponse
import aws.sdk.kotlin.services.shield.model.DescribeAttackStatisticsRequest
import aws.sdk.kotlin.services.shield.model.DescribeAttackStatisticsResponse
import aws.sdk.kotlin.services.shield.model.DescribeDrtAccessRequest
import aws.sdk.kotlin.services.shield.model.DescribeDrtAccessResponse
import aws.sdk.kotlin.services.shield.model.DescribeEmergencyContactSettingsRequest
import aws.sdk.kotlin.services.shield.model.DescribeEmergencyContactSettingsResponse
import aws.sdk.kotlin.services.shield.model.DescribeProtectionGroupRequest
import aws.sdk.kotlin.services.shield.model.DescribeProtectionGroupResponse
import aws.sdk.kotlin.services.shield.model.DescribeProtectionRequest
import aws.sdk.kotlin.services.shield.model.DescribeProtectionResponse
import aws.sdk.kotlin.services.shield.model.DescribeSubscriptionRequest
import aws.sdk.kotlin.services.shield.model.DescribeSubscriptionResponse
import aws.sdk.kotlin.services.shield.model.DisableApplicationLayerAutomaticResponseRequest
import aws.sdk.kotlin.services.shield.model.DisableApplicationLayerAutomaticResponseResponse
import aws.sdk.kotlin.services.shield.model.DisableProactiveEngagementRequest
import aws.sdk.kotlin.services.shield.model.DisableProactiveEngagementResponse
import aws.sdk.kotlin.services.shield.model.DisassociateDrtLogBucketRequest
import aws.sdk.kotlin.services.shield.model.DisassociateDrtLogBucketResponse
import aws.sdk.kotlin.services.shield.model.DisassociateDrtRoleRequest
import aws.sdk.kotlin.services.shield.model.DisassociateDrtRoleResponse
import aws.sdk.kotlin.services.shield.model.DisassociateHealthCheckRequest
import aws.sdk.kotlin.services.shield.model.DisassociateHealthCheckResponse
import aws.sdk.kotlin.services.shield.model.EnableApplicationLayerAutomaticResponseRequest
import aws.sdk.kotlin.services.shield.model.EnableApplicationLayerAutomaticResponseResponse
import aws.sdk.kotlin.services.shield.model.EnableProactiveEngagementRequest
import aws.sdk.kotlin.services.shield.model.EnableProactiveEngagementResponse
import aws.sdk.kotlin.services.shield.model.GetSubscriptionStateRequest
import aws.sdk.kotlin.services.shield.model.GetSubscriptionStateResponse
import aws.sdk.kotlin.services.shield.model.ListAttacksRequest
import aws.sdk.kotlin.services.shield.model.ListAttacksResponse
import aws.sdk.kotlin.services.shield.model.ListProtectionGroupsRequest
import aws.sdk.kotlin.services.shield.model.ListProtectionGroupsResponse
import aws.sdk.kotlin.services.shield.model.ListProtectionsRequest
import aws.sdk.kotlin.services.shield.model.ListProtectionsResponse
import aws.sdk.kotlin.services.shield.model.ListResourcesInProtectionGroupRequest
import aws.sdk.kotlin.services.shield.model.ListResourcesInProtectionGroupResponse
import aws.sdk.kotlin.services.shield.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.shield.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.shield.model.TagResourceRequest
import aws.sdk.kotlin.services.shield.model.TagResourceResponse
import aws.sdk.kotlin.services.shield.model.UntagResourceRequest
import aws.sdk.kotlin.services.shield.model.UntagResourceResponse
import aws.sdk.kotlin.services.shield.model.UpdateApplicationLayerAutomaticResponseRequest
import aws.sdk.kotlin.services.shield.model.UpdateApplicationLayerAutomaticResponseResponse
import aws.sdk.kotlin.services.shield.model.UpdateEmergencyContactSettingsRequest
import aws.sdk.kotlin.services.shield.model.UpdateEmergencyContactSettingsResponse
import aws.sdk.kotlin.services.shield.model.UpdateProtectionGroupRequest
import aws.sdk.kotlin.services.shield.model.UpdateProtectionGroupResponse
import aws.sdk.kotlin.services.shield.model.UpdateSubscriptionRequest
import aws.sdk.kotlin.services.shield.model.UpdateSubscriptionResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.auth.HttpAuthScheme
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.tracing.DefaultTracer
import aws.smithy.kotlin.runtime.tracing.LoggingTraceProbe
import aws.smithy.kotlin.runtime.tracing.Tracer
import aws.smithy.kotlin.runtime.tracing.TracingClientConfig
import kotlin.collections.List
import kotlin.jvm.JvmStatic

/**
 * # Shield Advanced
 * This is the *Shield Advanced API Reference*. This guide is for developers who need detailed information about the Shield Advanced API actions, data types, and errors. For detailed information about WAF and Shield Advanced features and an overview of how to use the WAF and Shield Advanced APIs, see the [WAF and Shield Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
 */
public interface ShieldClient : SdkClient {
    /**
     * ShieldClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, ShieldClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, ShieldClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): ShieldClient = DefaultShieldClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), SdkClientConfig, TracingClientConfig {
        override val clientName: String = builder.clientName
        override val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.HttpAuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: EndpointProvider = builder.endpointProvider ?: DefaultEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsDefaultRetryPolicy
        override val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val tracer: Tracer = builder.tracer ?: DefaultTracer(LoggingTraceProbe, clientName)
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            tracer = this@Config.tracer
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TracingClientConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Shield"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [HttpAuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.HttpAuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: EndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            override var retryStrategy: RetryStrategy? = null

            /**
             * The tracer that is responsible for creating trace spans and wiring them up to a tracing backend (e.g.,
             * a trace probe). By default, this will create a standard tracer that uses the service name for the root
             * trace span and delegates to a logging trace probe (i.e.,
             * `DefaultTracer(LoggingTraceProbe, "<service-name>")`).
             */
            override var tracer: Tracer? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Authorizes the Shield Response Team (SRT) to access the specified Amazon S3 bucket containing log data such as Application Load Balancer access logs, CloudFront logs, or logs from third party sources. You can associate up to 10 Amazon S3 buckets with your subscription.
     *
     * To use the services of the SRT and make an `AssociateDRTLogBucket` request, you must be subscribed to the [Business Support plan](http://aws.amazon.com/premiumsupport/business-support/) or the [Enterprise Support plan](http://aws.amazon.com/premiumsupport/enterprise-support/).
     */
    public suspend fun associateDrtLogBucket(input: AssociateDrtLogBucketRequest): AssociateDrtLogBucketResponse

    /**
     * Authorizes the Shield Response Team (SRT) using the specified role, to access your Amazon Web Services account to assist with DDoS attack mitigation during potential attacks. This enables the SRT to inspect your WAF configuration and create or update WAF rules and web ACLs.
     *
     * You can associate only one `RoleArn` with your subscription. If you submit an `AssociateDRTRole` request for an account that already has an associated role, the new `RoleArn` will replace the existing `RoleArn`.
     *
     * Prior to making the `AssociateDRTRole` request, you must attach the `AWSShieldDRTAccessPolicy` managed policy to the role that you'll specify in the request. You can access this policy in the IAM console at [AWSShieldDRTAccessPolicy](https://console.aws.amazon.com/iam/home?#/policies/arn:aws:iam::aws:policy/service-role/AWSShieldDRTAccessPolicy). For more information see [Adding and removing IAM identity permissions](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_manage-attach-detach.html). The role must also trust the service principal `drt.shield.amazonaws.com`. For more information, see [IAM JSON policy elements: Principal](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html).
     *
     * The SRT will have access only to your WAF and Shield resources. By submitting this request, you authorize the SRT to inspect your WAF and Shield configuration and create and update WAF rules and web ACLs on your behalf. The SRT takes these actions only if explicitly authorized by you.
     *
     * You must have the `iam:PassRole` permission to make an `AssociateDRTRole` request. For more information, see [Granting a user permissions to pass a role to an Amazon Web Services service](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html).
     *
     * To use the services of the SRT and make an `AssociateDRTRole` request, you must be subscribed to the [Business Support plan](http://aws.amazon.com/premiumsupport/business-support/) or the [Enterprise Support plan](http://aws.amazon.com/premiumsupport/enterprise-support/).
     */
    public suspend fun associateDrtRole(input: AssociateDrtRoleRequest): AssociateDrtRoleResponse

    /**
     * Adds health-based detection to the Shield Advanced protection for a resource. Shield Advanced health-based detection uses the health of your Amazon Web Services resource to improve responsiveness and accuracy in attack detection and response.
     *
     * You define the health check in Route 53 and then associate it with your Shield Advanced protection. For more information, see [Shield Advanced Health-Based Detection](https://docs.aws.amazon.com/waf/latest/developerguide/ddos-overview.html#ddos-advanced-health-check-option) in the *WAF Developer Guide*.
     */
    public suspend fun associateHealthCheck(input: AssociateHealthCheckRequest): AssociateHealthCheckResponse

    /**
     * Initializes proactive engagement and sets the list of contacts for the Shield Response Team (SRT) to use. You must provide at least one phone number in the emergency contact list.
     *
     * After you have initialized proactive engagement using this call, to disable or enable proactive engagement, use the calls `DisableProactiveEngagement` and `EnableProactiveEngagement`.
     *
     * This call defines the list of email addresses and phone numbers that the SRT can use to contact you for escalations to the SRT and to initiate proactive customer support.
     *
     * The contacts that you provide in the request replace any contacts that were already defined. If you already have contacts defined and want to use them, retrieve the list using `DescribeEmergencyContactSettings` and then provide it to this call.
     */
    public suspend fun associateProactiveEngagementDetails(input: AssociateProactiveEngagementDetailsRequest): AssociateProactiveEngagementDetailsResponse

    /**
     * Enables Shield Advanced for a specific Amazon Web Services resource. The resource can be an Amazon CloudFront distribution, Amazon Route 53 hosted zone, Global Accelerator standard accelerator, Elastic IP Address, Application Load Balancer, or a Classic Load Balancer. You can protect Amazon EC2 instances and Network Load Balancers by association with protected Amazon EC2 Elastic IP addresses.
     *
     * You can add protection to only a single resource with each `CreateProtection` request. You can add protection to multiple resources at once through the Shield Advanced console at [https://console.aws.amazon.com/wafv2/shieldv2#/](https://console.aws.amazon.com/wafv2/shieldv2#/). For more information see [Getting Started with Shield Advanced](https://docs.aws.amazon.com/waf/latest/developerguide/getting-started-ddos.html) and [Adding Shield Advanced protection to Amazon Web Services resources](https://docs.aws.amazon.com/waf/latest/developerguide/configure-new-protection.html).
     */
    public suspend fun createProtection(input: CreateProtectionRequest): CreateProtectionResponse

    /**
     * Creates a grouping of protected resources so they can be handled as a collective. This resource grouping improves the accuracy of detection and reduces false positives.
     */
    public suspend fun createProtectionGroup(input: CreateProtectionGroupRequest): CreateProtectionGroupResponse

    /**
     * Activates Shield Advanced for an account.
     *
     * For accounts that are members of an Organizations organization, Shield Advanced subscriptions are billed against the organization's payer account, regardless of whether the payer account itself is subscribed.
     *
     * When you initially create a subscription, your subscription is set to be automatically renewed at the end of the existing subscription period. You can change this by submitting an `UpdateSubscription` request.
     */
    public suspend fun createSubscription(input: CreateSubscriptionRequest = CreateSubscriptionRequest {}): CreateSubscriptionResponse

    /**
     * Deletes an Shield Advanced Protection.
     */
    public suspend fun deleteProtection(input: DeleteProtectionRequest): DeleteProtectionResponse

    /**
     * Removes the specified protection group.
     */
    public suspend fun deleteProtectionGroup(input: DeleteProtectionGroupRequest): DeleteProtectionGroupResponse

    /**
     * Removes Shield Advanced from an account. Shield Advanced requires a 1-year subscription commitment. You cannot delete a subscription prior to the completion of that commitment.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun deleteSubscription(input: DeleteSubscriptionRequest = DeleteSubscriptionRequest {}): DeleteSubscriptionResponse

    /**
     * Describes the details of a DDoS attack.
     */
    public suspend fun describeAttack(input: DescribeAttackRequest): DescribeAttackResponse

    /**
     * Provides information about the number and type of attacks Shield has detected in the last year for all resources that belong to your account, regardless of whether you've defined Shield protections for them. This operation is available to Shield customers as well as to Shield Advanced customers.
     *
     * The operation returns data for the time range of midnight UTC, one year ago, to midnight UTC, today. For example, if the current time is `2020-10-26 15:39:32 PDT`, equal to `2020-10-26 22:39:32 UTC`, then the time range for the attack data returned is from `2019-10-26 00:00:00 UTC` to `2020-10-26 00:00:00 UTC`.
     *
     * The time range indicates the period covered by the attack statistics data items.
     */
    public suspend fun describeAttackStatistics(input: DescribeAttackStatisticsRequest = DescribeAttackStatisticsRequest {}): DescribeAttackStatisticsResponse

    /**
     * Returns the current role and list of Amazon S3 log buckets used by the Shield Response Team (SRT) to access your Amazon Web Services account while assisting with attack mitigation.
     */
    public suspend fun describeDrtAccess(input: DescribeDrtAccessRequest = DescribeDrtAccessRequest {}): DescribeDrtAccessResponse

    /**
     * A list of email addresses and phone numbers that the Shield Response Team (SRT) can use to contact you if you have proactive engagement enabled, for escalations to the SRT and to initiate proactive customer support.
     */
    public suspend fun describeEmergencyContactSettings(input: DescribeEmergencyContactSettingsRequest = DescribeEmergencyContactSettingsRequest {}): DescribeEmergencyContactSettingsResponse

    /**
     * Lists the details of a Protection object.
     */
    public suspend fun describeProtection(input: DescribeProtectionRequest = DescribeProtectionRequest {}): DescribeProtectionResponse

    /**
     * Returns the specification for the specified protection group.
     */
    public suspend fun describeProtectionGroup(input: DescribeProtectionGroupRequest): DescribeProtectionGroupResponse

    /**
     * Provides details about the Shield Advanced subscription for an account.
     */
    public suspend fun describeSubscription(input: DescribeSubscriptionRequest = DescribeSubscriptionRequest {}): DescribeSubscriptionResponse

    /**
     * Disable the Shield Advanced automatic application layer DDoS mitigation feature for the protected resource. This stops Shield Advanced from creating, verifying, and applying WAF rules for attacks that it detects for the resource.
     */
    public suspend fun disableApplicationLayerAutomaticResponse(input: DisableApplicationLayerAutomaticResponseRequest): DisableApplicationLayerAutomaticResponseResponse

    /**
     * Removes authorization from the Shield Response Team (SRT) to notify contacts about escalations to the SRT and to initiate proactive customer support.
     */
    public suspend fun disableProactiveEngagement(input: DisableProactiveEngagementRequest = DisableProactiveEngagementRequest {}): DisableProactiveEngagementResponse

    /**
     * Removes the Shield Response Team's (SRT) access to the specified Amazon S3 bucket containing the logs that you shared previously.
     */
    public suspend fun disassociateDrtLogBucket(input: DisassociateDrtLogBucketRequest): DisassociateDrtLogBucketResponse

    /**
     * Removes the Shield Response Team's (SRT) access to your Amazon Web Services account.
     */
    public suspend fun disassociateDrtRole(input: DisassociateDrtRoleRequest = DisassociateDrtRoleRequest {}): DisassociateDrtRoleResponse

    /**
     * Removes health-based detection from the Shield Advanced protection for a resource. Shield Advanced health-based detection uses the health of your Amazon Web Services resource to improve responsiveness and accuracy in attack detection and response.
     *
     * You define the health check in Route 53 and then associate or disassociate it with your Shield Advanced protection. For more information, see [Shield Advanced Health-Based Detection](https://docs.aws.amazon.com/waf/latest/developerguide/ddos-overview.html#ddos-advanced-health-check-option) in the *WAF Developer Guide*.
     */
    public suspend fun disassociateHealthCheck(input: DisassociateHealthCheckRequest): DisassociateHealthCheckResponse

    /**
     * Enable the Shield Advanced automatic application layer DDoS mitigation for the protected resource.
     *
     * This feature is available for Amazon CloudFront distributions and Application Load Balancers only.
     *
     * This causes Shield Advanced to create, verify, and apply WAF rules for DDoS attacks that it detects for the resource. Shield Advanced applies the rules in a Shield rule group inside the web ACL that you've associated with the resource. For information about how automatic mitigation works and the requirements for using it, see [Shield Advanced automatic application layer DDoS mitigation](https://docs.aws.amazon.com/waf/latest/developerguide/ddos-advanced-automatic-app-layer-response.html).
     *
     * Don't use this action to make changes to automatic mitigation settings when it's already enabled for a resource. Instead, use UpdateApplicationLayerAutomaticResponse.
     *
     * To use this feature, you must associate a web ACL with the protected resource. The web ACL must be created using the latest version of WAF (v2). You can associate the web ACL through the Shield Advanced console at [https://console.aws.amazon.com/wafv2/shieldv2#/](https://console.aws.amazon.com/wafv2/shieldv2#/). For more information, see [Getting Started with Shield Advanced](https://docs.aws.amazon.com/waf/latest/developerguide/getting-started-ddos.html). You can also associate the web ACL to the resource through the WAF console or the WAF API, but you must manage Shield Advanced automatic mitigation through Shield Advanced. For information about WAF, see [WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
     */
    public suspend fun enableApplicationLayerAutomaticResponse(input: EnableApplicationLayerAutomaticResponseRequest): EnableApplicationLayerAutomaticResponseResponse

    /**
     * Authorizes the Shield Response Team (SRT) to use email and phone to notify contacts about escalations to the SRT and to initiate proactive customer support.
     */
    public suspend fun enableProactiveEngagement(input: EnableProactiveEngagementRequest = EnableProactiveEngagementRequest {}): EnableProactiveEngagementResponse

    /**
     * Returns the `SubscriptionState`, either `Active` or `Inactive`.
     */
    public suspend fun getSubscriptionState(input: GetSubscriptionStateRequest = GetSubscriptionStateRequest {}): GetSubscriptionStateResponse

    /**
     * Returns all ongoing DDoS attacks or all DDoS attacks during a specified time period.
     */
    public suspend fun listAttacks(input: ListAttacksRequest = ListAttacksRequest {}): ListAttacksResponse

    /**
     * Retrieves ProtectionGroup objects for the account. You can retrieve all protection groups or you can provide filtering criteria and retrieve just the subset of protection groups that match the criteria.
     */
    public suspend fun listProtectionGroups(input: ListProtectionGroupsRequest = ListProtectionGroupsRequest {}): ListProtectionGroupsResponse

    /**
     * Retrieves Protection objects for the account. You can retrieve all protections or you can provide filtering criteria and retrieve just the subset of protections that match the criteria.
     */
    public suspend fun listProtections(input: ListProtectionsRequest = ListProtectionsRequest {}): ListProtectionsResponse

    /**
     * Retrieves the resources that are included in the protection group.
     */
    public suspend fun listResourcesInProtectionGroup(input: ListResourcesInProtectionGroupRequest): ListResourcesInProtectionGroupResponse

    /**
     * Gets information about Amazon Web Services tags for a specified Amazon Resource Name (ARN) in Shield.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Adds or updates tags for a resource in Shield.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes tags from a resource in Shield.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates an existing Shield Advanced automatic application layer DDoS mitigation configuration for the specified resource.
     */
    public suspend fun updateApplicationLayerAutomaticResponse(input: UpdateApplicationLayerAutomaticResponseRequest): UpdateApplicationLayerAutomaticResponseResponse

    /**
     * Updates the details of the list of email addresses and phone numbers that the Shield Response Team (SRT) can use to contact you if you have proactive engagement enabled, for escalations to the SRT and to initiate proactive customer support.
     */
    public suspend fun updateEmergencyContactSettings(input: UpdateEmergencyContactSettingsRequest = UpdateEmergencyContactSettingsRequest {}): UpdateEmergencyContactSettingsResponse

    /**
     * Updates an existing protection group. A protection group is a grouping of protected resources so they can be handled as a collective. This resource grouping improves the accuracy of detection and reduces false positives.
     */
    public suspend fun updateProtectionGroup(input: UpdateProtectionGroupRequest): UpdateProtectionGroupResponse

    /**
     * Updates the details of an existing subscription. Only enter values for parameters you want to change. Empty parameters are not updated.
     *
     * For accounts that are members of an Organizations organization, Shield Advanced subscriptions are billed against the organization's payer account, regardless of whether the payer account itself is subscribed.
     */
    public suspend fun updateSubscription(input: UpdateSubscriptionRequest = UpdateSubscriptionRequest {}): UpdateSubscriptionResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun ShieldClient.withConfig(block: ShieldClient.Config.Builder.() -> Unit): ShieldClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultShieldClient(newConfig)
}

/**
 * Authorizes the Shield Response Team (SRT) to access the specified Amazon S3 bucket containing log data such as Application Load Balancer access logs, CloudFront logs, or logs from third party sources. You can associate up to 10 Amazon S3 buckets with your subscription.
 *
 * To use the services of the SRT and make an `AssociateDRTLogBucket` request, you must be subscribed to the [Business Support plan](http://aws.amazon.com/premiumsupport/business-support/) or the [Enterprise Support plan](http://aws.amazon.com/premiumsupport/enterprise-support/).
 */
public suspend inline fun ShieldClient.associateDrtLogBucket(crossinline block: AssociateDrtLogBucketRequest.Builder.() -> Unit): AssociateDrtLogBucketResponse = associateDrtLogBucket(AssociateDrtLogBucketRequest.Builder().apply(block).build())

/**
 * Authorizes the Shield Response Team (SRT) using the specified role, to access your Amazon Web Services account to assist with DDoS attack mitigation during potential attacks. This enables the SRT to inspect your WAF configuration and create or update WAF rules and web ACLs.
 *
 * You can associate only one `RoleArn` with your subscription. If you submit an `AssociateDRTRole` request for an account that already has an associated role, the new `RoleArn` will replace the existing `RoleArn`.
 *
 * Prior to making the `AssociateDRTRole` request, you must attach the `AWSShieldDRTAccessPolicy` managed policy to the role that you'll specify in the request. You can access this policy in the IAM console at [AWSShieldDRTAccessPolicy](https://console.aws.amazon.com/iam/home?#/policies/arn:aws:iam::aws:policy/service-role/AWSShieldDRTAccessPolicy). For more information see [Adding and removing IAM identity permissions](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_manage-attach-detach.html). The role must also trust the service principal `drt.shield.amazonaws.com`. For more information, see [IAM JSON policy elements: Principal](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html).
 *
 * The SRT will have access only to your WAF and Shield resources. By submitting this request, you authorize the SRT to inspect your WAF and Shield configuration and create and update WAF rules and web ACLs on your behalf. The SRT takes these actions only if explicitly authorized by you.
 *
 * You must have the `iam:PassRole` permission to make an `AssociateDRTRole` request. For more information, see [Granting a user permissions to pass a role to an Amazon Web Services service](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html).
 *
 * To use the services of the SRT and make an `AssociateDRTRole` request, you must be subscribed to the [Business Support plan](http://aws.amazon.com/premiumsupport/business-support/) or the [Enterprise Support plan](http://aws.amazon.com/premiumsupport/enterprise-support/).
 */
public suspend inline fun ShieldClient.associateDrtRole(crossinline block: AssociateDrtRoleRequest.Builder.() -> Unit): AssociateDrtRoleResponse = associateDrtRole(AssociateDrtRoleRequest.Builder().apply(block).build())

/**
 * Adds health-based detection to the Shield Advanced protection for a resource. Shield Advanced health-based detection uses the health of your Amazon Web Services resource to improve responsiveness and accuracy in attack detection and response.
 *
 * You define the health check in Route 53 and then associate it with your Shield Advanced protection. For more information, see [Shield Advanced Health-Based Detection](https://docs.aws.amazon.com/waf/latest/developerguide/ddos-overview.html#ddos-advanced-health-check-option) in the *WAF Developer Guide*.
 */
public suspend inline fun ShieldClient.associateHealthCheck(crossinline block: AssociateHealthCheckRequest.Builder.() -> Unit): AssociateHealthCheckResponse = associateHealthCheck(AssociateHealthCheckRequest.Builder().apply(block).build())

/**
 * Initializes proactive engagement and sets the list of contacts for the Shield Response Team (SRT) to use. You must provide at least one phone number in the emergency contact list.
 *
 * After you have initialized proactive engagement using this call, to disable or enable proactive engagement, use the calls `DisableProactiveEngagement` and `EnableProactiveEngagement`.
 *
 * This call defines the list of email addresses and phone numbers that the SRT can use to contact you for escalations to the SRT and to initiate proactive customer support.
 *
 * The contacts that you provide in the request replace any contacts that were already defined. If you already have contacts defined and want to use them, retrieve the list using `DescribeEmergencyContactSettings` and then provide it to this call.
 */
public suspend inline fun ShieldClient.associateProactiveEngagementDetails(crossinline block: AssociateProactiveEngagementDetailsRequest.Builder.() -> Unit): AssociateProactiveEngagementDetailsResponse = associateProactiveEngagementDetails(AssociateProactiveEngagementDetailsRequest.Builder().apply(block).build())

/**
 * Enables Shield Advanced for a specific Amazon Web Services resource. The resource can be an Amazon CloudFront distribution, Amazon Route 53 hosted zone, Global Accelerator standard accelerator, Elastic IP Address, Application Load Balancer, or a Classic Load Balancer. You can protect Amazon EC2 instances and Network Load Balancers by association with protected Amazon EC2 Elastic IP addresses.
 *
 * You can add protection to only a single resource with each `CreateProtection` request. You can add protection to multiple resources at once through the Shield Advanced console at [https://console.aws.amazon.com/wafv2/shieldv2#/](https://console.aws.amazon.com/wafv2/shieldv2#/). For more information see [Getting Started with Shield Advanced](https://docs.aws.amazon.com/waf/latest/developerguide/getting-started-ddos.html) and [Adding Shield Advanced protection to Amazon Web Services resources](https://docs.aws.amazon.com/waf/latest/developerguide/configure-new-protection.html).
 */
public suspend inline fun ShieldClient.createProtection(crossinline block: CreateProtectionRequest.Builder.() -> Unit): CreateProtectionResponse = createProtection(CreateProtectionRequest.Builder().apply(block).build())

/**
 * Creates a grouping of protected resources so they can be handled as a collective. This resource grouping improves the accuracy of detection and reduces false positives.
 */
public suspend inline fun ShieldClient.createProtectionGroup(crossinline block: CreateProtectionGroupRequest.Builder.() -> Unit): CreateProtectionGroupResponse = createProtectionGroup(CreateProtectionGroupRequest.Builder().apply(block).build())

/**
 * Activates Shield Advanced for an account.
 *
 * For accounts that are members of an Organizations organization, Shield Advanced subscriptions are billed against the organization's payer account, regardless of whether the payer account itself is subscribed.
 *
 * When you initially create a subscription, your subscription is set to be automatically renewed at the end of the existing subscription period. You can change this by submitting an `UpdateSubscription` request.
 */
public suspend inline fun ShieldClient.createSubscription(crossinline block: CreateSubscriptionRequest.Builder.() -> Unit): CreateSubscriptionResponse = createSubscription(CreateSubscriptionRequest.Builder().apply(block).build())

/**
 * Deletes an Shield Advanced Protection.
 */
public suspend inline fun ShieldClient.deleteProtection(crossinline block: DeleteProtectionRequest.Builder.() -> Unit): DeleteProtectionResponse = deleteProtection(DeleteProtectionRequest.Builder().apply(block).build())

/**
 * Removes the specified protection group.
 */
public suspend inline fun ShieldClient.deleteProtectionGroup(crossinline block: DeleteProtectionGroupRequest.Builder.() -> Unit): DeleteProtectionGroupResponse = deleteProtectionGroup(DeleteProtectionGroupRequest.Builder().apply(block).build())

/**
 * Removes Shield Advanced from an account. Shield Advanced requires a 1-year subscription commitment. You cannot delete a subscription prior to the completion of that commitment.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun ShieldClient.deleteSubscription(crossinline block: DeleteSubscriptionRequest.Builder.() -> Unit): DeleteSubscriptionResponse = deleteSubscription(DeleteSubscriptionRequest.Builder().apply(block).build())

/**
 * Describes the details of a DDoS attack.
 */
public suspend inline fun ShieldClient.describeAttack(crossinline block: DescribeAttackRequest.Builder.() -> Unit): DescribeAttackResponse = describeAttack(DescribeAttackRequest.Builder().apply(block).build())

/**
 * Provides information about the number and type of attacks Shield has detected in the last year for all resources that belong to your account, regardless of whether you've defined Shield protections for them. This operation is available to Shield customers as well as to Shield Advanced customers.
 *
 * The operation returns data for the time range of midnight UTC, one year ago, to midnight UTC, today. For example, if the current time is `2020-10-26 15:39:32 PDT`, equal to `2020-10-26 22:39:32 UTC`, then the time range for the attack data returned is from `2019-10-26 00:00:00 UTC` to `2020-10-26 00:00:00 UTC`.
 *
 * The time range indicates the period covered by the attack statistics data items.
 */
public suspend inline fun ShieldClient.describeAttackStatistics(crossinline block: DescribeAttackStatisticsRequest.Builder.() -> Unit): DescribeAttackStatisticsResponse = describeAttackStatistics(DescribeAttackStatisticsRequest.Builder().apply(block).build())

/**
 * Returns the current role and list of Amazon S3 log buckets used by the Shield Response Team (SRT) to access your Amazon Web Services account while assisting with attack mitigation.
 */
public suspend inline fun ShieldClient.describeDrtAccess(crossinline block: DescribeDrtAccessRequest.Builder.() -> Unit): DescribeDrtAccessResponse = describeDrtAccess(DescribeDrtAccessRequest.Builder().apply(block).build())

/**
 * A list of email addresses and phone numbers that the Shield Response Team (SRT) can use to contact you if you have proactive engagement enabled, for escalations to the SRT and to initiate proactive customer support.
 */
public suspend inline fun ShieldClient.describeEmergencyContactSettings(crossinline block: DescribeEmergencyContactSettingsRequest.Builder.() -> Unit): DescribeEmergencyContactSettingsResponse = describeEmergencyContactSettings(DescribeEmergencyContactSettingsRequest.Builder().apply(block).build())

/**
 * Lists the details of a Protection object.
 */
public suspend inline fun ShieldClient.describeProtection(crossinline block: DescribeProtectionRequest.Builder.() -> Unit): DescribeProtectionResponse = describeProtection(DescribeProtectionRequest.Builder().apply(block).build())

/**
 * Returns the specification for the specified protection group.
 */
public suspend inline fun ShieldClient.describeProtectionGroup(crossinline block: DescribeProtectionGroupRequest.Builder.() -> Unit): DescribeProtectionGroupResponse = describeProtectionGroup(DescribeProtectionGroupRequest.Builder().apply(block).build())

/**
 * Provides details about the Shield Advanced subscription for an account.
 */
public suspend inline fun ShieldClient.describeSubscription(crossinline block: DescribeSubscriptionRequest.Builder.() -> Unit): DescribeSubscriptionResponse = describeSubscription(DescribeSubscriptionRequest.Builder().apply(block).build())

/**
 * Disable the Shield Advanced automatic application layer DDoS mitigation feature for the protected resource. This stops Shield Advanced from creating, verifying, and applying WAF rules for attacks that it detects for the resource.
 */
public suspend inline fun ShieldClient.disableApplicationLayerAutomaticResponse(crossinline block: DisableApplicationLayerAutomaticResponseRequest.Builder.() -> Unit): DisableApplicationLayerAutomaticResponseResponse = disableApplicationLayerAutomaticResponse(DisableApplicationLayerAutomaticResponseRequest.Builder().apply(block).build())

/**
 * Removes authorization from the Shield Response Team (SRT) to notify contacts about escalations to the SRT and to initiate proactive customer support.
 */
public suspend inline fun ShieldClient.disableProactiveEngagement(crossinline block: DisableProactiveEngagementRequest.Builder.() -> Unit): DisableProactiveEngagementResponse = disableProactiveEngagement(DisableProactiveEngagementRequest.Builder().apply(block).build())

/**
 * Removes the Shield Response Team's (SRT) access to the specified Amazon S3 bucket containing the logs that you shared previously.
 */
public suspend inline fun ShieldClient.disassociateDrtLogBucket(crossinline block: DisassociateDrtLogBucketRequest.Builder.() -> Unit): DisassociateDrtLogBucketResponse = disassociateDrtLogBucket(DisassociateDrtLogBucketRequest.Builder().apply(block).build())

/**
 * Removes the Shield Response Team's (SRT) access to your Amazon Web Services account.
 */
public suspend inline fun ShieldClient.disassociateDrtRole(crossinline block: DisassociateDrtRoleRequest.Builder.() -> Unit): DisassociateDrtRoleResponse = disassociateDrtRole(DisassociateDrtRoleRequest.Builder().apply(block).build())

/**
 * Removes health-based detection from the Shield Advanced protection for a resource. Shield Advanced health-based detection uses the health of your Amazon Web Services resource to improve responsiveness and accuracy in attack detection and response.
 *
 * You define the health check in Route 53 and then associate or disassociate it with your Shield Advanced protection. For more information, see [Shield Advanced Health-Based Detection](https://docs.aws.amazon.com/waf/latest/developerguide/ddos-overview.html#ddos-advanced-health-check-option) in the *WAF Developer Guide*.
 */
public suspend inline fun ShieldClient.disassociateHealthCheck(crossinline block: DisassociateHealthCheckRequest.Builder.() -> Unit): DisassociateHealthCheckResponse = disassociateHealthCheck(DisassociateHealthCheckRequest.Builder().apply(block).build())

/**
 * Enable the Shield Advanced automatic application layer DDoS mitigation for the protected resource.
 *
 * This feature is available for Amazon CloudFront distributions and Application Load Balancers only.
 *
 * This causes Shield Advanced to create, verify, and apply WAF rules for DDoS attacks that it detects for the resource. Shield Advanced applies the rules in a Shield rule group inside the web ACL that you've associated with the resource. For information about how automatic mitigation works and the requirements for using it, see [Shield Advanced automatic application layer DDoS mitigation](https://docs.aws.amazon.com/waf/latest/developerguide/ddos-advanced-automatic-app-layer-response.html).
 *
 * Don't use this action to make changes to automatic mitigation settings when it's already enabled for a resource. Instead, use UpdateApplicationLayerAutomaticResponse.
 *
 * To use this feature, you must associate a web ACL with the protected resource. The web ACL must be created using the latest version of WAF (v2). You can associate the web ACL through the Shield Advanced console at [https://console.aws.amazon.com/wafv2/shieldv2#/](https://console.aws.amazon.com/wafv2/shieldv2#/). For more information, see [Getting Started with Shield Advanced](https://docs.aws.amazon.com/waf/latest/developerguide/getting-started-ddos.html). You can also associate the web ACL to the resource through the WAF console or the WAF API, but you must manage Shield Advanced automatic mitigation through Shield Advanced. For information about WAF, see [WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
 */
public suspend inline fun ShieldClient.enableApplicationLayerAutomaticResponse(crossinline block: EnableApplicationLayerAutomaticResponseRequest.Builder.() -> Unit): EnableApplicationLayerAutomaticResponseResponse = enableApplicationLayerAutomaticResponse(EnableApplicationLayerAutomaticResponseRequest.Builder().apply(block).build())

/**
 * Authorizes the Shield Response Team (SRT) to use email and phone to notify contacts about escalations to the SRT and to initiate proactive customer support.
 */
public suspend inline fun ShieldClient.enableProactiveEngagement(crossinline block: EnableProactiveEngagementRequest.Builder.() -> Unit): EnableProactiveEngagementResponse = enableProactiveEngagement(EnableProactiveEngagementRequest.Builder().apply(block).build())

/**
 * Returns the `SubscriptionState`, either `Active` or `Inactive`.
 */
public suspend inline fun ShieldClient.getSubscriptionState(crossinline block: GetSubscriptionStateRequest.Builder.() -> Unit): GetSubscriptionStateResponse = getSubscriptionState(GetSubscriptionStateRequest.Builder().apply(block).build())

/**
 * Returns all ongoing DDoS attacks or all DDoS attacks during a specified time period.
 */
public suspend inline fun ShieldClient.listAttacks(crossinline block: ListAttacksRequest.Builder.() -> Unit): ListAttacksResponse = listAttacks(ListAttacksRequest.Builder().apply(block).build())

/**
 * Retrieves ProtectionGroup objects for the account. You can retrieve all protection groups or you can provide filtering criteria and retrieve just the subset of protection groups that match the criteria.
 */
public suspend inline fun ShieldClient.listProtectionGroups(crossinline block: ListProtectionGroupsRequest.Builder.() -> Unit): ListProtectionGroupsResponse = listProtectionGroups(ListProtectionGroupsRequest.Builder().apply(block).build())

/**
 * Retrieves Protection objects for the account. You can retrieve all protections or you can provide filtering criteria and retrieve just the subset of protections that match the criteria.
 */
public suspend inline fun ShieldClient.listProtections(crossinline block: ListProtectionsRequest.Builder.() -> Unit): ListProtectionsResponse = listProtections(ListProtectionsRequest.Builder().apply(block).build())

/**
 * Retrieves the resources that are included in the protection group.
 */
public suspend inline fun ShieldClient.listResourcesInProtectionGroup(crossinline block: ListResourcesInProtectionGroupRequest.Builder.() -> Unit): ListResourcesInProtectionGroupResponse = listResourcesInProtectionGroup(ListResourcesInProtectionGroupRequest.Builder().apply(block).build())

/**
 * Gets information about Amazon Web Services tags for a specified Amazon Resource Name (ARN) in Shield.
 */
public suspend inline fun ShieldClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Adds or updates tags for a resource in Shield.
 */
public suspend inline fun ShieldClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes tags from a resource in Shield.
 */
public suspend inline fun ShieldClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates an existing Shield Advanced automatic application layer DDoS mitigation configuration for the specified resource.
 */
public suspend inline fun ShieldClient.updateApplicationLayerAutomaticResponse(crossinline block: UpdateApplicationLayerAutomaticResponseRequest.Builder.() -> Unit): UpdateApplicationLayerAutomaticResponseResponse = updateApplicationLayerAutomaticResponse(UpdateApplicationLayerAutomaticResponseRequest.Builder().apply(block).build())

/**
 * Updates the details of the list of email addresses and phone numbers that the Shield Response Team (SRT) can use to contact you if you have proactive engagement enabled, for escalations to the SRT and to initiate proactive customer support.
 */
public suspend inline fun ShieldClient.updateEmergencyContactSettings(crossinline block: UpdateEmergencyContactSettingsRequest.Builder.() -> Unit): UpdateEmergencyContactSettingsResponse = updateEmergencyContactSettings(UpdateEmergencyContactSettingsRequest.Builder().apply(block).build())

/**
 * Updates an existing protection group. A protection group is a grouping of protected resources so they can be handled as a collective. This resource grouping improves the accuracy of detection and reduces false positives.
 */
public suspend inline fun ShieldClient.updateProtectionGroup(crossinline block: UpdateProtectionGroupRequest.Builder.() -> Unit): UpdateProtectionGroupResponse = updateProtectionGroup(UpdateProtectionGroupRequest.Builder().apply(block).build())

/**
 * Updates the details of an existing subscription. Only enter values for parameters you want to change. Empty parameters are not updated.
 *
 * For accounts that are members of an Organizations organization, Shield Advanced subscriptions are billed against the organization's payer account, regardless of whether the payer account itself is subscribed.
 */
public suspend inline fun ShieldClient.updateSubscription(crossinline block: UpdateSubscriptionRequest.Builder.() -> Unit): UpdateSubscriptionResponse = updateSubscription(UpdateSubscriptionRequest.Builder().apply(block).build())
