// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.shield.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.shield.model.GetSubscriptionStateResponse
import aws.sdk.kotlin.services.shield.model.ShieldException
import aws.sdk.kotlin.services.shield.model.SubscriptionState
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetSubscriptionStateOperationDeserializer: HttpDeserialize<GetSubscriptionStateResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetSubscriptionStateResponse {
        if (!response.status.isSuccess()) {
            throwGetSubscriptionStateError(context, response)
        }
        val builder = GetSubscriptionStateResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetSubscriptionStateOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetSubscriptionStateError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ShieldException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalErrorException" -> InternalErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ShieldException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetSubscriptionStateOperationBody(builder: GetSubscriptionStateResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val SUBSCRIPTIONSTATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SubscriptionState"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(SUBSCRIPTIONSTATE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                SUBSCRIPTIONSTATE_DESCRIPTOR.index -> builder.subscriptionState = deserializeString().let { SubscriptionState.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
