// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.shield.model



public class ListProtectionsResponse private constructor(builder: Builder) {
    /**
     * When you request a list of objects from Shield Advanced, if the response does not include all of the remaining available objects, Shield Advanced includes a `NextToken` value in the response. You can retrieve the next batch of objects by requesting the list again and providing the token that was returned by the prior call in your request.
     *
     * You can indicate the maximum number of objects that you want Shield Advanced to return for a single call with the `MaxResults` setting. Shield Advanced will not return more than `MaxResults` objects, but may return fewer, even if more objects are still available.
     *
     * Whenever more objects remain that Shield Advanced has not yet returned to you, the response will include a `NextToken` value.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The array of enabled Protection objects.
     */
    public val protections: List<Protection>? = builder.protections

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.shield.model.ListProtectionsResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListProtectionsResponse(")
        append("nextToken=$nextToken,")
        append("protections=$protections")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = nextToken?.hashCode() ?: 0
        result = 31 * result + (protections?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListProtectionsResponse

        if (nextToken != other.nextToken) return false
        if (protections != other.protections) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.shield.model.ListProtectionsResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * When you request a list of objects from Shield Advanced, if the response does not include all of the remaining available objects, Shield Advanced includes a `NextToken` value in the response. You can retrieve the next batch of objects by requesting the list again and providing the token that was returned by the prior call in your request.
         *
         * You can indicate the maximum number of objects that you want Shield Advanced to return for a single call with the `MaxResults` setting. Shield Advanced will not return more than `MaxResults` objects, but may return fewer, even if more objects are still available.
         *
         * Whenever more objects remain that Shield Advanced has not yet returned to you, the response will include a `NextToken` value.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The array of enabled Protection objects.
         */
        public var protections: List<Protection>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.shield.model.ListProtectionsResponse) : this() {
            this.nextToken = x.nextToken
            this.protections = x.protections
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.shield.model.ListProtectionsResponse = ListProtectionsResponse(this)
    }
}
