// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.shield.serde

import aws.sdk.kotlin.services.shield.model.GetSubscriptionStateResponse
import aws.sdk.kotlin.services.shield.model.ShieldException
import aws.sdk.kotlin.services.shield.model.SubscriptionState
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetSubscriptionStateOperationDeserializer: HttpDeserialize<GetSubscriptionStateResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetSubscriptionStateResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetSubscriptionStateError(context, call)
        }
        val builder = GetSubscriptionStateResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetSubscriptionStateOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetSubscriptionStateError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ShieldException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalErrorException" -> InternalErrorExceptionDeserializer().deserialize(context, wrappedCall)
        else -> ShieldException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetSubscriptionStateOperationBody(builder: GetSubscriptionStateResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val SUBSCRIPTIONSTATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("SubscriptionState"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(SUBSCRIPTIONSTATE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                SUBSCRIPTIONSTATE_DESCRIPTOR.index -> builder.subscriptionState = deserializeString().let { SubscriptionState.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
