// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.shield.model



/**
 * A grouping of protected resources that you and Shield Advanced can monitor as a collective. This resource grouping improves the accuracy of detection and reduces false positives.
 */
public class ProtectionGroup private constructor(builder: Builder) {
    /**
     * Defines how Shield combines resource data for the group in order to detect, mitigate, and report events.
     * + Sum - Use the total traffic across the group. This is a good choice for most cases. Examples include Elastic IP addresses for EC2 instances that scale manually or automatically.
     * + Mean - Use the average of the traffic across the group. This is a good choice for resources that share traffic uniformly. Examples include accelerators and load balancers.
     * + Max - Use the highest traffic from each resource. This is useful for resources that don't share traffic and for resources that share that traffic in a non-uniform way. Examples include Amazon CloudFront distributions and origin resources for CloudFront distributions.
     */
    public val aggregation: aws.sdk.kotlin.services.shield.model.ProtectionGroupAggregation = requireNotNull(builder.aggregation) { "A non-null value must be provided for aggregation" }
    /**
     * The ARNs (Amazon Resource Names) of the resources to include in the protection group. You must set this when you set `Pattern` to `ARBITRARY` and you must not set it for any other `Pattern` setting.
     */
    public val members: List<String> = requireNotNull(builder.members) { "A non-null value must be provided for members" }
    /**
     * The criteria to use to choose the protected resources for inclusion in the group. You can include all resources that have protections, provide a list of resource ARNs (Amazon Resource Names), or include all resources of a specified resource type.
     */
    public val pattern: aws.sdk.kotlin.services.shield.model.ProtectionGroupPattern = requireNotNull(builder.pattern) { "A non-null value must be provided for pattern" }
    /**
     * The ARN (Amazon Resource Name) of the protection group.
     */
    public val protectionGroupArn: kotlin.String? = builder.protectionGroupArn
    /**
     * The name of the protection group. You use this to identify the protection group in lists and to manage the protection group, for example to update, delete, or describe it.
     */
    public val protectionGroupId: kotlin.String = requireNotNull(builder.protectionGroupId) { "A non-null value must be provided for protectionGroupId" }
    /**
     * The resource type to include in the protection group. All protected resources of this type are included in the protection group. You must set this when you set `Pattern` to `BY_RESOURCE_TYPE` and you must not set it for any other `Pattern` setting.
     */
    public val resourceType: aws.sdk.kotlin.services.shield.model.ProtectedResourceType? = builder.resourceType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.shield.model.ProtectionGroup = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ProtectionGroup(")
        append("aggregation=$aggregation,")
        append("members=$members,")
        append("pattern=$pattern,")
        append("protectionGroupArn=$protectionGroupArn,")
        append("protectionGroupId=$protectionGroupId,")
        append("resourceType=$resourceType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = aggregation.hashCode()
        result = 31 * result + (members.hashCode())
        result = 31 * result + (pattern.hashCode())
        result = 31 * result + (protectionGroupArn?.hashCode() ?: 0)
        result = 31 * result + (protectionGroupId.hashCode())
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ProtectionGroup

        if (aggregation != other.aggregation) return false
        if (members != other.members) return false
        if (pattern != other.pattern) return false
        if (protectionGroupArn != other.protectionGroupArn) return false
        if (protectionGroupId != other.protectionGroupId) return false
        if (resourceType != other.resourceType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.shield.model.ProtectionGroup = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Defines how Shield combines resource data for the group in order to detect, mitigate, and report events.
         * + Sum - Use the total traffic across the group. This is a good choice for most cases. Examples include Elastic IP addresses for EC2 instances that scale manually or automatically.
         * + Mean - Use the average of the traffic across the group. This is a good choice for resources that share traffic uniformly. Examples include accelerators and load balancers.
         * + Max - Use the highest traffic from each resource. This is useful for resources that don't share traffic and for resources that share that traffic in a non-uniform way. Examples include Amazon CloudFront distributions and origin resources for CloudFront distributions.
         */
        public var aggregation: aws.sdk.kotlin.services.shield.model.ProtectionGroupAggregation? = null
        /**
         * The ARNs (Amazon Resource Names) of the resources to include in the protection group. You must set this when you set `Pattern` to `ARBITRARY` and you must not set it for any other `Pattern` setting.
         */
        public var members: List<String>? = null
        /**
         * The criteria to use to choose the protected resources for inclusion in the group. You can include all resources that have protections, provide a list of resource ARNs (Amazon Resource Names), or include all resources of a specified resource type.
         */
        public var pattern: aws.sdk.kotlin.services.shield.model.ProtectionGroupPattern? = null
        /**
         * The ARN (Amazon Resource Name) of the protection group.
         */
        public var protectionGroupArn: kotlin.String? = null
        /**
         * The name of the protection group. You use this to identify the protection group in lists and to manage the protection group, for example to update, delete, or describe it.
         */
        public var protectionGroupId: kotlin.String? = null
        /**
         * The resource type to include in the protection group. All protected resources of this type are included in the protection group. You must set this when you set `Pattern` to `BY_RESOURCE_TYPE` and you must not set it for any other `Pattern` setting.
         */
        public var resourceType: aws.sdk.kotlin.services.shield.model.ProtectedResourceType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.shield.model.ProtectionGroup) : this() {
            this.aggregation = x.aggregation
            this.members = x.members
            this.pattern = x.pattern
            this.protectionGroupArn = x.protectionGroupArn
            this.protectionGroupId = x.protectionGroupId
            this.resourceType = x.resourceType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.shield.model.ProtectionGroup = ProtectionGroup(this)

        internal fun correctErrors(): Builder {
            if (aggregation == null) aggregation = ProtectionGroupAggregation.SdkUnknown("no value provided")
            if (members == null) members = emptyList()
            if (pattern == null) pattern = ProtectionGroupPattern.SdkUnknown("no value provided")
            if (protectionGroupId == null) protectionGroupId = ""
            return this
        }
    }
}
