// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.shield.model



/**
 * Narrows the set of protections that the call retrieves. You can retrieve a single protection by providing its name or the ARN (Amazon Resource Name) of its protected resource. You can also retrieve all protections for a specific resource type. You can provide up to one criteria per filter type. Shield Advanced returns protections that exactly match all of the filter criteria that you provide.
 */
public class InclusionProtectionFilters private constructor(builder: Builder) {
    /**
     * The name of the protection that you want to retrieve.
     */
    public val protectionNames: List<String>? = builder.protectionNames
    /**
     * The ARN (Amazon Resource Name) of the resource whose protection you want to retrieve.
     */
    public val resourceArns: List<String>? = builder.resourceArns
    /**
     * The type of protected resource whose protections you want to retrieve.
     */
    public val resourceTypes: List<ProtectedResourceType>? = builder.resourceTypes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.shield.model.InclusionProtectionFilters = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InclusionProtectionFilters(")
        append("protectionNames=$protectionNames,")
        append("resourceArns=$resourceArns,")
        append("resourceTypes=$resourceTypes")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = protectionNames?.hashCode() ?: 0
        result = 31 * result + (resourceArns?.hashCode() ?: 0)
        result = 31 * result + (resourceTypes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InclusionProtectionFilters

        if (protectionNames != other.protectionNames) return false
        if (resourceArns != other.resourceArns) return false
        if (resourceTypes != other.resourceTypes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.shield.model.InclusionProtectionFilters = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the protection that you want to retrieve.
         */
        public var protectionNames: List<String>? = null
        /**
         * The ARN (Amazon Resource Name) of the resource whose protection you want to retrieve.
         */
        public var resourceArns: List<String>? = null
        /**
         * The type of protected resource whose protections you want to retrieve.
         */
        public var resourceTypes: List<ProtectedResourceType>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.shield.model.InclusionProtectionFilters) : this() {
            this.protectionNames = x.protectionNames
            this.resourceArns = x.resourceArns
            this.resourceTypes = x.resourceTypes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.shield.model.InclusionProtectionFilters = InclusionProtectionFilters(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
