// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.shield.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Summarizes all DDoS attacks for a specified time period.
 */
public class AttackSummary private constructor(builder: Builder) {
    /**
     * The unique identifier (ID) of the attack.
     */
    public val attackId: kotlin.String? = builder.attackId
    /**
     * The list of attacks for a specified time period.
     */
    public val attackVectors: List<AttackVectorDescription>? = builder.attackVectors
    /**
     * The end time of the attack, in Unix time in seconds.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The ARN (Amazon Resource Name) of the resource that was attacked.
     */
    public val resourceArn: kotlin.String? = builder.resourceArn
    /**
     * The start time of the attack, in Unix time in seconds.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.shield.model.AttackSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AttackSummary(")
        append("attackId=$attackId,")
        append("attackVectors=$attackVectors,")
        append("endTime=$endTime,")
        append("resourceArn=$resourceArn,")
        append("startTime=$startTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attackId?.hashCode() ?: 0
        result = 31 * result + (attackVectors?.hashCode() ?: 0)
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (resourceArn?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AttackSummary

        if (attackId != other.attackId) return false
        if (attackVectors != other.attackVectors) return false
        if (endTime != other.endTime) return false
        if (resourceArn != other.resourceArn) return false
        if (startTime != other.startTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.shield.model.AttackSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The unique identifier (ID) of the attack.
         */
        public var attackId: kotlin.String? = null
        /**
         * The list of attacks for a specified time period.
         */
        public var attackVectors: List<AttackVectorDescription>? = null
        /**
         * The end time of the attack, in Unix time in seconds.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ARN (Amazon Resource Name) of the resource that was attacked.
         */
        public var resourceArn: kotlin.String? = null
        /**
         * The start time of the attack, in Unix time in seconds.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.shield.model.AttackSummary) : this() {
            this.attackId = x.attackId
            this.attackVectors = x.attackVectors
            this.endTime = x.endTime
            this.resourceArn = x.resourceArn
            this.startTime = x.startTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.shield.model.AttackSummary = AttackSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
