// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.shield.model



/**
 * Details of a Shield event. This is provided as part of an AttackDetail.
 */
public class AttackProperty private constructor(builder: Builder) {
    /**
     * The type of Shield event that was observed. `NETWORK` indicates layer 3 and layer 4 events and `APPLICATION` indicates layer 7 events.
     *
     * For infrastructure layer events (L3 and L4 events), you can view metrics for top contributors in Amazon CloudWatch metrics. For more information, see [Shield metrics and alarms](https://docs.aws.amazon.com/waf/latest/developerguide/monitoring-cloudwatch.html#set-ddos-alarms) in the *WAF Developer Guide*.
     */
    public val attackLayer: aws.sdk.kotlin.services.shield.model.AttackLayer? = builder.attackLayer
    /**
     * Defines the Shield event property information that is provided. The `WORDPRESS_PINGBACK_REFLECTOR` and `WORDPRESS_PINGBACK_SOURCE` values are valid only for WordPress reflective pingback events.
     */
    public val attackPropertyIdentifier: aws.sdk.kotlin.services.shield.model.AttackPropertyIdentifier? = builder.attackPropertyIdentifier
    /**
     * Contributor objects for the top five contributors to a Shield event. A contributor is a source of traffic that Shield Advanced identifies as responsible for some or all of an event.
     */
    public val topContributors: List<Contributor>? = builder.topContributors
    /**
     * The total contributions made to this Shield event by all contributors.
     */
    public val total: kotlin.Long = builder.total
    /**
     * The unit used for the `Contributor``Value` property.
     */
    public val unit: aws.sdk.kotlin.services.shield.model.ShieldUnit? = builder.unit

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.shield.model.AttackProperty = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AttackProperty(")
        append("attackLayer=$attackLayer,")
        append("attackPropertyIdentifier=$attackPropertyIdentifier,")
        append("topContributors=$topContributors,")
        append("total=$total,")
        append("unit=$unit")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attackLayer?.hashCode() ?: 0
        result = 31 * result + (attackPropertyIdentifier?.hashCode() ?: 0)
        result = 31 * result + (topContributors?.hashCode() ?: 0)
        result = 31 * result + (total.hashCode())
        result = 31 * result + (unit?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AttackProperty

        if (attackLayer != other.attackLayer) return false
        if (attackPropertyIdentifier != other.attackPropertyIdentifier) return false
        if (topContributors != other.topContributors) return false
        if (total != other.total) return false
        if (unit != other.unit) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.shield.model.AttackProperty = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The type of Shield event that was observed. `NETWORK` indicates layer 3 and layer 4 events and `APPLICATION` indicates layer 7 events.
         *
         * For infrastructure layer events (L3 and L4 events), you can view metrics for top contributors in Amazon CloudWatch metrics. For more information, see [Shield metrics and alarms](https://docs.aws.amazon.com/waf/latest/developerguide/monitoring-cloudwatch.html#set-ddos-alarms) in the *WAF Developer Guide*.
         */
        public var attackLayer: aws.sdk.kotlin.services.shield.model.AttackLayer? = null
        /**
         * Defines the Shield event property information that is provided. The `WORDPRESS_PINGBACK_REFLECTOR` and `WORDPRESS_PINGBACK_SOURCE` values are valid only for WordPress reflective pingback events.
         */
        public var attackPropertyIdentifier: aws.sdk.kotlin.services.shield.model.AttackPropertyIdentifier? = null
        /**
         * Contributor objects for the top five contributors to a Shield event. A contributor is a source of traffic that Shield Advanced identifies as responsible for some or all of an event.
         */
        public var topContributors: List<Contributor>? = null
        /**
         * The total contributions made to this Shield event by all contributors.
         */
        public var total: kotlin.Long = 0L
        /**
         * The unit used for the `Contributor``Value` property.
         */
        public var unit: aws.sdk.kotlin.services.shield.model.ShieldUnit? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.shield.model.AttackProperty) : this() {
            this.attackLayer = x.attackLayer
            this.attackPropertyIdentifier = x.attackPropertyIdentifier
            this.topContributors = x.topContributors
            this.total = x.total
            this.unit = x.unit
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.shield.model.AttackProperty = AttackProperty(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
