// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.shield.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The details of a DDoS attack.
 */
public class AttackDetail private constructor(builder: Builder) {
    /**
     * List of counters that describe the attack for the specified time period.
     */
    public val attackCounters: List<SummarizedCounter>? = builder.attackCounters
    /**
     * The unique identifier (ID) of the attack.
     */
    public val attackId: kotlin.String? = builder.attackId
    /**
     * The array of objects that provide details of the Shield event.
     *
     * For infrastructure layer events (L3 and L4 events), you can view metrics for top contributors in Amazon CloudWatch metrics. For more information, see [Shield metrics and alarms](https://docs.aws.amazon.com/waf/latest/developerguide/monitoring-cloudwatch.html#set-ddos-alarms) in the *WAF Developer Guide*.
     */
    public val attackProperties: List<AttackProperty>? = builder.attackProperties
    /**
     * The time the attack ended, in Unix time in seconds.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * List of mitigation actions taken for the attack.
     */
    public val mitigations: List<Mitigation>? = builder.mitigations
    /**
     * The ARN (Amazon Resource Name) of the resource that was attacked.
     */
    public val resourceArn: kotlin.String? = builder.resourceArn
    /**
     * The time the attack started, in Unix time in seconds.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * If applicable, additional detail about the resource being attacked, for example, IP address or URL.
     */
    public val subResources: List<SubResourceSummary>? = builder.subResources

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.shield.model.AttackDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AttackDetail(")
        append("attackCounters=$attackCounters,")
        append("attackId=$attackId,")
        append("attackProperties=$attackProperties,")
        append("endTime=$endTime,")
        append("mitigations=$mitigations,")
        append("resourceArn=$resourceArn,")
        append("startTime=$startTime,")
        append("subResources=$subResources")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attackCounters?.hashCode() ?: 0
        result = 31 * result + (attackId?.hashCode() ?: 0)
        result = 31 * result + (attackProperties?.hashCode() ?: 0)
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (mitigations?.hashCode() ?: 0)
        result = 31 * result + (resourceArn?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (subResources?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AttackDetail

        if (attackCounters != other.attackCounters) return false
        if (attackId != other.attackId) return false
        if (attackProperties != other.attackProperties) return false
        if (endTime != other.endTime) return false
        if (mitigations != other.mitigations) return false
        if (resourceArn != other.resourceArn) return false
        if (startTime != other.startTime) return false
        if (subResources != other.subResources) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.shield.model.AttackDetail = Builder(this).apply(block).build()

    public class Builder {
        /**
         * List of counters that describe the attack for the specified time period.
         */
        public var attackCounters: List<SummarizedCounter>? = null
        /**
         * The unique identifier (ID) of the attack.
         */
        public var attackId: kotlin.String? = null
        /**
         * The array of objects that provide details of the Shield event.
         *
         * For infrastructure layer events (L3 and L4 events), you can view metrics for top contributors in Amazon CloudWatch metrics. For more information, see [Shield metrics and alarms](https://docs.aws.amazon.com/waf/latest/developerguide/monitoring-cloudwatch.html#set-ddos-alarms) in the *WAF Developer Guide*.
         */
        public var attackProperties: List<AttackProperty>? = null
        /**
         * The time the attack ended, in Unix time in seconds.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * List of mitigation actions taken for the attack.
         */
        public var mitigations: List<Mitigation>? = null
        /**
         * The ARN (Amazon Resource Name) of the resource that was attacked.
         */
        public var resourceArn: kotlin.String? = null
        /**
         * The time the attack started, in Unix time in seconds.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * If applicable, additional detail about the resource being attacked, for example, IP address or URL.
         */
        public var subResources: List<SubResourceSummary>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.shield.model.AttackDetail) : this() {
            this.attackCounters = x.attackCounters
            this.attackId = x.attackId
            this.attackProperties = x.attackProperties
            this.endTime = x.endTime
            this.mitigations = x.mitigations
            this.resourceArn = x.resourceArn
            this.startTime = x.startTime
            this.subResources = x.subResources
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.shield.model.AttackDetail = AttackDetail(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
