// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sfn.serde

import aws.sdk.kotlin.services.sfn.model.EncryptionConfiguration
import aws.sdk.kotlin.services.sfn.model.LoggingConfiguration
import aws.sdk.kotlin.services.sfn.model.TracingConfiguration
import aws.sdk.kotlin.services.sfn.model.UpdateStateMachineRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateStateMachineOperationSerializer: HttpSerializer.NonStreaming<UpdateStateMachineRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateStateMachineRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializeUpdateStateMachineOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.0")
        }
        return builder
    }
}

private fun serializeUpdateStateMachineOperationBody(context: ExecutionContext, input: UpdateStateMachineRequest): ByteArray {
    val serializer = JsonSerializer()
    val DEFINITION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("definition"))
    val ENCRYPTIONCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("encryptionConfiguration"))
    val LOGGINGCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("loggingConfiguration"))
    val PUBLISH_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("publish"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("roleArn"))
    val STATEMACHINEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("stateMachineArn"))
    val TRACINGCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("tracingConfiguration"))
    val VERSIONDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("versionDescription"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DEFINITION_DESCRIPTOR)
        field(ENCRYPTIONCONFIGURATION_DESCRIPTOR)
        field(LOGGINGCONFIGURATION_DESCRIPTOR)
        field(PUBLISH_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(STATEMACHINEARN_DESCRIPTOR)
        field(TRACINGCONFIGURATION_DESCRIPTOR)
        field(VERSIONDESCRIPTION_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.definition?.let { field(DEFINITION_DESCRIPTOR, it) }
        input.encryptionConfiguration?.let { field(ENCRYPTIONCONFIGURATION_DESCRIPTOR, it, ::serializeEncryptionConfigurationDocument) }
        input.loggingConfiguration?.let { field(LOGGINGCONFIGURATION_DESCRIPTOR, it, ::serializeLoggingConfigurationDocument) }
        input.publish?.let { field(PUBLISH_DESCRIPTOR, it) }
        input.roleArn?.let { field(ROLEARN_DESCRIPTOR, it) }
        input.stateMachineArn?.let { field(STATEMACHINEARN_DESCRIPTOR, it) }
        input.tracingConfiguration?.let { field(TRACINGCONFIGURATION_DESCRIPTOR, it, ::serializeTracingConfigurationDocument) }
        input.versionDescription?.let { field(VERSIONDESCRIPTION_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
