// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sfn.serde

import aws.sdk.kotlin.services.sfn.model.SendTaskFailureResponse
import aws.sdk.kotlin.services.sfn.model.SfnException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class SendTaskFailureOperationDeserializer: HttpDeserializer.NonStreaming<SendTaskFailureResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): SendTaskFailureResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwSendTaskFailureError(context, call, payload)
        }
        val builder = SendTaskFailureResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private fun throwSendTaskFailureError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SfnException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "KmsInvalidStateException" -> KmsInvalidStateExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "KmsThrottlingException" -> KmsThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidToken" -> InvalidTokenDeserializer().deserialize(context, wrappedCall, payload)
        "TaskTimedOut" -> TaskTimedOutDeserializer().deserialize(context, wrappedCall, payload)
        "KmsAccessDeniedException" -> KmsAccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TaskDoesNotExist" -> TaskDoesNotExistDeserializer().deserialize(context, wrappedCall, payload)
        else -> SfnException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
