// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sfn.serde

import aws.sdk.kotlin.services.sfn.model.CloudWatchEventsExecutionDataDetails
import aws.sdk.kotlin.services.sfn.model.DescribeExecutionResponse
import aws.sdk.kotlin.services.sfn.model.ExecutionRedriveStatus
import aws.sdk.kotlin.services.sfn.model.ExecutionStatus
import aws.sdk.kotlin.services.sfn.model.SfnException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class DescribeExecutionOperationDeserializer: HttpDeserializer.NonStreaming<DescribeExecutionResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeExecutionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeExecutionError(context, call, payload)
        }
        val builder = DescribeExecutionResponse.Builder()

        if (payload != null) {
            deserializeDescribeExecutionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeExecutionError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SfnException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "KmsInvalidStateException" -> KmsInvalidStateExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "KmsThrottlingException" -> KmsThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ExecutionDoesNotExist" -> ExecutionDoesNotExistDeserializer().deserialize(context, wrappedCall, payload)
        "KmsAccessDeniedException" -> KmsAccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidArn" -> InvalidArnDeserializer().deserialize(context, wrappedCall, payload)
        else -> SfnException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeExecutionOperationBody(builder: DescribeExecutionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CAUSE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("cause"))
    val ERROR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("error"))
    val EXECUTIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("executionArn"))
    val INPUT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("input"))
    val INPUTDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("inputDetails"))
    val MAPRUNARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("mapRunArn"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val OUTPUT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("output"))
    val OUTPUTDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("outputDetails"))
    val REDRIVECOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("redriveCount"))
    val REDRIVEDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("redriveDate"))
    val REDRIVESTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("redriveStatus"))
    val REDRIVESTATUSREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("redriveStatusReason"))
    val STARTDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("startDate"))
    val STATEMACHINEALIASARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("stateMachineAliasArn"))
    val STATEMACHINEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("stateMachineArn"))
    val STATEMACHINEVERSIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("stateMachineVersionArn"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("status"))
    val STOPDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("stopDate"))
    val TRACEHEADER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("traceHeader"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CAUSE_DESCRIPTOR)
        field(ERROR_DESCRIPTOR)
        field(EXECUTIONARN_DESCRIPTOR)
        field(INPUT_DESCRIPTOR)
        field(INPUTDETAILS_DESCRIPTOR)
        field(MAPRUNARN_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(OUTPUT_DESCRIPTOR)
        field(OUTPUTDETAILS_DESCRIPTOR)
        field(REDRIVECOUNT_DESCRIPTOR)
        field(REDRIVEDATE_DESCRIPTOR)
        field(REDRIVESTATUS_DESCRIPTOR)
        field(REDRIVESTATUSREASON_DESCRIPTOR)
        field(STARTDATE_DESCRIPTOR)
        field(STATEMACHINEALIASARN_DESCRIPTOR)
        field(STATEMACHINEARN_DESCRIPTOR)
        field(STATEMACHINEVERSIONARN_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(STOPDATE_DESCRIPTOR)
        field(TRACEHEADER_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CAUSE_DESCRIPTOR.index -> builder.cause = deserializeString()
                ERROR_DESCRIPTOR.index -> builder.error = deserializeString()
                EXECUTIONARN_DESCRIPTOR.index -> builder.executionArn = deserializeString()
                INPUT_DESCRIPTOR.index -> builder.input = deserializeString()
                INPUTDETAILS_DESCRIPTOR.index -> builder.inputDetails = deserializeCloudWatchEventsExecutionDataDetailsDocument(deserializer)
                MAPRUNARN_DESCRIPTOR.index -> builder.mapRunArn = deserializeString()
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                OUTPUT_DESCRIPTOR.index -> builder.output = deserializeString()
                OUTPUTDETAILS_DESCRIPTOR.index -> builder.outputDetails = deserializeCloudWatchEventsExecutionDataDetailsDocument(deserializer)
                REDRIVECOUNT_DESCRIPTOR.index -> builder.redriveCount = deserializeInt()
                REDRIVEDATE_DESCRIPTOR.index -> builder.redriveDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                REDRIVESTATUS_DESCRIPTOR.index -> builder.redriveStatus = deserializeString().let { ExecutionRedriveStatus.fromValue(it) }
                REDRIVESTATUSREASON_DESCRIPTOR.index -> builder.redriveStatusReason = deserializeString()
                STARTDATE_DESCRIPTOR.index -> builder.startDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                STATEMACHINEALIASARN_DESCRIPTOR.index -> builder.stateMachineAliasArn = deserializeString()
                STATEMACHINEARN_DESCRIPTOR.index -> builder.stateMachineArn = deserializeString()
                STATEMACHINEVERSIONARN_DESCRIPTOR.index -> builder.stateMachineVersionArn = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { ExecutionStatus.fromValue(it) }
                STOPDATE_DESCRIPTOR.index -> builder.stopDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                TRACEHEADER_DESCRIPTOR.index -> builder.traceHeader = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
