// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sfn.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes potential issues found during state machine validation. Rather than raise an exception, validation will return a list of **diagnostic elements** containing diagnostic information.
 *
 * The [ValidateStateMachineDefinitionlAPI](https://docs.aws.amazon.com/step-functions/latest/apireference/API_ValidateStateMachineDefinition.html) might add new diagnostics in the future, adjust diagnostic codes, or change the message wording. Your automated processes should only rely on the value of the **result** field value (OK, FAIL). Do **not** rely on the exact order, count, or wording of diagnostic messages.
 *
 * **List of warning codes**
 *
 * ## NO_DOLLAR
 * No `.$` on a field that appears to be a JSONPath or Intrinsic Function.
 *
 * ## NO_PATH
 * Field value looks like a path, but field name does not end with 'Path'.
 *
 * ## PASS_RESULT_IS_STATIC
 * Attempt to use a path in the result of a pass state.
 *
 * **List of error codes**
 *
 * ## INVALID_JSON_DESCRIPTION
 * JSON syntax problem found.
 *
 * ## MISSING_DESCRIPTION
 * Received a null or empty workflow input.
 *
 * ## SCHEMA_VALIDATION_FAILED
 * Schema validation reported errors.
 *
 * ## INVALID_RESOURCE
 * The value of a Task-state resource field is invalid.
 *
 * ## MISSING_END_STATE
 * The workflow does not have a terminal state.
 *
 * ## DUPLICATE_STATE_NAME
 * The same state name appears more than once.
 *
 * ## INVALID_STATE_NAME
 * The state name does not follow the naming convention.
 *
 * ## STATE_MACHINE_NAME_EMPTY
 * The state machine name has not been specified.
 *
 * ## STATE_MACHINE_NAME_INVALID
 * The state machine name does not follow the naming convention.
 *
 * ## STATE_MACHINE_NAME_TOO_LONG
 * The state name exceeds the allowed length.
 *
 * ## STATE_MACHINE_NAME_ALREADY_EXISTS
 * The state name already exists.
 *
 * ## DUPLICATE_LABEL_NAME
 * A label name appears more than once.
 *
 * ## INVALID_LABEL_NAME
 * You have provided an invalid label name.
 *
 * ## MISSING_TRANSITION_TARGET
 * The value of "Next" field doesn't match a known state name.
 *
 * ## TOO_DEEPLY_NESTED
 * The states are too deeply nested.
 */
public class ValidateStateMachineDefinitionDiagnostic private constructor(builder: Builder) {
    /**
     * Identifying code for the diagnostic.
     */
    public val code: kotlin.String = requireNotNull(builder.code) { "A non-null value must be provided for code" }
    /**
     * Location of the issue in the state machine, if available.
     *
     * For errors specific to a field, the location could be in the format: `/States/<StateName>/<FieldName>`, for example: `/States/FailState/ErrorPath`.
     */
    public val location: kotlin.String? = builder.location
    /**
     * Message describing the diagnostic condition.
     */
    public val message: kotlin.String = requireNotNull(builder.message) { "A non-null value must be provided for message" }
    /**
     * A value of `ERROR` means that you cannot create or update a state machine with this definition.
     *
     * `WARNING` level diagnostics alert you to potential issues, but they will not prevent you from creating or updating your state machine.
     */
    public val severity: aws.sdk.kotlin.services.sfn.model.ValidateStateMachineDefinitionSeverity = requireNotNull(builder.severity) { "A non-null value must be provided for severity" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sfn.model.ValidateStateMachineDefinitionDiagnostic = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ValidateStateMachineDefinitionDiagnostic(")
        append("code=*** Sensitive Data Redacted ***,")
        append("location=*** Sensitive Data Redacted ***,")
        append("message=*** Sensitive Data Redacted ***,")
        append("severity=$severity")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = code.hashCode()
        result = 31 * result + (location?.hashCode() ?: 0)
        result = 31 * result + (message.hashCode())
        result = 31 * result + (severity.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ValidateStateMachineDefinitionDiagnostic

        if (code != other.code) return false
        if (location != other.location) return false
        if (message != other.message) return false
        if (severity != other.severity) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sfn.model.ValidateStateMachineDefinitionDiagnostic = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Identifying code for the diagnostic.
         */
        public var code: kotlin.String? = null
        /**
         * Location of the issue in the state machine, if available.
         *
         * For errors specific to a field, the location could be in the format: `/States/<StateName>/<FieldName>`, for example: `/States/FailState/ErrorPath`.
         */
        public var location: kotlin.String? = null
        /**
         * Message describing the diagnostic condition.
         */
        public var message: kotlin.String? = null
        /**
         * A value of `ERROR` means that you cannot create or update a state machine with this definition.
         *
         * `WARNING` level diagnostics alert you to potential issues, but they will not prevent you from creating or updating your state machine.
         */
        public var severity: aws.sdk.kotlin.services.sfn.model.ValidateStateMachineDefinitionSeverity? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sfn.model.ValidateStateMachineDefinitionDiagnostic) : this() {
            this.code = x.code
            this.location = x.location
            this.message = x.message
            this.severity = x.severity
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sfn.model.ValidateStateMachineDefinitionDiagnostic = ValidateStateMachineDefinitionDiagnostic(this)

        internal fun correctErrors(): Builder {
            if (code == null) code = ""
            if (message == null) message = ""
            if (severity == null) severity = ValidateStateMachineDefinitionSeverity.SdkUnknown("no value provided")
            return this
        }
    }
}
