// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sfn.model

import aws.smithy.kotlin.runtime.SdkDsl

public class TestStateRequest private constructor(builder: Builder) {
    /**
     * The [Amazon States Language](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html) (ASL) definition of the state.
     */
    public val definition: kotlin.String? = builder.definition
    /**
     * A string that contains the JSON input data for the state.
     */
    public val input: kotlin.String? = builder.input
    /**
     * Determines the values to return when a state is tested. You can specify one of the following types:
     * + `INFO`: Shows the final state output. By default, Step Functions sets `inspectionLevel` to `INFO` if you don't specify a level.
     * + `DEBUG`: Shows the final state output along with the input and output data processing result.
     * + `TRACE`: Shows the HTTP request and response for an HTTP Task. This level also shows the final state output along with the input and output data processing result.
     *
     * Each of these levels also provide information about the status of the state execution and the next state to transition to.
     */
    public val inspectionLevel: aws.sdk.kotlin.services.sfn.model.InspectionLevel? = builder.inspectionLevel
    /**
     * Specifies whether or not to include secret information in the test result. For HTTP Tasks, a secret includes the data that an EventBridge connection adds to modify the HTTP request headers, query parameters, and body. Step Functions doesn't omit any information included in the state definition or the HTTP response.
     *
     * If you set `revealSecrets` to `true`, you must make sure that the IAM user that calls the `TestState` API has permission for the `states:RevealSecrets` action. For an example of IAM policy that sets the `states:RevealSecrets` permission, see [IAM permissions to test a state](https://docs.aws.amazon.com/step-functions/latest/dg/test-state-isolation.html#test-state-permissions). Without this permission, Step Functions throws an access denied error.
     *
     * By default, `revealSecrets` is set to `false`.
     */
    public val revealSecrets: kotlin.Boolean? = builder.revealSecrets
    /**
     * The Amazon Resource Name (ARN) of the execution role with the required IAM permissions for the state.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * JSON object literal that sets variables used in the state under test. Object keys are the variable names and values are the variable values.
     */
    public val variables: kotlin.String? = builder.variables

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sfn.model.TestStateRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TestStateRequest(")
        append("definition=*** Sensitive Data Redacted ***,")
        append("input=*** Sensitive Data Redacted ***,")
        append("inspectionLevel=$inspectionLevel,")
        append("revealSecrets=$revealSecrets,")
        append("roleArn=$roleArn,")
        append("variables=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = definition?.hashCode() ?: 0
        result = 31 * result + (input?.hashCode() ?: 0)
        result = 31 * result + (inspectionLevel?.hashCode() ?: 0)
        result = 31 * result + (revealSecrets?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (variables?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TestStateRequest

        if (definition != other.definition) return false
        if (input != other.input) return false
        if (inspectionLevel != other.inspectionLevel) return false
        if (revealSecrets != other.revealSecrets) return false
        if (roleArn != other.roleArn) return false
        if (variables != other.variables) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sfn.model.TestStateRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The [Amazon States Language](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html) (ASL) definition of the state.
         */
        public var definition: kotlin.String? = null
        /**
         * A string that contains the JSON input data for the state.
         */
        public var input: kotlin.String? = null
        /**
         * Determines the values to return when a state is tested. You can specify one of the following types:
         * + `INFO`: Shows the final state output. By default, Step Functions sets `inspectionLevel` to `INFO` if you don't specify a level.
         * + `DEBUG`: Shows the final state output along with the input and output data processing result.
         * + `TRACE`: Shows the HTTP request and response for an HTTP Task. This level also shows the final state output along with the input and output data processing result.
         *
         * Each of these levels also provide information about the status of the state execution and the next state to transition to.
         */
        public var inspectionLevel: aws.sdk.kotlin.services.sfn.model.InspectionLevel? = null
        /**
         * Specifies whether or not to include secret information in the test result. For HTTP Tasks, a secret includes the data that an EventBridge connection adds to modify the HTTP request headers, query parameters, and body. Step Functions doesn't omit any information included in the state definition or the HTTP response.
         *
         * If you set `revealSecrets` to `true`, you must make sure that the IAM user that calls the `TestState` API has permission for the `states:RevealSecrets` action. For an example of IAM policy that sets the `states:RevealSecrets` permission, see [IAM permissions to test a state](https://docs.aws.amazon.com/step-functions/latest/dg/test-state-isolation.html#test-state-permissions). Without this permission, Step Functions throws an access denied error.
         *
         * By default, `revealSecrets` is set to `false`.
         */
        public var revealSecrets: kotlin.Boolean? = null
        /**
         * The Amazon Resource Name (ARN) of the execution role with the required IAM permissions for the state.
         */
        public var roleArn: kotlin.String? = null
        /**
         * JSON object literal that sets variables used in the state under test. Object keys are the variable names and values are the variable values.
         */
        public var variables: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sfn.model.TestStateRequest) : this() {
            this.definition = x.definition
            this.input = x.input
            this.inspectionLevel = x.inspectionLevel
            this.revealSecrets = x.revealSecrets
            this.roleArn = x.roleArn
            this.variables = x.variables
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sfn.model.TestStateRequest = TestStateRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
