// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sfn.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains details about the successful completion of a task state.
 */
public class TaskSucceededEventDetails private constructor(builder: Builder) {
    /**
     * The full JSON response from a resource when a task has succeeded. This response becomes the output of the related task. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.
     */
    public val output: kotlin.String? = builder.output
    /**
     * Contains details about the output of an execution history event.
     */
    public val outputDetails: aws.sdk.kotlin.services.sfn.model.HistoryEventExecutionDataDetails? = builder.outputDetails
    /**
     * The action of the resource called by a task state.
     */
    public val resource: kotlin.String = requireNotNull(builder.resource) { "A non-null value must be provided for resource" }
    /**
     * The service name of the resource in a task state.
     */
    public val resourceType: kotlin.String = requireNotNull(builder.resourceType) { "A non-null value must be provided for resourceType" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sfn.model.TaskSucceededEventDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TaskSucceededEventDetails(")
        append("output=*** Sensitive Data Redacted ***,")
        append("outputDetails=$outputDetails,")
        append("resource=$resource,")
        append("resourceType=$resourceType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = output?.hashCode() ?: 0
        result = 31 * result + (outputDetails?.hashCode() ?: 0)
        result = 31 * result + (resource.hashCode())
        result = 31 * result + (resourceType.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TaskSucceededEventDetails

        if (output != other.output) return false
        if (outputDetails != other.outputDetails) return false
        if (resource != other.resource) return false
        if (resourceType != other.resourceType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sfn.model.TaskSucceededEventDetails = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The full JSON response from a resource when a task has succeeded. This response becomes the output of the related task. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.
         */
        public var output: kotlin.String? = null
        /**
         * Contains details about the output of an execution history event.
         */
        public var outputDetails: aws.sdk.kotlin.services.sfn.model.HistoryEventExecutionDataDetails? = null
        /**
         * The action of the resource called by a task state.
         */
        public var resource: kotlin.String? = null
        /**
         * The service name of the resource in a task state.
         */
        public var resourceType: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sfn.model.TaskSucceededEventDetails) : this() {
            this.output = x.output
            this.outputDetails = x.outputDetails
            this.resource = x.resource
            this.resourceType = x.resourceType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sfn.model.TaskSucceededEventDetails = TaskSucceededEventDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.sfn.model.HistoryEventExecutionDataDetails] inside the given [block]
         */
        public fun outputDetails(block: aws.sdk.kotlin.services.sfn.model.HistoryEventExecutionDataDetails.Builder.() -> kotlin.Unit) {
            this.outputDetails = aws.sdk.kotlin.services.sfn.model.HistoryEventExecutionDataDetails.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (resource == null) resource = ""
            if (resourceType == null) resourceType = ""
            return this
        }
    }
}
