// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sfn.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains details about an exit from a state during an execution.
 */
public class StateExitedEventDetails private constructor(builder: Builder) {
    /**
     * Map of variable name and value as a serialized JSON representation.
     */
    public val assignedVariables: Map<String, String>? = builder.assignedVariables
    /**
     * Provides details about input or output in an execution history event.
     */
    public val assignedVariablesDetails: aws.sdk.kotlin.services.sfn.model.AssignedVariablesDetails? = builder.assignedVariablesDetails
    /**
     * The name of the state.
     *
     * A name must *not* contain:
     * + white space
     * + brackets `< > { } [ ]`
     * + wildcard characters `? *`
     * + special characters `" # % \ ^ | ~ ` $ & , ; : /`
     * + control characters (`U+0000-001F`, `U+007F-009F`)
     *
     * To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The JSON output data of the state. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.
     */
    public val output: kotlin.String? = builder.output
    /**
     * Contains details about the output of an execution history event.
     */
    public val outputDetails: aws.sdk.kotlin.services.sfn.model.HistoryEventExecutionDataDetails? = builder.outputDetails

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sfn.model.StateExitedEventDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StateExitedEventDetails(")
        append("assignedVariables=*** Sensitive Data Redacted ***,")
        append("assignedVariablesDetails=$assignedVariablesDetails,")
        append("name=$name,")
        append("output=*** Sensitive Data Redacted ***,")
        append("outputDetails=$outputDetails")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = assignedVariables?.hashCode() ?: 0
        result = 31 * result + (assignedVariablesDetails?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (output?.hashCode() ?: 0)
        result = 31 * result + (outputDetails?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StateExitedEventDetails

        if (assignedVariables != other.assignedVariables) return false
        if (assignedVariablesDetails != other.assignedVariablesDetails) return false
        if (name != other.name) return false
        if (output != other.output) return false
        if (outputDetails != other.outputDetails) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sfn.model.StateExitedEventDetails = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Map of variable name and value as a serialized JSON representation.
         */
        public var assignedVariables: Map<String, String>? = null
        /**
         * Provides details about input or output in an execution history event.
         */
        public var assignedVariablesDetails: aws.sdk.kotlin.services.sfn.model.AssignedVariablesDetails? = null
        /**
         * The name of the state.
         *
         * A name must *not* contain:
         * + white space
         * + brackets `< > { } [ ]`
         * + wildcard characters `? *`
         * + special characters `" # % \ ^ | ~ ` $ & , ; : /`
         * + control characters (`U+0000-001F`, `U+007F-009F`)
         *
         * To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.
         */
        public var name: kotlin.String? = null
        /**
         * The JSON output data of the state. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.
         */
        public var output: kotlin.String? = null
        /**
         * Contains details about the output of an execution history event.
         */
        public var outputDetails: aws.sdk.kotlin.services.sfn.model.HistoryEventExecutionDataDetails? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sfn.model.StateExitedEventDetails) : this() {
            this.assignedVariables = x.assignedVariables
            this.assignedVariablesDetails = x.assignedVariablesDetails
            this.name = x.name
            this.output = x.output
            this.outputDetails = x.outputDetails
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sfn.model.StateExitedEventDetails = StateExitedEventDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.sfn.model.AssignedVariablesDetails] inside the given [block]
         */
        public fun assignedVariablesDetails(block: aws.sdk.kotlin.services.sfn.model.AssignedVariablesDetails.Builder.() -> kotlin.Unit) {
            this.assignedVariablesDetails = aws.sdk.kotlin.services.sfn.model.AssignedVariablesDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sfn.model.HistoryEventExecutionDataDetails] inside the given [block]
         */
        public fun outputDetails(block: aws.sdk.kotlin.services.sfn.model.HistoryEventExecutionDataDetails.Builder.() -> kotlin.Unit) {
            this.outputDetails = aws.sdk.kotlin.services.sfn.model.HistoryEventExecutionDataDetails.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (name == null) name = ""
            return this
        }
    }
}
