// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sfn.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains details about the routing configuration of a state machine alias. In a routing configuration, you define an array of objects that specify up to two state machine versions. You also specify the percentage of traffic to be routed to each version.
 */
public class RoutingConfigurationListItem private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) that identifies one or two state machine versions defined in the routing configuration.
     *
     * If you specify the ARN of a second version, it must belong to the same state machine as the first version.
     */
    public val stateMachineVersionArn: kotlin.String = requireNotNull(builder.stateMachineVersionArn) { "A non-null value must be provided for stateMachineVersionArn" }
    /**
     * The percentage of traffic you want to route to a state machine version. The sum of the weights in the routing configuration must be equal to 100.
     */
    public val weight: kotlin.Int = builder.weight

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sfn.model.RoutingConfigurationListItem = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RoutingConfigurationListItem(")
        append("stateMachineVersionArn=$stateMachineVersionArn,")
        append("weight=$weight")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = stateMachineVersionArn.hashCode()
        result = 31 * result + (weight)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RoutingConfigurationListItem

        if (stateMachineVersionArn != other.stateMachineVersionArn) return false
        if (weight != other.weight) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sfn.model.RoutingConfigurationListItem = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) that identifies one or two state machine versions defined in the routing configuration.
         *
         * If you specify the ARN of a second version, it must belong to the same state machine as the first version.
         */
        public var stateMachineVersionArn: kotlin.String? = null
        /**
         * The percentage of traffic you want to route to a state machine version. The sum of the weights in the routing configuration must be equal to 100.
         */
        public var weight: kotlin.Int = 0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sfn.model.RoutingConfigurationListItem) : this() {
            this.stateMachineVersionArn = x.stateMachineVersionArn
            this.weight = x.weight
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sfn.model.RoutingConfigurationListItem = RoutingConfigurationListItem(this)

        internal fun correctErrors(): Builder {
            if (stateMachineVersionArn == null) stateMachineVersionArn = ""
            return this
        }
    }
}
