// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sfn.model

import aws.smithy.kotlin.runtime.SdkDsl

public class PublishStateMachineVersionRequest private constructor(builder: Builder) {
    /**
     * An optional description of the state machine version.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Only publish the state machine version if the current state machine's revision ID matches the specified ID.
     *
     * Use this option to avoid publishing a version if the state machine changed since you last updated it. If the specified revision ID doesn't match the state machine's current revision ID, the API returns `ConflictException`.
     *
     * To specify an initial revision ID for a state machine with no revision ID assigned, specify the string `INITIAL` for the `revisionId` parameter. For example, you can specify a `revisionID` of `INITIAL` when you create a state machine using the CreateStateMachine API action.
     */
    public val revisionId: kotlin.String? = builder.revisionId
    /**
     * The Amazon Resource Name (ARN) of the state machine.
     */
    public val stateMachineArn: kotlin.String? = builder.stateMachineArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sfn.model.PublishStateMachineVersionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PublishStateMachineVersionRequest(")
        append("description=*** Sensitive Data Redacted ***,")
        append("revisionId=$revisionId,")
        append("stateMachineArn=$stateMachineArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (revisionId?.hashCode() ?: 0)
        result = 31 * result + (stateMachineArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PublishStateMachineVersionRequest

        if (description != other.description) return false
        if (revisionId != other.revisionId) return false
        if (stateMachineArn != other.stateMachineArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sfn.model.PublishStateMachineVersionRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An optional description of the state machine version.
         */
        public var description: kotlin.String? = null
        /**
         * Only publish the state machine version if the current state machine's revision ID matches the specified ID.
         *
         * Use this option to avoid publishing a version if the state machine changed since you last updated it. If the specified revision ID doesn't match the state machine's current revision ID, the API returns `ConflictException`.
         *
         * To specify an initial revision ID for a state machine with no revision ID assigned, specify the string `INITIAL` for the `revisionId` parameter. For example, you can specify a `revisionID` of `INITIAL` when you create a state machine using the CreateStateMachine API action.
         */
        public var revisionId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the state machine.
         */
        public var stateMachineArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sfn.model.PublishStateMachineVersionRequest) : this() {
            this.description = x.description
            this.revisionId = x.revisionId
            this.stateMachineArn = x.stateMachineArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sfn.model.PublishStateMachineVersionRequest = PublishStateMachineVersionRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
