// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sfn.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ListStateMachineAliasesRequest private constructor(builder: Builder) {
    /**
     * The maximum number of results that are returned per call. You can use `nextToken` to obtain further pages of results. The default is 100 and the maximum allowed page size is 1000. A value of 0 uses the default.
     *
     * This is only an upper limit. The actual number of results returned per call might be fewer than the specified maximum.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * If `nextToken` is returned, there are more results available. The value of `nextToken` is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an *HTTP 400 InvalidToken* error.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The Amazon Resource Name (ARN) of the state machine for which you want to list aliases.
     *
     * If you specify a state machine version ARN, this API returns a list of aliases for that version.
     */
    public val stateMachineArn: kotlin.String? = builder.stateMachineArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sfn.model.ListStateMachineAliasesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListStateMachineAliasesRequest(")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("stateMachineArn=$stateMachineArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxResults ?: 0
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (stateMachineArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListStateMachineAliasesRequest

        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (stateMachineArn != other.stateMachineArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sfn.model.ListStateMachineAliasesRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The maximum number of results that are returned per call. You can use `nextToken` to obtain further pages of results. The default is 100 and the maximum allowed page size is 1000. A value of 0 uses the default.
         *
         * This is only an upper limit. The actual number of results returned per call might be fewer than the specified maximum.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * If `nextToken` is returned, there are more results available. The value of `nextToken` is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an *HTTP 400 InvalidToken* error.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the state machine for which you want to list aliases.
         *
         * If you specify a state machine version ARN, this API returns a list of aliases for that version.
         */
        public var stateMachineArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sfn.model.ListStateMachineAliasesRequest) : this() {
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.stateMachineArn = x.stateMachineArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sfn.model.ListStateMachineAliasesRequest = ListStateMachineAliasesRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
