// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sfn.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Settings to configure server-side encryption.
 *
 *  For additional control over security, you can encrypt your data using a **customer-managed key** for Step Functions state machines and activities. You can configure a symmetric KMS key and data key reuse period when creating or updating a **State Machine**, and when creating an **Activity**. The execution history and state machine definition will be encrypted with the key applied to the State Machine. Activity inputs will be encrypted with the key applied to the Activity.
 *
 *  Step Functions automatically enables encryption at rest using Amazon Web Services owned keys at no charge. However, KMS charges apply when using a customer managed key. For more information about pricing, see [Key Management Service pricing](https://aws.amazon.com/kms/pricing/).
 *
 * For more information on KMS, see [What is Key Management Service?](https://docs.aws.amazon.com/kms/latest/developerguide/overview.html)
 */
public class EncryptionConfiguration private constructor(builder: Builder) {
    /**
     * Maximum duration that Step Functions will reuse data keys. When the period expires, Step Functions will call `GenerateDataKey`. Only applies to customer managed keys.
     */
    public val kmsDataKeyReusePeriodSeconds: kotlin.Int? = builder.kmsDataKeyReusePeriodSeconds
    /**
     * An alias, alias ARN, key ID, or key ARN of a symmetric encryption KMS key to encrypt data. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN or alias ARN.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * Encryption type
     */
    public val type: aws.sdk.kotlin.services.sfn.model.EncryptionType = requireNotNull(builder.type) { "A non-null value must be provided for type" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sfn.model.EncryptionConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EncryptionConfiguration(")
        append("kmsDataKeyReusePeriodSeconds=$kmsDataKeyReusePeriodSeconds,")
        append("kmsKeyId=$kmsKeyId,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = kmsDataKeyReusePeriodSeconds ?: 0
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (type.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EncryptionConfiguration

        if (kmsDataKeyReusePeriodSeconds != other.kmsDataKeyReusePeriodSeconds) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sfn.model.EncryptionConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Maximum duration that Step Functions will reuse data keys. When the period expires, Step Functions will call `GenerateDataKey`. Only applies to customer managed keys.
         */
        public var kmsDataKeyReusePeriodSeconds: kotlin.Int? = null
        /**
         * An alias, alias ARN, key ID, or key ARN of a symmetric encryption KMS key to encrypt data. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN or alias ARN.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * Encryption type
         */
        public var type: aws.sdk.kotlin.services.sfn.model.EncryptionType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sfn.model.EncryptionConfiguration) : this() {
            this.kmsDataKeyReusePeriodSeconds = x.kmsDataKeyReusePeriodSeconds
            this.kmsKeyId = x.kmsKeyId
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sfn.model.EncryptionConfiguration = EncryptionConfiguration(this)

        internal fun correctErrors(): Builder {
            if (type == null) type = EncryptionType.SdkUnknown("no value provided")
            return this
        }
    }
}
