// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sfn.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class DescribeStateMachineResponse private constructor(builder: Builder) {
    /**
     * The date the state machine is created.
     *
     * For a state machine version, `creationDate` is the date the version was created.
     */
    public val creationDate: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.creationDate) { "A non-null value must be provided for creationDate" }
    /**
     * The Amazon States Language definition of the state machine. See [Amazon States Language](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html).
     *
     * If called with `includedData = METADATA_ONLY`, the returned definition will be `{}`.
     */
    public val definition: kotlin.String = requireNotNull(builder.definition) { "A non-null value must be provided for definition" }
    /**
     * The description of the state machine version.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Settings to configure server-side encryption.
     */
    public val encryptionConfiguration: aws.sdk.kotlin.services.sfn.model.EncryptionConfiguration? = builder.encryptionConfiguration
    /**
     * A user-defined or an auto-generated string that identifies a `Map` state. This parameter is present only if the `stateMachineArn` specified in input is a qualified state machine ARN.
     */
    public val label: kotlin.String? = builder.label
    /**
     * The `LoggingConfiguration` data type is used to set CloudWatch Logs options.
     */
    public val loggingConfiguration: aws.sdk.kotlin.services.sfn.model.LoggingConfiguration? = builder.loggingConfiguration
    /**
     * The name of the state machine.
     *
     * A name must *not* contain:
     * + white space
     * + brackets `< > { } [ ]`
     * + wildcard characters `? *`
     * + special characters `" # % \ ^ | ~ ` $ & , ; : /`
     * + control characters (`U+0000-001F`, `U+007F-009F`)
     *
     * To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The revision identifier for the state machine.
     *
     * Use the `revisionId` parameter to compare between versions of a state machine configuration used for executions without performing a diff of the properties, such as `definition` and `roleArn`.
     */
    public val revisionId: kotlin.String? = builder.revisionId
    /**
     * The Amazon Resource Name (ARN) of the IAM role used when creating this state machine. (The IAM role maintains security by granting Step Functions access to Amazon Web Services resources.)
     */
    public val roleArn: kotlin.String = requireNotNull(builder.roleArn) { "A non-null value must be provided for roleArn" }
    /**
     * The Amazon Resource Name (ARN) that identifies the state machine.
     *
     * If you specified a state machine version ARN in your request, the API returns the version ARN. The version ARN is a combination of state machine ARN and the version number separated by a colon (:). For example, `stateMachineARN:1`.
     */
    public val stateMachineArn: kotlin.String = requireNotNull(builder.stateMachineArn) { "A non-null value must be provided for stateMachineArn" }
    /**
     * The current status of the state machine.
     */
    public val status: aws.sdk.kotlin.services.sfn.model.StateMachineStatus? = builder.status
    /**
     * Selects whether X-Ray tracing is enabled.
     */
    public val tracingConfiguration: aws.sdk.kotlin.services.sfn.model.TracingConfiguration? = builder.tracingConfiguration
    /**
     * The `type` of the state machine (`STANDARD` or `EXPRESS`).
     */
    public val type: aws.sdk.kotlin.services.sfn.model.StateMachineType = requireNotNull(builder.type) { "A non-null value must be provided for type" }
    /**
     * A map of **state name** to a list of variables referenced by that state. States that do not use variable references will not be shown in the response.
     */
    public val variableReferences: Map<String, List<String>>? = builder.variableReferences

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sfn.model.DescribeStateMachineResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeStateMachineResponse(")
        append("creationDate=$creationDate,")
        append("definition=*** Sensitive Data Redacted ***,")
        append("description=*** Sensitive Data Redacted ***,")
        append("encryptionConfiguration=$encryptionConfiguration,")
        append("label=$label,")
        append("loggingConfiguration=$loggingConfiguration,")
        append("name=$name,")
        append("revisionId=$revisionId,")
        append("roleArn=$roleArn,")
        append("stateMachineArn=$stateMachineArn,")
        append("status=$status,")
        append("tracingConfiguration=$tracingConfiguration,")
        append("type=$type,")
        append("variableReferences=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationDate.hashCode()
        result = 31 * result + (definition.hashCode())
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (encryptionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (label?.hashCode() ?: 0)
        result = 31 * result + (loggingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (revisionId?.hashCode() ?: 0)
        result = 31 * result + (roleArn.hashCode())
        result = 31 * result + (stateMachineArn.hashCode())
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tracingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (type.hashCode())
        result = 31 * result + (variableReferences?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeStateMachineResponse

        if (creationDate != other.creationDate) return false
        if (definition != other.definition) return false
        if (description != other.description) return false
        if (encryptionConfiguration != other.encryptionConfiguration) return false
        if (label != other.label) return false
        if (loggingConfiguration != other.loggingConfiguration) return false
        if (name != other.name) return false
        if (revisionId != other.revisionId) return false
        if (roleArn != other.roleArn) return false
        if (stateMachineArn != other.stateMachineArn) return false
        if (status != other.status) return false
        if (tracingConfiguration != other.tracingConfiguration) return false
        if (type != other.type) return false
        if (variableReferences != other.variableReferences) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sfn.model.DescribeStateMachineResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The date the state machine is created.
         *
         * For a state machine version, `creationDate` is the date the version was created.
         */
        public var creationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon States Language definition of the state machine. See [Amazon States Language](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html).
         *
         * If called with `includedData = METADATA_ONLY`, the returned definition will be `{}`.
         */
        public var definition: kotlin.String? = null
        /**
         * The description of the state machine version.
         */
        public var description: kotlin.String? = null
        /**
         * Settings to configure server-side encryption.
         */
        public var encryptionConfiguration: aws.sdk.kotlin.services.sfn.model.EncryptionConfiguration? = null
        /**
         * A user-defined or an auto-generated string that identifies a `Map` state. This parameter is present only if the `stateMachineArn` specified in input is a qualified state machine ARN.
         */
        public var label: kotlin.String? = null
        /**
         * The `LoggingConfiguration` data type is used to set CloudWatch Logs options.
         */
        public var loggingConfiguration: aws.sdk.kotlin.services.sfn.model.LoggingConfiguration? = null
        /**
         * The name of the state machine.
         *
         * A name must *not* contain:
         * + white space
         * + brackets `< > { } [ ]`
         * + wildcard characters `? *`
         * + special characters `" # % \ ^ | ~ ` $ & , ; : /`
         * + control characters (`U+0000-001F`, `U+007F-009F`)
         *
         * To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.
         */
        public var name: kotlin.String? = null
        /**
         * The revision identifier for the state machine.
         *
         * Use the `revisionId` parameter to compare between versions of a state machine configuration used for executions without performing a diff of the properties, such as `definition` and `roleArn`.
         */
        public var revisionId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role used when creating this state machine. (The IAM role maintains security by granting Step Functions access to Amazon Web Services resources.)
         */
        public var roleArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) that identifies the state machine.
         *
         * If you specified a state machine version ARN in your request, the API returns the version ARN. The version ARN is a combination of state machine ARN and the version number separated by a colon (:). For example, `stateMachineARN:1`.
         */
        public var stateMachineArn: kotlin.String? = null
        /**
         * The current status of the state machine.
         */
        public var status: aws.sdk.kotlin.services.sfn.model.StateMachineStatus? = null
        /**
         * Selects whether X-Ray tracing is enabled.
         */
        public var tracingConfiguration: aws.sdk.kotlin.services.sfn.model.TracingConfiguration? = null
        /**
         * The `type` of the state machine (`STANDARD` or `EXPRESS`).
         */
        public var type: aws.sdk.kotlin.services.sfn.model.StateMachineType? = null
        /**
         * A map of **state name** to a list of variables referenced by that state. States that do not use variable references will not be shown in the response.
         */
        public var variableReferences: Map<String, List<String>>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sfn.model.DescribeStateMachineResponse) : this() {
            this.creationDate = x.creationDate
            this.definition = x.definition
            this.description = x.description
            this.encryptionConfiguration = x.encryptionConfiguration
            this.label = x.label
            this.loggingConfiguration = x.loggingConfiguration
            this.name = x.name
            this.revisionId = x.revisionId
            this.roleArn = x.roleArn
            this.stateMachineArn = x.stateMachineArn
            this.status = x.status
            this.tracingConfiguration = x.tracingConfiguration
            this.type = x.type
            this.variableReferences = x.variableReferences
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sfn.model.DescribeStateMachineResponse = DescribeStateMachineResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.sfn.model.EncryptionConfiguration] inside the given [block]
         */
        public fun encryptionConfiguration(block: aws.sdk.kotlin.services.sfn.model.EncryptionConfiguration.Builder.() -> kotlin.Unit) {
            this.encryptionConfiguration = aws.sdk.kotlin.services.sfn.model.EncryptionConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sfn.model.LoggingConfiguration] inside the given [block]
         */
        public fun loggingConfiguration(block: aws.sdk.kotlin.services.sfn.model.LoggingConfiguration.Builder.() -> kotlin.Unit) {
            this.loggingConfiguration = aws.sdk.kotlin.services.sfn.model.LoggingConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sfn.model.TracingConfiguration] inside the given [block]
         */
        public fun tracingConfiguration(block: aws.sdk.kotlin.services.sfn.model.TracingConfiguration.Builder.() -> kotlin.Unit) {
            this.tracingConfiguration = aws.sdk.kotlin.services.sfn.model.TracingConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (creationDate == null) creationDate = Instant.fromEpochSeconds(0)
            if (definition == null) definition = ""
            if (name == null) name = ""
            if (roleArn == null) roleArn = ""
            if (stateMachineArn == null) stateMachineArn = ""
            if (type == null) type = StateMachineType.SdkUnknown("no value provided")
            return this
        }
    }
}
