// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sfn.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class DescribeStateMachineForExecutionResponse private constructor(builder: Builder) {
    /**
     * The Amazon States Language definition of the state machine. See [Amazon States Language](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html).
     */
    public val definition: kotlin.String = requireNotNull(builder.definition) { "A non-null value must be provided for definition" }
    /**
     * Settings to configure server-side encryption.
     */
    public val encryptionConfiguration: aws.sdk.kotlin.services.sfn.model.EncryptionConfiguration? = builder.encryptionConfiguration
    /**
     * A user-defined or an auto-generated string that identifies a `Map` state. This ﬁeld is returned only if the `executionArn` is a child workflow execution that was started by a Distributed Map state.
     */
    public val label: kotlin.String? = builder.label
    /**
     * The `LoggingConfiguration` data type is used to set CloudWatch Logs options.
     */
    public val loggingConfiguration: aws.sdk.kotlin.services.sfn.model.LoggingConfiguration? = builder.loggingConfiguration
    /**
     * The Amazon Resource Name (ARN) of the Map Run that started the child workflow execution. This field is returned only if the `executionArn` is a child workflow execution that was started by a Distributed Map state.
     */
    public val mapRunArn: kotlin.String? = builder.mapRunArn
    /**
     * The name of the state machine associated with the execution.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The revision identifier for the state machine. The first revision ID when you create the state machine is null.
     *
     * Use the state machine `revisionId` parameter to compare the revision of a state machine with the configuration of the state machine used for executions without performing a diff of the properties, such as `definition` and `roleArn`.
     */
    public val revisionId: kotlin.String? = builder.revisionId
    /**
     * The Amazon Resource Name (ARN) of the IAM role of the State Machine for the execution.
     */
    public val roleArn: kotlin.String = requireNotNull(builder.roleArn) { "A non-null value must be provided for roleArn" }
    /**
     * The Amazon Resource Name (ARN) of the state machine associated with the execution.
     */
    public val stateMachineArn: kotlin.String = requireNotNull(builder.stateMachineArn) { "A non-null value must be provided for stateMachineArn" }
    /**
     * Selects whether X-Ray tracing is enabled.
     */
    public val tracingConfiguration: aws.sdk.kotlin.services.sfn.model.TracingConfiguration? = builder.tracingConfiguration
    /**
     * The date and time the state machine associated with an execution was updated. For a newly created state machine, this is the creation date.
     */
    public val updateDate: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updateDate) { "A non-null value must be provided for updateDate" }
    /**
     * A map of **state name** to a list of variables referenced by that state. States that do not use variable references will not be shown in the response.
     */
    public val variableReferences: Map<String, List<String>>? = builder.variableReferences

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sfn.model.DescribeStateMachineForExecutionResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeStateMachineForExecutionResponse(")
        append("definition=*** Sensitive Data Redacted ***,")
        append("encryptionConfiguration=$encryptionConfiguration,")
        append("label=$label,")
        append("loggingConfiguration=$loggingConfiguration,")
        append("mapRunArn=$mapRunArn,")
        append("name=$name,")
        append("revisionId=$revisionId,")
        append("roleArn=$roleArn,")
        append("stateMachineArn=$stateMachineArn,")
        append("tracingConfiguration=$tracingConfiguration,")
        append("updateDate=$updateDate,")
        append("variableReferences=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = definition.hashCode()
        result = 31 * result + (encryptionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (label?.hashCode() ?: 0)
        result = 31 * result + (loggingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (mapRunArn?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (revisionId?.hashCode() ?: 0)
        result = 31 * result + (roleArn.hashCode())
        result = 31 * result + (stateMachineArn.hashCode())
        result = 31 * result + (tracingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (updateDate.hashCode())
        result = 31 * result + (variableReferences?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeStateMachineForExecutionResponse

        if (definition != other.definition) return false
        if (encryptionConfiguration != other.encryptionConfiguration) return false
        if (label != other.label) return false
        if (loggingConfiguration != other.loggingConfiguration) return false
        if (mapRunArn != other.mapRunArn) return false
        if (name != other.name) return false
        if (revisionId != other.revisionId) return false
        if (roleArn != other.roleArn) return false
        if (stateMachineArn != other.stateMachineArn) return false
        if (tracingConfiguration != other.tracingConfiguration) return false
        if (updateDate != other.updateDate) return false
        if (variableReferences != other.variableReferences) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sfn.model.DescribeStateMachineForExecutionResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon States Language definition of the state machine. See [Amazon States Language](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html).
         */
        public var definition: kotlin.String? = null
        /**
         * Settings to configure server-side encryption.
         */
        public var encryptionConfiguration: aws.sdk.kotlin.services.sfn.model.EncryptionConfiguration? = null
        /**
         * A user-defined or an auto-generated string that identifies a `Map` state. This ﬁeld is returned only if the `executionArn` is a child workflow execution that was started by a Distributed Map state.
         */
        public var label: kotlin.String? = null
        /**
         * The `LoggingConfiguration` data type is used to set CloudWatch Logs options.
         */
        public var loggingConfiguration: aws.sdk.kotlin.services.sfn.model.LoggingConfiguration? = null
        /**
         * The Amazon Resource Name (ARN) of the Map Run that started the child workflow execution. This field is returned only if the `executionArn` is a child workflow execution that was started by a Distributed Map state.
         */
        public var mapRunArn: kotlin.String? = null
        /**
         * The name of the state machine associated with the execution.
         */
        public var name: kotlin.String? = null
        /**
         * The revision identifier for the state machine. The first revision ID when you create the state machine is null.
         *
         * Use the state machine `revisionId` parameter to compare the revision of a state machine with the configuration of the state machine used for executions without performing a diff of the properties, such as `definition` and `roleArn`.
         */
        public var revisionId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role of the State Machine for the execution.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the state machine associated with the execution.
         */
        public var stateMachineArn: kotlin.String? = null
        /**
         * Selects whether X-Ray tracing is enabled.
         */
        public var tracingConfiguration: aws.sdk.kotlin.services.sfn.model.TracingConfiguration? = null
        /**
         * The date and time the state machine associated with an execution was updated. For a newly created state machine, this is the creation date.
         */
        public var updateDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A map of **state name** to a list of variables referenced by that state. States that do not use variable references will not be shown in the response.
         */
        public var variableReferences: Map<String, List<String>>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sfn.model.DescribeStateMachineForExecutionResponse) : this() {
            this.definition = x.definition
            this.encryptionConfiguration = x.encryptionConfiguration
            this.label = x.label
            this.loggingConfiguration = x.loggingConfiguration
            this.mapRunArn = x.mapRunArn
            this.name = x.name
            this.revisionId = x.revisionId
            this.roleArn = x.roleArn
            this.stateMachineArn = x.stateMachineArn
            this.tracingConfiguration = x.tracingConfiguration
            this.updateDate = x.updateDate
            this.variableReferences = x.variableReferences
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sfn.model.DescribeStateMachineForExecutionResponse = DescribeStateMachineForExecutionResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.sfn.model.EncryptionConfiguration] inside the given [block]
         */
        public fun encryptionConfiguration(block: aws.sdk.kotlin.services.sfn.model.EncryptionConfiguration.Builder.() -> kotlin.Unit) {
            this.encryptionConfiguration = aws.sdk.kotlin.services.sfn.model.EncryptionConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sfn.model.LoggingConfiguration] inside the given [block]
         */
        public fun loggingConfiguration(block: aws.sdk.kotlin.services.sfn.model.LoggingConfiguration.Builder.() -> kotlin.Unit) {
            this.loggingConfiguration = aws.sdk.kotlin.services.sfn.model.LoggingConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sfn.model.TracingConfiguration] inside the given [block]
         */
        public fun tracingConfiguration(block: aws.sdk.kotlin.services.sfn.model.TracingConfiguration.Builder.() -> kotlin.Unit) {
            this.tracingConfiguration = aws.sdk.kotlin.services.sfn.model.TracingConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (definition == null) definition = ""
            if (name == null) name = ""
            if (roleArn == null) roleArn = ""
            if (stateMachineArn == null) stateMachineArn = ""
            if (updateDate == null) updateDate = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
