// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sfn.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class DescribeExecutionResponse private constructor(builder: Builder) {
    /**
     * The cause string if the state machine execution failed.
     */
    public val cause: kotlin.String? = builder.cause
    /**
     * The error string if the state machine execution failed.
     */
    public val error: kotlin.String? = builder.error
    /**
     * The Amazon Resource Name (ARN) that identifies the execution.
     */
    public val executionArn: kotlin.String = requireNotNull(builder.executionArn) { "A non-null value must be provided for executionArn" }
    /**
     * The string that contains the JSON input data of the execution. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.
     */
    public val input: kotlin.String? = builder.input
    /**
     * Provides details about execution input or output.
     */
    public val inputDetails: aws.sdk.kotlin.services.sfn.model.CloudWatchEventsExecutionDataDetails? = builder.inputDetails
    /**
     * The Amazon Resource Name (ARN) that identifies a Map Run, which dispatched this execution.
     */
    public val mapRunArn: kotlin.String? = builder.mapRunArn
    /**
     * The name of the execution.
     *
     * A name must *not* contain:
     * + white space
     * + brackets `< > { } [ ]`
     * + wildcard characters `? *`
     * + special characters `" # % \ ^ | ~ ` $ & , ; : /`
     * + control characters (`U+0000-001F`, `U+007F-009F`)
     *
     * To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The JSON output data of the execution. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.
     *
     * This field is set only if the execution succeeds. If the execution fails, this field is null.
     */
    public val output: kotlin.String? = builder.output
    /**
     * Provides details about execution input or output.
     */
    public val outputDetails: aws.sdk.kotlin.services.sfn.model.CloudWatchEventsExecutionDataDetails? = builder.outputDetails
    /**
     * The number of times you've redriven an execution. If you have not yet redriven an execution, the `redriveCount` is 0. This count is only updated if you successfully redrive an execution.
     */
    public val redriveCount: kotlin.Int? = builder.redriveCount
    /**
     * The date the execution was last redriven. If you have not yet redriven an execution, the `redriveDate` is null.
     *
     * The `redriveDate` is unavailable if you redrive a Map Run that starts child workflow executions of type `EXPRESS`.
     */
    public val redriveDate: aws.smithy.kotlin.runtime.time.Instant? = builder.redriveDate
    /**
     * Indicates whether or not an execution can be redriven at a given point in time.
     * + For executions of type `STANDARD`, `redriveStatus` is `NOT_REDRIVABLE` if calling the RedriveExecution API action would return the `ExecutionNotRedrivable` error.
     * + For a Distributed Map that includes child workflows of type `STANDARD`, `redriveStatus` indicates whether or not the Map Run can redrive child workflow executions.
     * + For a Distributed Map that includes child workflows of type `EXPRESS`, `redriveStatus` indicates whether or not the Map Run can redrive child workflow executions.You can redrive failed or timed out `EXPRESS` workflows *only if* they're a part of a Map Run. When you [redrive](https://docs.aws.amazon.com/step-functions/latest/dg/redrive-map-run.html) the Map Run, these workflows are restarted using the StartExecution API action.
     */
    public val redriveStatus: aws.sdk.kotlin.services.sfn.model.ExecutionRedriveStatus? = builder.redriveStatus
    /**
     * When `redriveStatus` is `NOT_REDRIVABLE`, `redriveStatusReason` specifies the reason why an execution cannot be redriven.
     * + For executions of type `STANDARD`, or for a Distributed Map that includes child workflows of type `STANDARD`, `redriveStatusReason` can include one of the following reasons:
     *    + `State machine is in DELETING status`.
     *    + `Execution is RUNNING and cannot be redriven`.
     *    + `Execution is SUCCEEDED and cannot be redriven`.
     *    + `Execution was started before the launch of RedriveExecution`.
     *    + `Execution history event limit exceeded`.
     *    + `Execution has exceeded the max execution time`.
     *    + `Execution redrivable period exceeded`.
     * + For a Distributed Map that includes child workflows of type `EXPRESS`, `redriveStatusReason` is only returned if the child workflows are not redrivable. This happens when the child workflow executions have completed successfully.
     */
    public val redriveStatusReason: kotlin.String? = builder.redriveStatusReason
    /**
     * The date the execution is started.
     */
    public val startDate: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.startDate) { "A non-null value must be provided for startDate" }
    /**
     * The Amazon Resource Name (ARN) of the state machine alias associated with the execution. The alias ARN is a combination of state machine ARN and the alias name separated by a colon (:). For example, `stateMachineARN:PROD`.
     *
     * If you start an execution from a `StartExecution` request with a state machine version ARN, this field will be null.
     */
    public val stateMachineAliasArn: kotlin.String? = builder.stateMachineAliasArn
    /**
     * The Amazon Resource Name (ARN) of the executed stated machine.
     */
    public val stateMachineArn: kotlin.String = requireNotNull(builder.stateMachineArn) { "A non-null value must be provided for stateMachineArn" }
    /**
     * The Amazon Resource Name (ARN) of the state machine version associated with the execution. The version ARN is a combination of state machine ARN and the version number separated by a colon (:). For example, `stateMachineARN:1`.
     *
     * If you start an execution from a `StartExecution` request without specifying a state machine version or alias ARN, Step Functions returns a null value.
     */
    public val stateMachineVersionArn: kotlin.String? = builder.stateMachineVersionArn
    /**
     * The current status of the execution.
     */
    public val status: aws.sdk.kotlin.services.sfn.model.ExecutionStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * If the execution ended, the date the execution stopped.
     */
    public val stopDate: aws.smithy.kotlin.runtime.time.Instant? = builder.stopDate
    /**
     * The X-Ray trace header that was passed to the execution.
     */
    public val traceHeader: kotlin.String? = builder.traceHeader

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sfn.model.DescribeExecutionResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeExecutionResponse(")
        append("cause=*** Sensitive Data Redacted ***,")
        append("error=*** Sensitive Data Redacted ***,")
        append("executionArn=$executionArn,")
        append("input=*** Sensitive Data Redacted ***,")
        append("inputDetails=$inputDetails,")
        append("mapRunArn=$mapRunArn,")
        append("name=$name,")
        append("output=*** Sensitive Data Redacted ***,")
        append("outputDetails=$outputDetails,")
        append("redriveCount=$redriveCount,")
        append("redriveDate=$redriveDate,")
        append("redriveStatus=$redriveStatus,")
        append("redriveStatusReason=*** Sensitive Data Redacted ***,")
        append("startDate=$startDate,")
        append("stateMachineAliasArn=$stateMachineAliasArn,")
        append("stateMachineArn=$stateMachineArn,")
        append("stateMachineVersionArn=$stateMachineVersionArn,")
        append("status=$status,")
        append("stopDate=$stopDate,")
        append("traceHeader=$traceHeader")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cause?.hashCode() ?: 0
        result = 31 * result + (error?.hashCode() ?: 0)
        result = 31 * result + (executionArn.hashCode())
        result = 31 * result + (input?.hashCode() ?: 0)
        result = 31 * result + (inputDetails?.hashCode() ?: 0)
        result = 31 * result + (mapRunArn?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (output?.hashCode() ?: 0)
        result = 31 * result + (outputDetails?.hashCode() ?: 0)
        result = 31 * result + (redriveCount ?: 0)
        result = 31 * result + (redriveDate?.hashCode() ?: 0)
        result = 31 * result + (redriveStatus?.hashCode() ?: 0)
        result = 31 * result + (redriveStatusReason?.hashCode() ?: 0)
        result = 31 * result + (startDate.hashCode())
        result = 31 * result + (stateMachineAliasArn?.hashCode() ?: 0)
        result = 31 * result + (stateMachineArn.hashCode())
        result = 31 * result + (stateMachineVersionArn?.hashCode() ?: 0)
        result = 31 * result + (status.hashCode())
        result = 31 * result + (stopDate?.hashCode() ?: 0)
        result = 31 * result + (traceHeader?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeExecutionResponse

        if (cause != other.cause) return false
        if (error != other.error) return false
        if (executionArn != other.executionArn) return false
        if (input != other.input) return false
        if (inputDetails != other.inputDetails) return false
        if (mapRunArn != other.mapRunArn) return false
        if (name != other.name) return false
        if (output != other.output) return false
        if (outputDetails != other.outputDetails) return false
        if (redriveCount != other.redriveCount) return false
        if (redriveDate != other.redriveDate) return false
        if (redriveStatus != other.redriveStatus) return false
        if (redriveStatusReason != other.redriveStatusReason) return false
        if (startDate != other.startDate) return false
        if (stateMachineAliasArn != other.stateMachineAliasArn) return false
        if (stateMachineArn != other.stateMachineArn) return false
        if (stateMachineVersionArn != other.stateMachineVersionArn) return false
        if (status != other.status) return false
        if (stopDate != other.stopDate) return false
        if (traceHeader != other.traceHeader) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sfn.model.DescribeExecutionResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The cause string if the state machine execution failed.
         */
        public var cause: kotlin.String? = null
        /**
         * The error string if the state machine execution failed.
         */
        public var error: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) that identifies the execution.
         */
        public var executionArn: kotlin.String? = null
        /**
         * The string that contains the JSON input data of the execution. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.
         */
        public var input: kotlin.String? = null
        /**
         * Provides details about execution input or output.
         */
        public var inputDetails: aws.sdk.kotlin.services.sfn.model.CloudWatchEventsExecutionDataDetails? = null
        /**
         * The Amazon Resource Name (ARN) that identifies a Map Run, which dispatched this execution.
         */
        public var mapRunArn: kotlin.String? = null
        /**
         * The name of the execution.
         *
         * A name must *not* contain:
         * + white space
         * + brackets `< > { } [ ]`
         * + wildcard characters `? *`
         * + special characters `" # % \ ^ | ~ ` $ & , ; : /`
         * + control characters (`U+0000-001F`, `U+007F-009F`)
         *
         * To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.
         */
        public var name: kotlin.String? = null
        /**
         * The JSON output data of the execution. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.
         *
         * This field is set only if the execution succeeds. If the execution fails, this field is null.
         */
        public var output: kotlin.String? = null
        /**
         * Provides details about execution input or output.
         */
        public var outputDetails: aws.sdk.kotlin.services.sfn.model.CloudWatchEventsExecutionDataDetails? = null
        /**
         * The number of times you've redriven an execution. If you have not yet redriven an execution, the `redriveCount` is 0. This count is only updated if you successfully redrive an execution.
         */
        public var redriveCount: kotlin.Int? = null
        /**
         * The date the execution was last redriven. If you have not yet redriven an execution, the `redriveDate` is null.
         *
         * The `redriveDate` is unavailable if you redrive a Map Run that starts child workflow executions of type `EXPRESS`.
         */
        public var redriveDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Indicates whether or not an execution can be redriven at a given point in time.
         * + For executions of type `STANDARD`, `redriveStatus` is `NOT_REDRIVABLE` if calling the RedriveExecution API action would return the `ExecutionNotRedrivable` error.
         * + For a Distributed Map that includes child workflows of type `STANDARD`, `redriveStatus` indicates whether or not the Map Run can redrive child workflow executions.
         * + For a Distributed Map that includes child workflows of type `EXPRESS`, `redriveStatus` indicates whether or not the Map Run can redrive child workflow executions.You can redrive failed or timed out `EXPRESS` workflows *only if* they're a part of a Map Run. When you [redrive](https://docs.aws.amazon.com/step-functions/latest/dg/redrive-map-run.html) the Map Run, these workflows are restarted using the StartExecution API action.
         */
        public var redriveStatus: aws.sdk.kotlin.services.sfn.model.ExecutionRedriveStatus? = null
        /**
         * When `redriveStatus` is `NOT_REDRIVABLE`, `redriveStatusReason` specifies the reason why an execution cannot be redriven.
         * + For executions of type `STANDARD`, or for a Distributed Map that includes child workflows of type `STANDARD`, `redriveStatusReason` can include one of the following reasons:
         *    + `State machine is in DELETING status`.
         *    + `Execution is RUNNING and cannot be redriven`.
         *    + `Execution is SUCCEEDED and cannot be redriven`.
         *    + `Execution was started before the launch of RedriveExecution`.
         *    + `Execution history event limit exceeded`.
         *    + `Execution has exceeded the max execution time`.
         *    + `Execution redrivable period exceeded`.
         * + For a Distributed Map that includes child workflows of type `EXPRESS`, `redriveStatusReason` is only returned if the child workflows are not redrivable. This happens when the child workflow executions have completed successfully.
         */
        public var redriveStatusReason: kotlin.String? = null
        /**
         * The date the execution is started.
         */
        public var startDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the state machine alias associated with the execution. The alias ARN is a combination of state machine ARN and the alias name separated by a colon (:). For example, `stateMachineARN:PROD`.
         *
         * If you start an execution from a `StartExecution` request with a state machine version ARN, this field will be null.
         */
        public var stateMachineAliasArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the executed stated machine.
         */
        public var stateMachineArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the state machine version associated with the execution. The version ARN is a combination of state machine ARN and the version number separated by a colon (:). For example, `stateMachineARN:1`.
         *
         * If you start an execution from a `StartExecution` request without specifying a state machine version or alias ARN, Step Functions returns a null value.
         */
        public var stateMachineVersionArn: kotlin.String? = null
        /**
         * The current status of the execution.
         */
        public var status: aws.sdk.kotlin.services.sfn.model.ExecutionStatus? = null
        /**
         * If the execution ended, the date the execution stopped.
         */
        public var stopDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The X-Ray trace header that was passed to the execution.
         */
        public var traceHeader: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sfn.model.DescribeExecutionResponse) : this() {
            this.cause = x.cause
            this.error = x.error
            this.executionArn = x.executionArn
            this.input = x.input
            this.inputDetails = x.inputDetails
            this.mapRunArn = x.mapRunArn
            this.name = x.name
            this.output = x.output
            this.outputDetails = x.outputDetails
            this.redriveCount = x.redriveCount
            this.redriveDate = x.redriveDate
            this.redriveStatus = x.redriveStatus
            this.redriveStatusReason = x.redriveStatusReason
            this.startDate = x.startDate
            this.stateMachineAliasArn = x.stateMachineAliasArn
            this.stateMachineArn = x.stateMachineArn
            this.stateMachineVersionArn = x.stateMachineVersionArn
            this.status = x.status
            this.stopDate = x.stopDate
            this.traceHeader = x.traceHeader
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sfn.model.DescribeExecutionResponse = DescribeExecutionResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.sfn.model.CloudWatchEventsExecutionDataDetails] inside the given [block]
         */
        public fun inputDetails(block: aws.sdk.kotlin.services.sfn.model.CloudWatchEventsExecutionDataDetails.Builder.() -> kotlin.Unit) {
            this.inputDetails = aws.sdk.kotlin.services.sfn.model.CloudWatchEventsExecutionDataDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sfn.model.CloudWatchEventsExecutionDataDetails] inside the given [block]
         */
        public fun outputDetails(block: aws.sdk.kotlin.services.sfn.model.CloudWatchEventsExecutionDataDetails.Builder.() -> kotlin.Unit) {
            this.outputDetails = aws.sdk.kotlin.services.sfn.model.CloudWatchEventsExecutionDataDetails.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (executionArn == null) executionArn = ""
            if (startDate == null) startDate = Instant.fromEpochSeconds(0)
            if (stateMachineArn == null) stateMachineArn = ""
            if (status == null) status = ExecutionStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
