// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sfn.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class CreateStateMachineResponse private constructor(builder: Builder) {
    /**
     * The date the state machine is created.
     */
    public val creationDate: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.creationDate) { "A non-null value must be provided for creationDate" }
    /**
     * The Amazon Resource Name (ARN) that identifies the created state machine.
     */
    public val stateMachineArn: kotlin.String = requireNotNull(builder.stateMachineArn) { "A non-null value must be provided for stateMachineArn" }
    /**
     * The Amazon Resource Name (ARN) that identifies the created state machine version. If you do not set the `publish` parameter to `true`, this field returns null value.
     */
    public val stateMachineVersionArn: kotlin.String? = builder.stateMachineVersionArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sfn.model.CreateStateMachineResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateStateMachineResponse(")
        append("creationDate=$creationDate,")
        append("stateMachineArn=$stateMachineArn,")
        append("stateMachineVersionArn=$stateMachineVersionArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationDate.hashCode()
        result = 31 * result + (stateMachineArn.hashCode())
        result = 31 * result + (stateMachineVersionArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateStateMachineResponse

        if (creationDate != other.creationDate) return false
        if (stateMachineArn != other.stateMachineArn) return false
        if (stateMachineVersionArn != other.stateMachineVersionArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sfn.model.CreateStateMachineResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The date the state machine is created.
         */
        public var creationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) that identifies the created state machine.
         */
        public var stateMachineArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) that identifies the created state machine version. If you do not set the `publish` parameter to `true`, this field returns null value.
         */
        public var stateMachineVersionArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sfn.model.CreateStateMachineResponse) : this() {
            this.creationDate = x.creationDate
            this.stateMachineArn = x.stateMachineArn
            this.stateMachineVersionArn = x.stateMachineVersionArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sfn.model.CreateStateMachineResponse = CreateStateMachineResponse(this)

        internal fun correctErrors(): Builder {
            if (creationDate == null) creationDate = Instant.fromEpochSeconds(0)
            if (stateMachineArn == null) stateMachineArn = ""
            return this
        }
    }
}
