// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sfn.serde

import aws.sdk.kotlin.services.sfn.model.InspectionData
import aws.sdk.kotlin.services.sfn.model.SfnException
import aws.sdk.kotlin.services.sfn.model.TestExecutionStatus
import aws.sdk.kotlin.services.sfn.model.TestStateResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class TestStateOperationDeserializer: HttpDeserializer.NonStreaming<TestStateResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): TestStateResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwTestStateError(context, call, payload)
        }
        val builder = TestStateResponse.Builder()

        if (payload != null) {
            deserializeTestStateOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwTestStateError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SfnException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidDefinition" -> InvalidDefinitionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidExecutionInput" -> InvalidExecutionInputDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidArn" -> InvalidArnDeserializer().deserialize(context, wrappedCall, payload)
        else -> SfnException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeTestStateOperationBody(builder: TestStateResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CAUSE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("cause"))
    val ERROR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("error"))
    val INSPECTIONDATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("inspectionData"))
    val NEXTSTATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextState"))
    val OUTPUT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("output"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CAUSE_DESCRIPTOR)
        field(ERROR_DESCRIPTOR)
        field(INSPECTIONDATA_DESCRIPTOR)
        field(NEXTSTATE_DESCRIPTOR)
        field(OUTPUT_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CAUSE_DESCRIPTOR.index -> builder.cause = deserializeString()
                ERROR_DESCRIPTOR.index -> builder.error = deserializeString()
                INSPECTIONDATA_DESCRIPTOR.index -> builder.inspectionData = deserializeInspectionDataDocument(deserializer)
                NEXTSTATE_DESCRIPTOR.index -> builder.nextState = deserializeString()
                OUTPUT_DESCRIPTOR.index -> builder.output = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { TestExecutionStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
