// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sfn.serde

import aws.sdk.kotlin.services.sfn.model.DescribeStateMachineForExecutionResponse
import aws.sdk.kotlin.services.sfn.model.EncryptionConfiguration
import aws.sdk.kotlin.services.sfn.model.LoggingConfiguration
import aws.sdk.kotlin.services.sfn.model.SfnException
import aws.sdk.kotlin.services.sfn.model.TracingConfiguration
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class DescribeStateMachineForExecutionOperationDeserializer: HttpDeserializer.NonStreaming<DescribeStateMachineForExecutionResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeStateMachineForExecutionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeStateMachineForExecutionError(context, call, payload)
        }
        val builder = DescribeStateMachineForExecutionResponse.Builder()

        if (payload != null) {
            deserializeDescribeStateMachineForExecutionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeStateMachineForExecutionError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SfnException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "KmsInvalidStateException" -> KmsInvalidStateExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "KmsThrottlingException" -> KmsThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ExecutionDoesNotExist" -> ExecutionDoesNotExistDeserializer().deserialize(context, wrappedCall, payload)
        "KmsAccessDeniedException" -> KmsAccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidArn" -> InvalidArnDeserializer().deserialize(context, wrappedCall, payload)
        else -> SfnException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeStateMachineForExecutionOperationBody(builder: DescribeStateMachineForExecutionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DEFINITION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("definition"))
    val ENCRYPTIONCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("encryptionConfiguration"))
    val LABEL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("label"))
    val LOGGINGCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("loggingConfiguration"))
    val MAPRUNARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("mapRunArn"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val REVISIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("revisionId"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("roleArn"))
    val STATEMACHINEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("stateMachineArn"))
    val TRACINGCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("tracingConfiguration"))
    val UPDATEDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("updateDate"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DEFINITION_DESCRIPTOR)
        field(ENCRYPTIONCONFIGURATION_DESCRIPTOR)
        field(LABEL_DESCRIPTOR)
        field(LOGGINGCONFIGURATION_DESCRIPTOR)
        field(MAPRUNARN_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(REVISIONID_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(STATEMACHINEARN_DESCRIPTOR)
        field(TRACINGCONFIGURATION_DESCRIPTOR)
        field(UPDATEDATE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DEFINITION_DESCRIPTOR.index -> builder.definition = deserializeString()
                ENCRYPTIONCONFIGURATION_DESCRIPTOR.index -> builder.encryptionConfiguration = deserializeEncryptionConfigurationDocument(deserializer)
                LABEL_DESCRIPTOR.index -> builder.label = deserializeString()
                LOGGINGCONFIGURATION_DESCRIPTOR.index -> builder.loggingConfiguration = deserializeLoggingConfigurationDocument(deserializer)
                MAPRUNARN_DESCRIPTOR.index -> builder.mapRunArn = deserializeString()
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                REVISIONID_DESCRIPTOR.index -> builder.revisionId = deserializeString()
                ROLEARN_DESCRIPTOR.index -> builder.roleArn = deserializeString()
                STATEMACHINEARN_DESCRIPTOR.index -> builder.stateMachineArn = deserializeString()
                TRACINGCONFIGURATION_DESCRIPTOR.index -> builder.tracingConfiguration = deserializeTracingConfigurationDocument(deserializer)
                UPDATEDATE_DESCRIPTOR.index -> builder.updateDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
