// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sfn.serde

import aws.sdk.kotlin.services.sfn.model.DescribeStateMachineAliasResponse
import aws.sdk.kotlin.services.sfn.model.RoutingConfigurationListItem
import aws.sdk.kotlin.services.sfn.model.SfnException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf


internal class DescribeStateMachineAliasOperationDeserializer: HttpDeserializer.NonStreaming<DescribeStateMachineAliasResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeStateMachineAliasResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeStateMachineAliasError(context, call, payload)
        }
        val builder = DescribeStateMachineAliasResponse.Builder()

        if (payload != null) {
            deserializeDescribeStateMachineAliasOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeStateMachineAliasError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SfnException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFound" -> ResourceNotFoundDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidArn" -> InvalidArnDeserializer().deserialize(context, wrappedCall, payload)
        else -> SfnException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeStateMachineAliasOperationBody(builder: DescribeStateMachineAliasResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("creationDate"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val ROUTINGCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("routingConfiguration"))
    val STATEMACHINEALIASARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("stateMachineAliasArn"))
    val UPDATEDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("updateDate"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATIONDATE_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(ROUTINGCONFIGURATION_DESCRIPTOR)
        field(STATEMACHINEALIASARN_DESCRIPTOR)
        field(UPDATEDATE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATIONDATE_DESCRIPTOR.index -> builder.creationDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                ROUTINGCONFIGURATION_DESCRIPTOR.index -> builder.routingConfiguration =
                    deserializer.deserializeList(ROUTINGCONFIGURATION_DESCRIPTOR) {
                        val col0 = mutableListOf<RoutingConfigurationListItem>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeRoutingConfigurationListItemDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                STATEMACHINEALIASARN_DESCRIPTOR.index -> builder.stateMachineAliasArn = deserializeString()
                UPDATEDATE_DESCRIPTOR.index -> builder.updateDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
