// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sfn.serde

import aws.sdk.kotlin.services.sfn.model.DescribeMapRunResponse
import aws.sdk.kotlin.services.sfn.model.MapRunExecutionCounts
import aws.sdk.kotlin.services.sfn.model.MapRunItemCounts
import aws.sdk.kotlin.services.sfn.model.MapRunStatus
import aws.sdk.kotlin.services.sfn.model.SfnException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class DescribeMapRunOperationDeserializer: HttpDeserializer.NonStreaming<DescribeMapRunResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeMapRunResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeMapRunError(context, call, payload)
        }
        val builder = DescribeMapRunResponse.Builder()

        if (payload != null) {
            deserializeDescribeMapRunOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeMapRunError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SfnException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFound" -> ResourceNotFoundDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidArn" -> InvalidArnDeserializer().deserialize(context, wrappedCall, payload)
        else -> SfnException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeMapRunOperationBody(builder: DescribeMapRunResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val EXECUTIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("executionArn"))
    val EXECUTIONCOUNTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("executionCounts"))
    val ITEMCOUNTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("itemCounts"))
    val MAPRUNARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("mapRunArn"))
    val MAXCONCURRENCY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("maxConcurrency"))
    val REDRIVECOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("redriveCount"))
    val REDRIVEDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("redriveDate"))
    val STARTDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("startDate"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("status"))
    val STOPDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("stopDate"))
    val TOLERATEDFAILURECOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("toleratedFailureCount"))
    val TOLERATEDFAILUREPERCENTAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Float, JsonSerialName("toleratedFailurePercentage"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(EXECUTIONARN_DESCRIPTOR)
        field(EXECUTIONCOUNTS_DESCRIPTOR)
        field(ITEMCOUNTS_DESCRIPTOR)
        field(MAPRUNARN_DESCRIPTOR)
        field(MAXCONCURRENCY_DESCRIPTOR)
        field(REDRIVECOUNT_DESCRIPTOR)
        field(REDRIVEDATE_DESCRIPTOR)
        field(STARTDATE_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(STOPDATE_DESCRIPTOR)
        field(TOLERATEDFAILURECOUNT_DESCRIPTOR)
        field(TOLERATEDFAILUREPERCENTAGE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                EXECUTIONARN_DESCRIPTOR.index -> builder.executionArn = deserializeString()
                EXECUTIONCOUNTS_DESCRIPTOR.index -> builder.executionCounts = deserializeMapRunExecutionCountsDocument(deserializer)
                ITEMCOUNTS_DESCRIPTOR.index -> builder.itemCounts = deserializeMapRunItemCountsDocument(deserializer)
                MAPRUNARN_DESCRIPTOR.index -> builder.mapRunArn = deserializeString()
                MAXCONCURRENCY_DESCRIPTOR.index -> builder.maxConcurrency = deserializeInt()
                REDRIVECOUNT_DESCRIPTOR.index -> builder.redriveCount = deserializeInt()
                REDRIVEDATE_DESCRIPTOR.index -> builder.redriveDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                STARTDATE_DESCRIPTOR.index -> builder.startDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { MapRunStatus.fromValue(it) }
                STOPDATE_DESCRIPTOR.index -> builder.stopDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                TOLERATEDFAILURECOUNT_DESCRIPTOR.index -> builder.toleratedFailureCount = deserializeLong()
                TOLERATEDFAILUREPERCENTAGE_DESCRIPTOR.index -> builder.toleratedFailurePercentage = deserializeFloat()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
