// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sfn.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ValidateStateMachineDefinitionRequest private constructor(builder: Builder) {
    /**
     * The Amazon States Language definition of the state machine. For more information, see [Amazon States Language](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html) (ASL).
     */
    public val definition: kotlin.String? = builder.definition
    /**
     * The maximum number of diagnostics that are returned per call. The default and maximum value is 100. Setting the value to 0 will also use the default of 100.
     *
     * If the number of diagnostics returned in the response exceeds `maxResults`, the value of the `truncated` field in the response will be set to `true`.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * Minimum level of diagnostics to return. `ERROR` returns only `ERROR` diagnostics, whereas `WARNING` returns both `WARNING` and `ERROR` diagnostics. The default is `ERROR`.
     */
    public val severity: aws.sdk.kotlin.services.sfn.model.ValidateStateMachineDefinitionSeverity? = builder.severity
    /**
     * The target type of state machine for this definition. The default is `STANDARD`.
     */
    public val type: aws.sdk.kotlin.services.sfn.model.StateMachineType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sfn.model.ValidateStateMachineDefinitionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ValidateStateMachineDefinitionRequest(")
        append("definition=*** Sensitive Data Redacted ***,")
        append("maxResults=$maxResults,")
        append("severity=$severity,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = definition?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (severity?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ValidateStateMachineDefinitionRequest

        if (definition != other.definition) return false
        if (maxResults != other.maxResults) return false
        if (severity != other.severity) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sfn.model.ValidateStateMachineDefinitionRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon States Language definition of the state machine. For more information, see [Amazon States Language](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html) (ASL).
         */
        public var definition: kotlin.String? = null
        /**
         * The maximum number of diagnostics that are returned per call. The default and maximum value is 100. Setting the value to 0 will also use the default of 100.
         *
         * If the number of diagnostics returned in the response exceeds `maxResults`, the value of the `truncated` field in the response will be set to `true`.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * Minimum level of diagnostics to return. `ERROR` returns only `ERROR` diagnostics, whereas `WARNING` returns both `WARNING` and `ERROR` diagnostics. The default is `ERROR`.
         */
        public var severity: aws.sdk.kotlin.services.sfn.model.ValidateStateMachineDefinitionSeverity? = null
        /**
         * The target type of state machine for this definition. The default is `STANDARD`.
         */
        public var type: aws.sdk.kotlin.services.sfn.model.StateMachineType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sfn.model.ValidateStateMachineDefinitionRequest) : this() {
            this.definition = x.definition
            this.maxResults = x.maxResults
            this.severity = x.severity
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sfn.model.ValidateStateMachineDefinitionRequest = ValidateStateMachineDefinitionRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
