// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sfn.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateStateMachineRequest private constructor(builder: Builder) {
    /**
     * The Amazon States Language definition of the state machine. See [Amazon States Language](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html).
     */
    public val definition: kotlin.String? = builder.definition
    /**
     * Settings to configure server-side encryption.
     */
    public val encryptionConfiguration: aws.sdk.kotlin.services.sfn.model.EncryptionConfiguration? = builder.encryptionConfiguration
    /**
     * Use the `LoggingConfiguration` data type to set CloudWatch Logs options.
     */
    public val loggingConfiguration: aws.sdk.kotlin.services.sfn.model.LoggingConfiguration? = builder.loggingConfiguration
    /**
     * Specifies whether the state machine version is published. The default is `false`. To publish a version after updating the state machine, set `publish` to `true`.
     */
    public val publish: kotlin.Boolean? = builder.publish
    /**
     * The Amazon Resource Name (ARN) of the IAM role of the state machine.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The Amazon Resource Name (ARN) of the state machine.
     */
    public val stateMachineArn: kotlin.String? = builder.stateMachineArn
    /**
     * Selects whether X-Ray tracing is enabled.
     */
    public val tracingConfiguration: aws.sdk.kotlin.services.sfn.model.TracingConfiguration? = builder.tracingConfiguration
    /**
     * An optional description of the state machine version to publish.
     *
     * You can only specify the `versionDescription` parameter if you've set `publish` to `true`.
     */
    public val versionDescription: kotlin.String? = builder.versionDescription

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sfn.model.UpdateStateMachineRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateStateMachineRequest(")
        append("definition=*** Sensitive Data Redacted ***,")
        append("encryptionConfiguration=$encryptionConfiguration,")
        append("loggingConfiguration=$loggingConfiguration,")
        append("publish=$publish,")
        append("roleArn=$roleArn,")
        append("stateMachineArn=$stateMachineArn,")
        append("tracingConfiguration=$tracingConfiguration,")
        append("versionDescription=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = definition?.hashCode() ?: 0
        result = 31 * result + (encryptionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (loggingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (publish?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (stateMachineArn?.hashCode() ?: 0)
        result = 31 * result + (tracingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (versionDescription?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateStateMachineRequest

        if (definition != other.definition) return false
        if (encryptionConfiguration != other.encryptionConfiguration) return false
        if (loggingConfiguration != other.loggingConfiguration) return false
        if (publish != other.publish) return false
        if (roleArn != other.roleArn) return false
        if (stateMachineArn != other.stateMachineArn) return false
        if (tracingConfiguration != other.tracingConfiguration) return false
        if (versionDescription != other.versionDescription) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sfn.model.UpdateStateMachineRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon States Language definition of the state machine. See [Amazon States Language](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html).
         */
        public var definition: kotlin.String? = null
        /**
         * Settings to configure server-side encryption.
         */
        public var encryptionConfiguration: aws.sdk.kotlin.services.sfn.model.EncryptionConfiguration? = null
        /**
         * Use the `LoggingConfiguration` data type to set CloudWatch Logs options.
         */
        public var loggingConfiguration: aws.sdk.kotlin.services.sfn.model.LoggingConfiguration? = null
        /**
         * Specifies whether the state machine version is published. The default is `false`. To publish a version after updating the state machine, set `publish` to `true`.
         */
        public var publish: kotlin.Boolean? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role of the state machine.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the state machine.
         */
        public var stateMachineArn: kotlin.String? = null
        /**
         * Selects whether X-Ray tracing is enabled.
         */
        public var tracingConfiguration: aws.sdk.kotlin.services.sfn.model.TracingConfiguration? = null
        /**
         * An optional description of the state machine version to publish.
         *
         * You can only specify the `versionDescription` parameter if you've set `publish` to `true`.
         */
        public var versionDescription: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sfn.model.UpdateStateMachineRequest) : this() {
            this.definition = x.definition
            this.encryptionConfiguration = x.encryptionConfiguration
            this.loggingConfiguration = x.loggingConfiguration
            this.publish = x.publish
            this.roleArn = x.roleArn
            this.stateMachineArn = x.stateMachineArn
            this.tracingConfiguration = x.tracingConfiguration
            this.versionDescription = x.versionDescription
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sfn.model.UpdateStateMachineRequest = UpdateStateMachineRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.sfn.model.EncryptionConfiguration] inside the given [block]
         */
        public fun encryptionConfiguration(block: aws.sdk.kotlin.services.sfn.model.EncryptionConfiguration.Builder.() -> kotlin.Unit) {
            this.encryptionConfiguration = aws.sdk.kotlin.services.sfn.model.EncryptionConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sfn.model.LoggingConfiguration] inside the given [block]
         */
        public fun loggingConfiguration(block: aws.sdk.kotlin.services.sfn.model.LoggingConfiguration.Builder.() -> kotlin.Unit) {
            this.loggingConfiguration = aws.sdk.kotlin.services.sfn.model.LoggingConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sfn.model.TracingConfiguration] inside the given [block]
         */
        public fun tracingConfiguration(block: aws.sdk.kotlin.services.sfn.model.TracingConfiguration.Builder.() -> kotlin.Unit) {
            this.tracingConfiguration = aws.sdk.kotlin.services.sfn.model.TracingConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
