// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sfn.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains details about a task submitted to a resource .
 */
public class TaskSubmittedEventDetails private constructor(builder: Builder) {
    /**
     * The response from a resource when a task has started. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.
     */
    public val output: kotlin.String? = builder.output
    /**
     * Contains details about the output of an execution history event.
     */
    public val outputDetails: aws.sdk.kotlin.services.sfn.model.HistoryEventExecutionDataDetails? = builder.outputDetails
    /**
     * The action of the resource called by a task state.
     */
    public val resource: kotlin.String = requireNotNull(builder.resource) { "A non-null value must be provided for resource" }
    /**
     * The service name of the resource in a task state.
     */
    public val resourceType: kotlin.String = requireNotNull(builder.resourceType) { "A non-null value must be provided for resourceType" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sfn.model.TaskSubmittedEventDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TaskSubmittedEventDetails(")
        append("output=*** Sensitive Data Redacted ***,")
        append("outputDetails=$outputDetails,")
        append("resource=$resource,")
        append("resourceType=$resourceType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = output?.hashCode() ?: 0
        result = 31 * result + (outputDetails?.hashCode() ?: 0)
        result = 31 * result + (resource.hashCode())
        result = 31 * result + (resourceType.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TaskSubmittedEventDetails

        if (output != other.output) return false
        if (outputDetails != other.outputDetails) return false
        if (resource != other.resource) return false
        if (resourceType != other.resourceType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sfn.model.TaskSubmittedEventDetails = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The response from a resource when a task has started. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.
         */
        public var output: kotlin.String? = null
        /**
         * Contains details about the output of an execution history event.
         */
        public var outputDetails: aws.sdk.kotlin.services.sfn.model.HistoryEventExecutionDataDetails? = null
        /**
         * The action of the resource called by a task state.
         */
        public var resource: kotlin.String? = null
        /**
         * The service name of the resource in a task state.
         */
        public var resourceType: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sfn.model.TaskSubmittedEventDetails) : this() {
            this.output = x.output
            this.outputDetails = x.outputDetails
            this.resource = x.resource
            this.resourceType = x.resourceType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sfn.model.TaskSubmittedEventDetails = TaskSubmittedEventDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.sfn.model.HistoryEventExecutionDataDetails] inside the given [block]
         */
        public fun outputDetails(block: aws.sdk.kotlin.services.sfn.model.HistoryEventExecutionDataDetails.Builder.() -> kotlin.Unit) {
            this.outputDetails = aws.sdk.kotlin.services.sfn.model.HistoryEventExecutionDataDetails.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (resource == null) resource = ""
            if (resourceType == null) resourceType = ""
            return this
        }
    }
}
