// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sfn.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains details about a task scheduled during an execution.
 */
public class TaskScheduledEventDetails private constructor(builder: Builder) {
    /**
     * The maximum allowed duration between two heartbeats for the task.
     */
    public val heartbeatInSeconds: kotlin.Long? = builder.heartbeatInSeconds
    /**
     * The JSON data passed to the resource referenced in a task state. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.
     */
    public val parameters: kotlin.String = requireNotNull(builder.parameters) { "A non-null value must be provided for parameters" }
    /**
     * The region of the scheduled task
     */
    public val region: kotlin.String = requireNotNull(builder.region) { "A non-null value must be provided for region" }
    /**
     * The action of the resource called by a task state.
     */
    public val resource: kotlin.String = requireNotNull(builder.resource) { "A non-null value must be provided for resource" }
    /**
     * The service name of the resource in a task state.
     */
    public val resourceType: kotlin.String = requireNotNull(builder.resourceType) { "A non-null value must be provided for resourceType" }
    /**
     * The credentials that Step Functions uses for the task.
     */
    public val taskCredentials: aws.sdk.kotlin.services.sfn.model.TaskCredentials? = builder.taskCredentials
    /**
     * The maximum allowed duration of the task.
     */
    public val timeoutInSeconds: kotlin.Long? = builder.timeoutInSeconds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sfn.model.TaskScheduledEventDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TaskScheduledEventDetails(")
        append("heartbeatInSeconds=$heartbeatInSeconds,")
        append("parameters=*** Sensitive Data Redacted ***,")
        append("region=$region,")
        append("resource=$resource,")
        append("resourceType=$resourceType,")
        append("taskCredentials=$taskCredentials,")
        append("timeoutInSeconds=$timeoutInSeconds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = heartbeatInSeconds?.hashCode() ?: 0
        result = 31 * result + (parameters.hashCode())
        result = 31 * result + (region.hashCode())
        result = 31 * result + (resource.hashCode())
        result = 31 * result + (resourceType.hashCode())
        result = 31 * result + (taskCredentials?.hashCode() ?: 0)
        result = 31 * result + (timeoutInSeconds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TaskScheduledEventDetails

        if (heartbeatInSeconds != other.heartbeatInSeconds) return false
        if (parameters != other.parameters) return false
        if (region != other.region) return false
        if (resource != other.resource) return false
        if (resourceType != other.resourceType) return false
        if (taskCredentials != other.taskCredentials) return false
        if (timeoutInSeconds != other.timeoutInSeconds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sfn.model.TaskScheduledEventDetails = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The maximum allowed duration between two heartbeats for the task.
         */
        public var heartbeatInSeconds: kotlin.Long? = null
        /**
         * The JSON data passed to the resource referenced in a task state. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.
         */
        public var parameters: kotlin.String? = null
        /**
         * The region of the scheduled task
         */
        public var region: kotlin.String? = null
        /**
         * The action of the resource called by a task state.
         */
        public var resource: kotlin.String? = null
        /**
         * The service name of the resource in a task state.
         */
        public var resourceType: kotlin.String? = null
        /**
         * The credentials that Step Functions uses for the task.
         */
        public var taskCredentials: aws.sdk.kotlin.services.sfn.model.TaskCredentials? = null
        /**
         * The maximum allowed duration of the task.
         */
        public var timeoutInSeconds: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sfn.model.TaskScheduledEventDetails) : this() {
            this.heartbeatInSeconds = x.heartbeatInSeconds
            this.parameters = x.parameters
            this.region = x.region
            this.resource = x.resource
            this.resourceType = x.resourceType
            this.taskCredentials = x.taskCredentials
            this.timeoutInSeconds = x.timeoutInSeconds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sfn.model.TaskScheduledEventDetails = TaskScheduledEventDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.sfn.model.TaskCredentials] inside the given [block]
         */
        public fun taskCredentials(block: aws.sdk.kotlin.services.sfn.model.TaskCredentials.Builder.() -> kotlin.Unit) {
            this.taskCredentials = aws.sdk.kotlin.services.sfn.model.TaskCredentials.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (parameters == null) parameters = ""
            if (region == null) region = ""
            if (resource == null) resource = ""
            if (resourceType == null) resourceType = ""
            return this
        }
    }
}
