// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sfn.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains details about a specific state machine version.
 */
public class StateMachineVersionListItem private constructor(builder: Builder) {
    /**
     * The creation date of a state machine version.
     */
    public val creationDate: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.creationDate) { "A non-null value must be provided for creationDate" }
    /**
     * The Amazon Resource Name (ARN) that identifies a state machine version. The version ARN is a combination of state machine ARN and the version number separated by a colon (:). For example, `stateMachineARN:1`.
     */
    public val stateMachineVersionArn: kotlin.String = requireNotNull(builder.stateMachineVersionArn) { "A non-null value must be provided for stateMachineVersionArn" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sfn.model.StateMachineVersionListItem = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StateMachineVersionListItem(")
        append("creationDate=$creationDate,")
        append("stateMachineVersionArn=$stateMachineVersionArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationDate.hashCode()
        result = 31 * result + (stateMachineVersionArn.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StateMachineVersionListItem

        if (creationDate != other.creationDate) return false
        if (stateMachineVersionArn != other.stateMachineVersionArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sfn.model.StateMachineVersionListItem = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The creation date of a state machine version.
         */
        public var creationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) that identifies a state machine version. The version ARN is a combination of state machine ARN and the version number separated by a colon (:). For example, `stateMachineARN:1`.
         */
        public var stateMachineVersionArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sfn.model.StateMachineVersionListItem) : this() {
            this.creationDate = x.creationDate
            this.stateMachineVersionArn = x.stateMachineVersionArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sfn.model.StateMachineVersionListItem = StateMachineVersionListItem(this)

        internal fun correctErrors(): Builder {
            if (creationDate == null) creationDate = Instant.fromEpochSeconds(0)
            if (stateMachineVersionArn == null) stateMachineVersionArn = ""
            return this
        }
    }
}
