// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sfn.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains details about the state machine.
 */
public class StateMachineListItem private constructor(builder: Builder) {
    /**
     * The date the state machine is created.
     */
    public val creationDate: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.creationDate) { "A non-null value must be provided for creationDate" }
    /**
     * The name of the state machine.
     *
     * A name must *not* contain:
     * + white space
     * + brackets `< > { } [ ]`
     * + wildcard characters `? *`
     * + special characters `" # % \ ^ | ~ ` $ & , ; : /`
     * + control characters (`U+0000-001F`, `U+007F-009F`)
     *
     * To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The Amazon Resource Name (ARN) that identifies the state machine.
     */
    public val stateMachineArn: kotlin.String = requireNotNull(builder.stateMachineArn) { "A non-null value must be provided for stateMachineArn" }
    /**
     *
     */
    public val type: aws.sdk.kotlin.services.sfn.model.StateMachineType = requireNotNull(builder.type) { "A non-null value must be provided for type" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sfn.model.StateMachineListItem = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StateMachineListItem(")
        append("creationDate=$creationDate,")
        append("name=$name,")
        append("stateMachineArn=$stateMachineArn,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationDate.hashCode()
        result = 31 * result + (name.hashCode())
        result = 31 * result + (stateMachineArn.hashCode())
        result = 31 * result + (type.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StateMachineListItem

        if (creationDate != other.creationDate) return false
        if (name != other.name) return false
        if (stateMachineArn != other.stateMachineArn) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sfn.model.StateMachineListItem = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The date the state machine is created.
         */
        public var creationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the state machine.
         *
         * A name must *not* contain:
         * + white space
         * + brackets `< > { } [ ]`
         * + wildcard characters `? *`
         * + special characters `" # % \ ^ | ~ ` $ & , ; : /`
         * + control characters (`U+0000-001F`, `U+007F-009F`)
         *
         * To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.
         */
        public var name: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) that identifies the state machine.
         */
        public var stateMachineArn: kotlin.String? = null
        /**
         *
         */
        public var type: aws.sdk.kotlin.services.sfn.model.StateMachineType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sfn.model.StateMachineListItem) : this() {
            this.creationDate = x.creationDate
            this.name = x.name
            this.stateMachineArn = x.stateMachineArn
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sfn.model.StateMachineListItem = StateMachineListItem(this)

        internal fun correctErrors(): Builder {
            if (creationDate == null) creationDate = Instant.fromEpochSeconds(0)
            if (name == null) name = ""
            if (stateMachineArn == null) stateMachineArn = ""
            if (type == null) type = StateMachineType.SdkUnknown("no value provided")
            return this
        }
    }
}
