// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sfn.model

import aws.smithy.kotlin.runtime.SdkDsl

public class StartExecutionRequest private constructor(builder: Builder) {
    /**
     * The string that contains the JSON input data for the execution, for example:
     *
     * `"input": "{\"first_name\" : \"test\"}"`
     *
     * If you don't include any JSON input data, you still must include the two braces, for example: `"input": "{}"`
     *
     * Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.
     */
    public val input: kotlin.String? = builder.input
    /**
     * Optional name of the execution. This name must be unique for your Amazon Web Services account, Region, and state machine for 90 days. For more information, see [ Limits Related to State Machine Executions](https://docs.aws.amazon.com/step-functions/latest/dg/limits.html#service-limits-state-machine-executions) in the *Step Functions Developer Guide*.
     *
     * If you don't provide a name for the execution, Step Functions automatically generates a universally unique identifier (UUID) as the execution name.
     *
     * A name must *not* contain:
     * + white space
     * + brackets `< > { } [ ]`
     * + wildcard characters `? *`
     * + special characters `" # % \ ^ | ~ ` $ & , ; : /`
     * + control characters (`U+0000-001F`, `U+007F-009F`)
     *
     * To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The Amazon Resource Name (ARN) of the state machine to execute.
     *
     * The `stateMachineArn` parameter accepts one of the following inputs:
     * + **An unqualified state machine ARN** – Refers to a state machine ARN that isn't qualified with a version or alias ARN. The following is an example of an unqualified state machine ARN.`arn:<partition>:states:<region>:<account-id>:stateMachine:<myStateMachine>`Step Functions doesn't associate state machine executions that you start with an unqualified ARN with a version. This is true even if that version uses the same revision that the execution used.
     * + **A state machine version ARN** – Refers to a version ARN, which is a combination of state machine ARN and the version number separated by a colon (:). The following is an example of the ARN for version 10. `arn:<partition>:states:<region>:<account-id>:stateMachine:<myStateMachine>:10`Step Functions doesn't associate executions that you start with a version ARN with any aliases that point to that version.
     * + **A state machine alias ARN** – Refers to an alias ARN, which is a combination of state machine ARN and the alias name separated by a colon (:). The following is an example of the ARN for an alias named `PROD`.`arn:<partition>:states:<region>:<account-id>:stateMachine:<myStateMachine:PROD>`Step Functions associates executions that you start with an alias ARN with that alias and the state machine version used for that execution.
     */
    public val stateMachineArn: kotlin.String? = builder.stateMachineArn
    /**
     * Passes the X-Ray trace header. The trace header can also be passed in the request payload.
     */
    public val traceHeader: kotlin.String? = builder.traceHeader

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sfn.model.StartExecutionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartExecutionRequest(")
        append("input=*** Sensitive Data Redacted ***,")
        append("name=$name,")
        append("stateMachineArn=$stateMachineArn,")
        append("traceHeader=$traceHeader")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = input?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (stateMachineArn?.hashCode() ?: 0)
        result = 31 * result + (traceHeader?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartExecutionRequest

        if (input != other.input) return false
        if (name != other.name) return false
        if (stateMachineArn != other.stateMachineArn) return false
        if (traceHeader != other.traceHeader) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sfn.model.StartExecutionRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The string that contains the JSON input data for the execution, for example:
         *
         * `"input": "{\"first_name\" : \"test\"}"`
         *
         * If you don't include any JSON input data, you still must include the two braces, for example: `"input": "{}"`
         *
         * Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.
         */
        public var input: kotlin.String? = null
        /**
         * Optional name of the execution. This name must be unique for your Amazon Web Services account, Region, and state machine for 90 days. For more information, see [ Limits Related to State Machine Executions](https://docs.aws.amazon.com/step-functions/latest/dg/limits.html#service-limits-state-machine-executions) in the *Step Functions Developer Guide*.
         *
         * If you don't provide a name for the execution, Step Functions automatically generates a universally unique identifier (UUID) as the execution name.
         *
         * A name must *not* contain:
         * + white space
         * + brackets `< > { } [ ]`
         * + wildcard characters `? *`
         * + special characters `" # % \ ^ | ~ ` $ & , ; : /`
         * + control characters (`U+0000-001F`, `U+007F-009F`)
         *
         * To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.
         */
        public var name: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the state machine to execute.
         *
         * The `stateMachineArn` parameter accepts one of the following inputs:
         * + **An unqualified state machine ARN** – Refers to a state machine ARN that isn't qualified with a version or alias ARN. The following is an example of an unqualified state machine ARN.`arn:<partition>:states:<region>:<account-id>:stateMachine:<myStateMachine>`Step Functions doesn't associate state machine executions that you start with an unqualified ARN with a version. This is true even if that version uses the same revision that the execution used.
         * + **A state machine version ARN** – Refers to a version ARN, which is a combination of state machine ARN and the version number separated by a colon (:). The following is an example of the ARN for version 10. `arn:<partition>:states:<region>:<account-id>:stateMachine:<myStateMachine>:10`Step Functions doesn't associate executions that you start with a version ARN with any aliases that point to that version.
         * + **A state machine alias ARN** – Refers to an alias ARN, which is a combination of state machine ARN and the alias name separated by a colon (:). The following is an example of the ARN for an alias named `PROD`.`arn:<partition>:states:<region>:<account-id>:stateMachine:<myStateMachine:PROD>`Step Functions associates executions that you start with an alias ARN with that alias and the state machine version used for that execution.
         */
        public var stateMachineArn: kotlin.String? = null
        /**
         * Passes the X-Ray trace header. The trace header can also be passed in the request payload.
         */
        public var traceHeader: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sfn.model.StartExecutionRequest) : this() {
            this.input = x.input
            this.name = x.name
            this.stateMachineArn = x.stateMachineArn
            this.traceHeader = x.traceHeader
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sfn.model.StartExecutionRequest = StartExecutionRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
