// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sfn.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ListExecutionsRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the Map Run that started the child workflow executions. If the `mapRunArn` field is specified, a list of all of the child workflow executions started by a Map Run is returned. For more information, see [Examining Map Run](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-examine-map-run.html) in the *Step Functions Developer Guide*.
     *
     * You can specify either a `mapRunArn` or a `stateMachineArn`, but not both.
     */
    public val mapRunArn: kotlin.String? = builder.mapRunArn
    /**
     * The maximum number of results that are returned per call. You can use `nextToken` to obtain further pages of results. The default is 100 and the maximum allowed page size is 1000. A value of 0 uses the default.
     *
     * This is only an upper limit. The actual number of results returned per call might be fewer than the specified maximum.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * If `nextToken` is returned, there are more results available. The value of `nextToken` is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an *HTTP 400 InvalidToken* error.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * Sets a filter to list executions based on whether or not they have been redriven.
     *
     * For a Distributed Map, `redriveFilter` sets a filter to list child workflow executions based on whether or not they have been redriven.
     *
     * If you do not provide a `redriveFilter`, Step Functions returns a list of both redriven and non-redriven executions.
     *
     * If you provide a state machine ARN in `redriveFilter`, the API returns a validation exception.
     */
    public val redriveFilter: aws.sdk.kotlin.services.sfn.model.ExecutionRedriveFilter? = builder.redriveFilter
    /**
     * The Amazon Resource Name (ARN) of the state machine whose executions is listed.
     *
     * You can specify either a `mapRunArn` or a `stateMachineArn`, but not both.
     *
     * You can also return a list of executions associated with a specific [alias](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html) or [version](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html), by specifying an alias ARN or a version ARN in the `stateMachineArn` parameter.
     */
    public val stateMachineArn: kotlin.String? = builder.stateMachineArn
    /**
     * If specified, only list the executions whose current execution status matches the given filter.
     */
    public val statusFilter: aws.sdk.kotlin.services.sfn.model.ExecutionStatus? = builder.statusFilter

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sfn.model.ListExecutionsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListExecutionsRequest(")
        append("mapRunArn=$mapRunArn,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("redriveFilter=$redriveFilter,")
        append("stateMachineArn=$stateMachineArn,")
        append("statusFilter=$statusFilter")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = mapRunArn?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (redriveFilter?.hashCode() ?: 0)
        result = 31 * result + (stateMachineArn?.hashCode() ?: 0)
        result = 31 * result + (statusFilter?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListExecutionsRequest

        if (mapRunArn != other.mapRunArn) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (redriveFilter != other.redriveFilter) return false
        if (stateMachineArn != other.stateMachineArn) return false
        if (statusFilter != other.statusFilter) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sfn.model.ListExecutionsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the Map Run that started the child workflow executions. If the `mapRunArn` field is specified, a list of all of the child workflow executions started by a Map Run is returned. For more information, see [Examining Map Run](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-examine-map-run.html) in the *Step Functions Developer Guide*.
         *
         * You can specify either a `mapRunArn` or a `stateMachineArn`, but not both.
         */
        public var mapRunArn: kotlin.String? = null
        /**
         * The maximum number of results that are returned per call. You can use `nextToken` to obtain further pages of results. The default is 100 and the maximum allowed page size is 1000. A value of 0 uses the default.
         *
         * This is only an upper limit. The actual number of results returned per call might be fewer than the specified maximum.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * If `nextToken` is returned, there are more results available. The value of `nextToken` is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an *HTTP 400 InvalidToken* error.
         */
        public var nextToken: kotlin.String? = null
        /**
         * Sets a filter to list executions based on whether or not they have been redriven.
         *
         * For a Distributed Map, `redriveFilter` sets a filter to list child workflow executions based on whether or not they have been redriven.
         *
         * If you do not provide a `redriveFilter`, Step Functions returns a list of both redriven and non-redriven executions.
         *
         * If you provide a state machine ARN in `redriveFilter`, the API returns a validation exception.
         */
        public var redriveFilter: aws.sdk.kotlin.services.sfn.model.ExecutionRedriveFilter? = null
        /**
         * The Amazon Resource Name (ARN) of the state machine whose executions is listed.
         *
         * You can specify either a `mapRunArn` or a `stateMachineArn`, but not both.
         *
         * You can also return a list of executions associated with a specific [alias](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html) or [version](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html), by specifying an alias ARN or a version ARN in the `stateMachineArn` parameter.
         */
        public var stateMachineArn: kotlin.String? = null
        /**
         * If specified, only list the executions whose current execution status matches the given filter.
         */
        public var statusFilter: aws.sdk.kotlin.services.sfn.model.ExecutionStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sfn.model.ListExecutionsRequest) : this() {
            this.mapRunArn = x.mapRunArn
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.redriveFilter = x.redriveFilter
            this.stateMachineArn = x.stateMachineArn
            this.statusFilter = x.statusFilter
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sfn.model.ListExecutionsRequest = ListExecutionsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
