// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sfn.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains additional details about the state's execution, including its input and output data processing flow, and HTTP request and response information.
 */
public class InspectionData private constructor(builder: Builder) {
    /**
     * The input after Step Functions applies the [InputPath](https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-inputpath) filter.
     */
    public val afterInputPath: kotlin.String? = builder.afterInputPath
    /**
     * The effective input after Step Functions applies the [Parameters](https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-parameters) filter.
     */
    public val afterParameters: kotlin.String? = builder.afterParameters
    /**
     * The effective result combined with the raw state input after Step Functions applies the [ResultPath](https://docs.aws.amazon.com/step-functions/latest/dg/input-output-resultpath.html) filter.
     */
    public val afterResultPath: kotlin.String? = builder.afterResultPath
    /**
     * The effective result after Step Functions applies the [ResultSelector](https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-resultselector) filter.
     */
    public val afterResultSelector: kotlin.String? = builder.afterResultSelector
    /**
     * The raw state input.
     */
    public val input: kotlin.String? = builder.input
    /**
     * The raw HTTP request that is sent when you test an HTTP Task.
     */
    public val request: aws.sdk.kotlin.services.sfn.model.InspectionDataRequest? = builder.request
    /**
     * The raw HTTP response that is returned when you test an HTTP Task.
     */
    public val response: aws.sdk.kotlin.services.sfn.model.InspectionDataResponse? = builder.response
    /**
     * The state's raw result.
     */
    public val result: kotlin.String? = builder.result

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sfn.model.InspectionData = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InspectionData(")
        append("*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = afterInputPath?.hashCode() ?: 0
        result = 31 * result + (afterParameters?.hashCode() ?: 0)
        result = 31 * result + (afterResultPath?.hashCode() ?: 0)
        result = 31 * result + (afterResultSelector?.hashCode() ?: 0)
        result = 31 * result + (input?.hashCode() ?: 0)
        result = 31 * result + (request?.hashCode() ?: 0)
        result = 31 * result + (response?.hashCode() ?: 0)
        result = 31 * result + (result?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InspectionData

        if (afterInputPath != other.afterInputPath) return false
        if (afterParameters != other.afterParameters) return false
        if (afterResultPath != other.afterResultPath) return false
        if (afterResultSelector != other.afterResultSelector) return false
        if (input != other.input) return false
        if (request != other.request) return false
        if (response != other.response) return false
        if (result != other.result) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sfn.model.InspectionData = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The input after Step Functions applies the [InputPath](https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-inputpath) filter.
         */
        public var afterInputPath: kotlin.String? = null
        /**
         * The effective input after Step Functions applies the [Parameters](https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-parameters) filter.
         */
        public var afterParameters: kotlin.String? = null
        /**
         * The effective result combined with the raw state input after Step Functions applies the [ResultPath](https://docs.aws.amazon.com/step-functions/latest/dg/input-output-resultpath.html) filter.
         */
        public var afterResultPath: kotlin.String? = null
        /**
         * The effective result after Step Functions applies the [ResultSelector](https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-resultselector) filter.
         */
        public var afterResultSelector: kotlin.String? = null
        /**
         * The raw state input.
         */
        public var input: kotlin.String? = null
        /**
         * The raw HTTP request that is sent when you test an HTTP Task.
         */
        public var request: aws.sdk.kotlin.services.sfn.model.InspectionDataRequest? = null
        /**
         * The raw HTTP response that is returned when you test an HTTP Task.
         */
        public var response: aws.sdk.kotlin.services.sfn.model.InspectionDataResponse? = null
        /**
         * The state's raw result.
         */
        public var result: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sfn.model.InspectionData) : this() {
            this.afterInputPath = x.afterInputPath
            this.afterParameters = x.afterParameters
            this.afterResultPath = x.afterResultPath
            this.afterResultSelector = x.afterResultSelector
            this.input = x.input
            this.request = x.request
            this.response = x.response
            this.result = x.result
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sfn.model.InspectionData = InspectionData(this)

        /**
         * construct an [aws.sdk.kotlin.services.sfn.model.InspectionDataRequest] inside the given [block]
         */
        public fun request(block: aws.sdk.kotlin.services.sfn.model.InspectionDataRequest.Builder.() -> kotlin.Unit) {
            this.request = aws.sdk.kotlin.services.sfn.model.InspectionDataRequest.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sfn.model.InspectionDataResponse] inside the given [block]
         */
        public fun response(block: aws.sdk.kotlin.services.sfn.model.InspectionDataResponse.Builder.() -> kotlin.Unit) {
            this.response = aws.sdk.kotlin.services.sfn.model.InspectionDataResponse.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
