// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sfn.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains details about the events of an execution.
 */
public class HistoryEvent private constructor(builder: Builder) {
    /**
     * Contains details about an activity that failed during an execution.
     */
    public val activityFailedEventDetails: aws.sdk.kotlin.services.sfn.model.ActivityFailedEventDetails? = builder.activityFailedEventDetails
    /**
     * Contains details about an activity schedule event that failed during an execution.
     */
    public val activityScheduleFailedEventDetails: aws.sdk.kotlin.services.sfn.model.ActivityScheduleFailedEventDetails? = builder.activityScheduleFailedEventDetails
    /**
     * Contains details about an activity scheduled during an execution.
     */
    public val activityScheduledEventDetails: aws.sdk.kotlin.services.sfn.model.ActivityScheduledEventDetails? = builder.activityScheduledEventDetails
    /**
     * Contains details about the start of an activity during an execution.
     */
    public val activityStartedEventDetails: aws.sdk.kotlin.services.sfn.model.ActivityStartedEventDetails? = builder.activityStartedEventDetails
    /**
     * Contains details about an activity that successfully terminated during an execution.
     */
    public val activitySucceededEventDetails: aws.sdk.kotlin.services.sfn.model.ActivitySucceededEventDetails? = builder.activitySucceededEventDetails
    /**
     * Contains details about an activity timeout that occurred during an execution.
     */
    public val activityTimedOutEventDetails: aws.sdk.kotlin.services.sfn.model.ActivityTimedOutEventDetails? = builder.activityTimedOutEventDetails
    /**
     * Contains details about an abort of an execution.
     */
    public val executionAbortedEventDetails: aws.sdk.kotlin.services.sfn.model.ExecutionAbortedEventDetails? = builder.executionAbortedEventDetails
    /**
     * Contains details about an execution failure event.
     */
    public val executionFailedEventDetails: aws.sdk.kotlin.services.sfn.model.ExecutionFailedEventDetails? = builder.executionFailedEventDetails
    /**
     * Contains details about the redrive attempt of an execution.
     */
    public val executionRedrivenEventDetails: aws.sdk.kotlin.services.sfn.model.ExecutionRedrivenEventDetails? = builder.executionRedrivenEventDetails
    /**
     * Contains details about the start of the execution.
     */
    public val executionStartedEventDetails: aws.sdk.kotlin.services.sfn.model.ExecutionStartedEventDetails? = builder.executionStartedEventDetails
    /**
     * Contains details about the successful termination of the execution.
     */
    public val executionSucceededEventDetails: aws.sdk.kotlin.services.sfn.model.ExecutionSucceededEventDetails? = builder.executionSucceededEventDetails
    /**
     * Contains details about the execution timeout that occurred during the execution.
     */
    public val executionTimedOutEventDetails: aws.sdk.kotlin.services.sfn.model.ExecutionTimedOutEventDetails? = builder.executionTimedOutEventDetails
    /**
     * The id of the event. Events are numbered sequentially, starting at one.
     */
    public val id: kotlin.Long = builder.id
    /**
     * Contains details about a Lambda function that failed during an execution.
     */
    public val lambdaFunctionFailedEventDetails: aws.sdk.kotlin.services.sfn.model.LambdaFunctionFailedEventDetails? = builder.lambdaFunctionFailedEventDetails
    /**
     * Contains details about a failed Lambda function schedule event that occurred during an execution.
     */
    public val lambdaFunctionScheduleFailedEventDetails: aws.sdk.kotlin.services.sfn.model.LambdaFunctionScheduleFailedEventDetails? = builder.lambdaFunctionScheduleFailedEventDetails
    /**
     * Contains details about a Lambda function scheduled during an execution.
     */
    public val lambdaFunctionScheduledEventDetails: aws.sdk.kotlin.services.sfn.model.LambdaFunctionScheduledEventDetails? = builder.lambdaFunctionScheduledEventDetails
    /**
     * Contains details about a lambda function that failed to start during an execution.
     */
    public val lambdaFunctionStartFailedEventDetails: aws.sdk.kotlin.services.sfn.model.LambdaFunctionStartFailedEventDetails? = builder.lambdaFunctionStartFailedEventDetails
    /**
     * Contains details about a Lambda function that terminated successfully during an execution.
     */
    public val lambdaFunctionSucceededEventDetails: aws.sdk.kotlin.services.sfn.model.LambdaFunctionSucceededEventDetails? = builder.lambdaFunctionSucceededEventDetails
    /**
     * Contains details about a Lambda function timeout that occurred during an execution.
     */
    public val lambdaFunctionTimedOutEventDetails: aws.sdk.kotlin.services.sfn.model.LambdaFunctionTimedOutEventDetails? = builder.lambdaFunctionTimedOutEventDetails
    /**
     * Contains details about an iteration of a Map state that was aborted.
     */
    public val mapIterationAbortedEventDetails: aws.sdk.kotlin.services.sfn.model.MapIterationEventDetails? = builder.mapIterationAbortedEventDetails
    /**
     * Contains details about an iteration of a Map state that failed.
     */
    public val mapIterationFailedEventDetails: aws.sdk.kotlin.services.sfn.model.MapIterationEventDetails? = builder.mapIterationFailedEventDetails
    /**
     * Contains details about an iteration of a Map state that was started.
     */
    public val mapIterationStartedEventDetails: aws.sdk.kotlin.services.sfn.model.MapIterationEventDetails? = builder.mapIterationStartedEventDetails
    /**
     * Contains details about an iteration of a Map state that succeeded.
     */
    public val mapIterationSucceededEventDetails: aws.sdk.kotlin.services.sfn.model.MapIterationEventDetails? = builder.mapIterationSucceededEventDetails
    /**
     * Contains error and cause details about a Map Run that failed.
     */
    public val mapRunFailedEventDetails: aws.sdk.kotlin.services.sfn.model.MapRunFailedEventDetails? = builder.mapRunFailedEventDetails
    /**
     * Contains details about the redrive attempt of a Map Run.
     */
    public val mapRunRedrivenEventDetails: aws.sdk.kotlin.services.sfn.model.MapRunRedrivenEventDetails? = builder.mapRunRedrivenEventDetails
    /**
     * Contains details, such as `mapRunArn`, and the start date and time of a Map Run. `mapRunArn` is the Amazon Resource Name (ARN) of the Map Run that was started.
     */
    public val mapRunStartedEventDetails: aws.sdk.kotlin.services.sfn.model.MapRunStartedEventDetails? = builder.mapRunStartedEventDetails
    /**
     * Contains details about Map state that was started.
     */
    public val mapStateStartedEventDetails: aws.sdk.kotlin.services.sfn.model.MapStateStartedEventDetails? = builder.mapStateStartedEventDetails
    /**
     * The id of the previous event.
     */
    public val previousEventId: kotlin.Long = builder.previousEventId
    /**
     * Contains details about a state entered during an execution.
     */
    public val stateEnteredEventDetails: aws.sdk.kotlin.services.sfn.model.StateEnteredEventDetails? = builder.stateEnteredEventDetails
    /**
     * Contains details about an exit from a state during an execution.
     */
    public val stateExitedEventDetails: aws.sdk.kotlin.services.sfn.model.StateExitedEventDetails? = builder.stateExitedEventDetails
    /**
     * Contains details about the failure of a task.
     */
    public val taskFailedEventDetails: aws.sdk.kotlin.services.sfn.model.TaskFailedEventDetails? = builder.taskFailedEventDetails
    /**
     * Contains details about a task that was scheduled.
     */
    public val taskScheduledEventDetails: aws.sdk.kotlin.services.sfn.model.TaskScheduledEventDetails? = builder.taskScheduledEventDetails
    /**
     * Contains details about a task that failed to start.
     */
    public val taskStartFailedEventDetails: aws.sdk.kotlin.services.sfn.model.TaskStartFailedEventDetails? = builder.taskStartFailedEventDetails
    /**
     * Contains details about a task that was started.
     */
    public val taskStartedEventDetails: aws.sdk.kotlin.services.sfn.model.TaskStartedEventDetails? = builder.taskStartedEventDetails
    /**
     * Contains details about a task that where the submit failed.
     */
    public val taskSubmitFailedEventDetails: aws.sdk.kotlin.services.sfn.model.TaskSubmitFailedEventDetails? = builder.taskSubmitFailedEventDetails
    /**
     * Contains details about a submitted task.
     */
    public val taskSubmittedEventDetails: aws.sdk.kotlin.services.sfn.model.TaskSubmittedEventDetails? = builder.taskSubmittedEventDetails
    /**
     * Contains details about a task that succeeded.
     */
    public val taskSucceededEventDetails: aws.sdk.kotlin.services.sfn.model.TaskSucceededEventDetails? = builder.taskSucceededEventDetails
    /**
     * Contains details about a task that timed out.
     */
    public val taskTimedOutEventDetails: aws.sdk.kotlin.services.sfn.model.TaskTimedOutEventDetails? = builder.taskTimedOutEventDetails
    /**
     * The date and time the event occurred.
     */
    public val timestamp: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.timestamp) { "A non-null value must be provided for timestamp" }
    /**
     * The type of the event.
     */
    public val type: aws.sdk.kotlin.services.sfn.model.HistoryEventType = requireNotNull(builder.type) { "A non-null value must be provided for type" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sfn.model.HistoryEvent = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HistoryEvent(")
        append("activityFailedEventDetails=$activityFailedEventDetails,")
        append("activityScheduleFailedEventDetails=$activityScheduleFailedEventDetails,")
        append("activityScheduledEventDetails=$activityScheduledEventDetails,")
        append("activityStartedEventDetails=$activityStartedEventDetails,")
        append("activitySucceededEventDetails=$activitySucceededEventDetails,")
        append("activityTimedOutEventDetails=$activityTimedOutEventDetails,")
        append("executionAbortedEventDetails=$executionAbortedEventDetails,")
        append("executionFailedEventDetails=$executionFailedEventDetails,")
        append("executionRedrivenEventDetails=$executionRedrivenEventDetails,")
        append("executionStartedEventDetails=$executionStartedEventDetails,")
        append("executionSucceededEventDetails=$executionSucceededEventDetails,")
        append("executionTimedOutEventDetails=$executionTimedOutEventDetails,")
        append("id=$id,")
        append("lambdaFunctionFailedEventDetails=$lambdaFunctionFailedEventDetails,")
        append("lambdaFunctionScheduleFailedEventDetails=$lambdaFunctionScheduleFailedEventDetails,")
        append("lambdaFunctionScheduledEventDetails=$lambdaFunctionScheduledEventDetails,")
        append("lambdaFunctionStartFailedEventDetails=$lambdaFunctionStartFailedEventDetails,")
        append("lambdaFunctionSucceededEventDetails=$lambdaFunctionSucceededEventDetails,")
        append("lambdaFunctionTimedOutEventDetails=$lambdaFunctionTimedOutEventDetails,")
        append("mapIterationAbortedEventDetails=$mapIterationAbortedEventDetails,")
        append("mapIterationFailedEventDetails=$mapIterationFailedEventDetails,")
        append("mapIterationStartedEventDetails=$mapIterationStartedEventDetails,")
        append("mapIterationSucceededEventDetails=$mapIterationSucceededEventDetails,")
        append("mapRunFailedEventDetails=$mapRunFailedEventDetails,")
        append("mapRunRedrivenEventDetails=$mapRunRedrivenEventDetails,")
        append("mapRunStartedEventDetails=$mapRunStartedEventDetails,")
        append("mapStateStartedEventDetails=$mapStateStartedEventDetails,")
        append("previousEventId=$previousEventId,")
        append("stateEnteredEventDetails=$stateEnteredEventDetails,")
        append("stateExitedEventDetails=$stateExitedEventDetails,")
        append("taskFailedEventDetails=$taskFailedEventDetails,")
        append("taskScheduledEventDetails=$taskScheduledEventDetails,")
        append("taskStartFailedEventDetails=$taskStartFailedEventDetails,")
        append("taskStartedEventDetails=$taskStartedEventDetails,")
        append("taskSubmitFailedEventDetails=$taskSubmitFailedEventDetails,")
        append("taskSubmittedEventDetails=$taskSubmittedEventDetails,")
        append("taskSucceededEventDetails=$taskSucceededEventDetails,")
        append("taskTimedOutEventDetails=$taskTimedOutEventDetails,")
        append("timestamp=$timestamp,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = activityFailedEventDetails?.hashCode() ?: 0
        result = 31 * result + (activityScheduleFailedEventDetails?.hashCode() ?: 0)
        result = 31 * result + (activityScheduledEventDetails?.hashCode() ?: 0)
        result = 31 * result + (activityStartedEventDetails?.hashCode() ?: 0)
        result = 31 * result + (activitySucceededEventDetails?.hashCode() ?: 0)
        result = 31 * result + (activityTimedOutEventDetails?.hashCode() ?: 0)
        result = 31 * result + (executionAbortedEventDetails?.hashCode() ?: 0)
        result = 31 * result + (executionFailedEventDetails?.hashCode() ?: 0)
        result = 31 * result + (executionRedrivenEventDetails?.hashCode() ?: 0)
        result = 31 * result + (executionStartedEventDetails?.hashCode() ?: 0)
        result = 31 * result + (executionSucceededEventDetails?.hashCode() ?: 0)
        result = 31 * result + (executionTimedOutEventDetails?.hashCode() ?: 0)
        result = 31 * result + (id.hashCode())
        result = 31 * result + (lambdaFunctionFailedEventDetails?.hashCode() ?: 0)
        result = 31 * result + (lambdaFunctionScheduleFailedEventDetails?.hashCode() ?: 0)
        result = 31 * result + (lambdaFunctionScheduledEventDetails?.hashCode() ?: 0)
        result = 31 * result + (lambdaFunctionStartFailedEventDetails?.hashCode() ?: 0)
        result = 31 * result + (lambdaFunctionSucceededEventDetails?.hashCode() ?: 0)
        result = 31 * result + (lambdaFunctionTimedOutEventDetails?.hashCode() ?: 0)
        result = 31 * result + (mapIterationAbortedEventDetails?.hashCode() ?: 0)
        result = 31 * result + (mapIterationFailedEventDetails?.hashCode() ?: 0)
        result = 31 * result + (mapIterationStartedEventDetails?.hashCode() ?: 0)
        result = 31 * result + (mapIterationSucceededEventDetails?.hashCode() ?: 0)
        result = 31 * result + (mapRunFailedEventDetails?.hashCode() ?: 0)
        result = 31 * result + (mapRunRedrivenEventDetails?.hashCode() ?: 0)
        result = 31 * result + (mapRunStartedEventDetails?.hashCode() ?: 0)
        result = 31 * result + (mapStateStartedEventDetails?.hashCode() ?: 0)
        result = 31 * result + (previousEventId.hashCode())
        result = 31 * result + (stateEnteredEventDetails?.hashCode() ?: 0)
        result = 31 * result + (stateExitedEventDetails?.hashCode() ?: 0)
        result = 31 * result + (taskFailedEventDetails?.hashCode() ?: 0)
        result = 31 * result + (taskScheduledEventDetails?.hashCode() ?: 0)
        result = 31 * result + (taskStartFailedEventDetails?.hashCode() ?: 0)
        result = 31 * result + (taskStartedEventDetails?.hashCode() ?: 0)
        result = 31 * result + (taskSubmitFailedEventDetails?.hashCode() ?: 0)
        result = 31 * result + (taskSubmittedEventDetails?.hashCode() ?: 0)
        result = 31 * result + (taskSucceededEventDetails?.hashCode() ?: 0)
        result = 31 * result + (taskTimedOutEventDetails?.hashCode() ?: 0)
        result = 31 * result + (timestamp.hashCode())
        result = 31 * result + (type.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HistoryEvent

        if (activityFailedEventDetails != other.activityFailedEventDetails) return false
        if (activityScheduleFailedEventDetails != other.activityScheduleFailedEventDetails) return false
        if (activityScheduledEventDetails != other.activityScheduledEventDetails) return false
        if (activityStartedEventDetails != other.activityStartedEventDetails) return false
        if (activitySucceededEventDetails != other.activitySucceededEventDetails) return false
        if (activityTimedOutEventDetails != other.activityTimedOutEventDetails) return false
        if (executionAbortedEventDetails != other.executionAbortedEventDetails) return false
        if (executionFailedEventDetails != other.executionFailedEventDetails) return false
        if (executionRedrivenEventDetails != other.executionRedrivenEventDetails) return false
        if (executionStartedEventDetails != other.executionStartedEventDetails) return false
        if (executionSucceededEventDetails != other.executionSucceededEventDetails) return false
        if (executionTimedOutEventDetails != other.executionTimedOutEventDetails) return false
        if (id != other.id) return false
        if (lambdaFunctionFailedEventDetails != other.lambdaFunctionFailedEventDetails) return false
        if (lambdaFunctionScheduleFailedEventDetails != other.lambdaFunctionScheduleFailedEventDetails) return false
        if (lambdaFunctionScheduledEventDetails != other.lambdaFunctionScheduledEventDetails) return false
        if (lambdaFunctionStartFailedEventDetails != other.lambdaFunctionStartFailedEventDetails) return false
        if (lambdaFunctionSucceededEventDetails != other.lambdaFunctionSucceededEventDetails) return false
        if (lambdaFunctionTimedOutEventDetails != other.lambdaFunctionTimedOutEventDetails) return false
        if (mapIterationAbortedEventDetails != other.mapIterationAbortedEventDetails) return false
        if (mapIterationFailedEventDetails != other.mapIterationFailedEventDetails) return false
        if (mapIterationStartedEventDetails != other.mapIterationStartedEventDetails) return false
        if (mapIterationSucceededEventDetails != other.mapIterationSucceededEventDetails) return false
        if (mapRunFailedEventDetails != other.mapRunFailedEventDetails) return false
        if (mapRunRedrivenEventDetails != other.mapRunRedrivenEventDetails) return false
        if (mapRunStartedEventDetails != other.mapRunStartedEventDetails) return false
        if (mapStateStartedEventDetails != other.mapStateStartedEventDetails) return false
        if (previousEventId != other.previousEventId) return false
        if (stateEnteredEventDetails != other.stateEnteredEventDetails) return false
        if (stateExitedEventDetails != other.stateExitedEventDetails) return false
        if (taskFailedEventDetails != other.taskFailedEventDetails) return false
        if (taskScheduledEventDetails != other.taskScheduledEventDetails) return false
        if (taskStartFailedEventDetails != other.taskStartFailedEventDetails) return false
        if (taskStartedEventDetails != other.taskStartedEventDetails) return false
        if (taskSubmitFailedEventDetails != other.taskSubmitFailedEventDetails) return false
        if (taskSubmittedEventDetails != other.taskSubmittedEventDetails) return false
        if (taskSucceededEventDetails != other.taskSucceededEventDetails) return false
        if (taskTimedOutEventDetails != other.taskTimedOutEventDetails) return false
        if (timestamp != other.timestamp) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sfn.model.HistoryEvent = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Contains details about an activity that failed during an execution.
         */
        public var activityFailedEventDetails: aws.sdk.kotlin.services.sfn.model.ActivityFailedEventDetails? = null
        /**
         * Contains details about an activity schedule event that failed during an execution.
         */
        public var activityScheduleFailedEventDetails: aws.sdk.kotlin.services.sfn.model.ActivityScheduleFailedEventDetails? = null
        /**
         * Contains details about an activity scheduled during an execution.
         */
        public var activityScheduledEventDetails: aws.sdk.kotlin.services.sfn.model.ActivityScheduledEventDetails? = null
        /**
         * Contains details about the start of an activity during an execution.
         */
        public var activityStartedEventDetails: aws.sdk.kotlin.services.sfn.model.ActivityStartedEventDetails? = null
        /**
         * Contains details about an activity that successfully terminated during an execution.
         */
        public var activitySucceededEventDetails: aws.sdk.kotlin.services.sfn.model.ActivitySucceededEventDetails? = null
        /**
         * Contains details about an activity timeout that occurred during an execution.
         */
        public var activityTimedOutEventDetails: aws.sdk.kotlin.services.sfn.model.ActivityTimedOutEventDetails? = null
        /**
         * Contains details about an abort of an execution.
         */
        public var executionAbortedEventDetails: aws.sdk.kotlin.services.sfn.model.ExecutionAbortedEventDetails? = null
        /**
         * Contains details about an execution failure event.
         */
        public var executionFailedEventDetails: aws.sdk.kotlin.services.sfn.model.ExecutionFailedEventDetails? = null
        /**
         * Contains details about the redrive attempt of an execution.
         */
        public var executionRedrivenEventDetails: aws.sdk.kotlin.services.sfn.model.ExecutionRedrivenEventDetails? = null
        /**
         * Contains details about the start of the execution.
         */
        public var executionStartedEventDetails: aws.sdk.kotlin.services.sfn.model.ExecutionStartedEventDetails? = null
        /**
         * Contains details about the successful termination of the execution.
         */
        public var executionSucceededEventDetails: aws.sdk.kotlin.services.sfn.model.ExecutionSucceededEventDetails? = null
        /**
         * Contains details about the execution timeout that occurred during the execution.
         */
        public var executionTimedOutEventDetails: aws.sdk.kotlin.services.sfn.model.ExecutionTimedOutEventDetails? = null
        /**
         * The id of the event. Events are numbered sequentially, starting at one.
         */
        public var id: kotlin.Long = 0L
        /**
         * Contains details about a Lambda function that failed during an execution.
         */
        public var lambdaFunctionFailedEventDetails: aws.sdk.kotlin.services.sfn.model.LambdaFunctionFailedEventDetails? = null
        /**
         * Contains details about a failed Lambda function schedule event that occurred during an execution.
         */
        public var lambdaFunctionScheduleFailedEventDetails: aws.sdk.kotlin.services.sfn.model.LambdaFunctionScheduleFailedEventDetails? = null
        /**
         * Contains details about a Lambda function scheduled during an execution.
         */
        public var lambdaFunctionScheduledEventDetails: aws.sdk.kotlin.services.sfn.model.LambdaFunctionScheduledEventDetails? = null
        /**
         * Contains details about a lambda function that failed to start during an execution.
         */
        public var lambdaFunctionStartFailedEventDetails: aws.sdk.kotlin.services.sfn.model.LambdaFunctionStartFailedEventDetails? = null
        /**
         * Contains details about a Lambda function that terminated successfully during an execution.
         */
        public var lambdaFunctionSucceededEventDetails: aws.sdk.kotlin.services.sfn.model.LambdaFunctionSucceededEventDetails? = null
        /**
         * Contains details about a Lambda function timeout that occurred during an execution.
         */
        public var lambdaFunctionTimedOutEventDetails: aws.sdk.kotlin.services.sfn.model.LambdaFunctionTimedOutEventDetails? = null
        /**
         * Contains details about an iteration of a Map state that was aborted.
         */
        public var mapIterationAbortedEventDetails: aws.sdk.kotlin.services.sfn.model.MapIterationEventDetails? = null
        /**
         * Contains details about an iteration of a Map state that failed.
         */
        public var mapIterationFailedEventDetails: aws.sdk.kotlin.services.sfn.model.MapIterationEventDetails? = null
        /**
         * Contains details about an iteration of a Map state that was started.
         */
        public var mapIterationStartedEventDetails: aws.sdk.kotlin.services.sfn.model.MapIterationEventDetails? = null
        /**
         * Contains details about an iteration of a Map state that succeeded.
         */
        public var mapIterationSucceededEventDetails: aws.sdk.kotlin.services.sfn.model.MapIterationEventDetails? = null
        /**
         * Contains error and cause details about a Map Run that failed.
         */
        public var mapRunFailedEventDetails: aws.sdk.kotlin.services.sfn.model.MapRunFailedEventDetails? = null
        /**
         * Contains details about the redrive attempt of a Map Run.
         */
        public var mapRunRedrivenEventDetails: aws.sdk.kotlin.services.sfn.model.MapRunRedrivenEventDetails? = null
        /**
         * Contains details, such as `mapRunArn`, and the start date and time of a Map Run. `mapRunArn` is the Amazon Resource Name (ARN) of the Map Run that was started.
         */
        public var mapRunStartedEventDetails: aws.sdk.kotlin.services.sfn.model.MapRunStartedEventDetails? = null
        /**
         * Contains details about Map state that was started.
         */
        public var mapStateStartedEventDetails: aws.sdk.kotlin.services.sfn.model.MapStateStartedEventDetails? = null
        /**
         * The id of the previous event.
         */
        public var previousEventId: kotlin.Long = 0L
        /**
         * Contains details about a state entered during an execution.
         */
        public var stateEnteredEventDetails: aws.sdk.kotlin.services.sfn.model.StateEnteredEventDetails? = null
        /**
         * Contains details about an exit from a state during an execution.
         */
        public var stateExitedEventDetails: aws.sdk.kotlin.services.sfn.model.StateExitedEventDetails? = null
        /**
         * Contains details about the failure of a task.
         */
        public var taskFailedEventDetails: aws.sdk.kotlin.services.sfn.model.TaskFailedEventDetails? = null
        /**
         * Contains details about a task that was scheduled.
         */
        public var taskScheduledEventDetails: aws.sdk.kotlin.services.sfn.model.TaskScheduledEventDetails? = null
        /**
         * Contains details about a task that failed to start.
         */
        public var taskStartFailedEventDetails: aws.sdk.kotlin.services.sfn.model.TaskStartFailedEventDetails? = null
        /**
         * Contains details about a task that was started.
         */
        public var taskStartedEventDetails: aws.sdk.kotlin.services.sfn.model.TaskStartedEventDetails? = null
        /**
         * Contains details about a task that where the submit failed.
         */
        public var taskSubmitFailedEventDetails: aws.sdk.kotlin.services.sfn.model.TaskSubmitFailedEventDetails? = null
        /**
         * Contains details about a submitted task.
         */
        public var taskSubmittedEventDetails: aws.sdk.kotlin.services.sfn.model.TaskSubmittedEventDetails? = null
        /**
         * Contains details about a task that succeeded.
         */
        public var taskSucceededEventDetails: aws.sdk.kotlin.services.sfn.model.TaskSucceededEventDetails? = null
        /**
         * Contains details about a task that timed out.
         */
        public var taskTimedOutEventDetails: aws.sdk.kotlin.services.sfn.model.TaskTimedOutEventDetails? = null
        /**
         * The date and time the event occurred.
         */
        public var timestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The type of the event.
         */
        public var type: aws.sdk.kotlin.services.sfn.model.HistoryEventType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sfn.model.HistoryEvent) : this() {
            this.activityFailedEventDetails = x.activityFailedEventDetails
            this.activityScheduleFailedEventDetails = x.activityScheduleFailedEventDetails
            this.activityScheduledEventDetails = x.activityScheduledEventDetails
            this.activityStartedEventDetails = x.activityStartedEventDetails
            this.activitySucceededEventDetails = x.activitySucceededEventDetails
            this.activityTimedOutEventDetails = x.activityTimedOutEventDetails
            this.executionAbortedEventDetails = x.executionAbortedEventDetails
            this.executionFailedEventDetails = x.executionFailedEventDetails
            this.executionRedrivenEventDetails = x.executionRedrivenEventDetails
            this.executionStartedEventDetails = x.executionStartedEventDetails
            this.executionSucceededEventDetails = x.executionSucceededEventDetails
            this.executionTimedOutEventDetails = x.executionTimedOutEventDetails
            this.id = x.id
            this.lambdaFunctionFailedEventDetails = x.lambdaFunctionFailedEventDetails
            this.lambdaFunctionScheduleFailedEventDetails = x.lambdaFunctionScheduleFailedEventDetails
            this.lambdaFunctionScheduledEventDetails = x.lambdaFunctionScheduledEventDetails
            this.lambdaFunctionStartFailedEventDetails = x.lambdaFunctionStartFailedEventDetails
            this.lambdaFunctionSucceededEventDetails = x.lambdaFunctionSucceededEventDetails
            this.lambdaFunctionTimedOutEventDetails = x.lambdaFunctionTimedOutEventDetails
            this.mapIterationAbortedEventDetails = x.mapIterationAbortedEventDetails
            this.mapIterationFailedEventDetails = x.mapIterationFailedEventDetails
            this.mapIterationStartedEventDetails = x.mapIterationStartedEventDetails
            this.mapIterationSucceededEventDetails = x.mapIterationSucceededEventDetails
            this.mapRunFailedEventDetails = x.mapRunFailedEventDetails
            this.mapRunRedrivenEventDetails = x.mapRunRedrivenEventDetails
            this.mapRunStartedEventDetails = x.mapRunStartedEventDetails
            this.mapStateStartedEventDetails = x.mapStateStartedEventDetails
            this.previousEventId = x.previousEventId
            this.stateEnteredEventDetails = x.stateEnteredEventDetails
            this.stateExitedEventDetails = x.stateExitedEventDetails
            this.taskFailedEventDetails = x.taskFailedEventDetails
            this.taskScheduledEventDetails = x.taskScheduledEventDetails
            this.taskStartFailedEventDetails = x.taskStartFailedEventDetails
            this.taskStartedEventDetails = x.taskStartedEventDetails
            this.taskSubmitFailedEventDetails = x.taskSubmitFailedEventDetails
            this.taskSubmittedEventDetails = x.taskSubmittedEventDetails
            this.taskSucceededEventDetails = x.taskSucceededEventDetails
            this.taskTimedOutEventDetails = x.taskTimedOutEventDetails
            this.timestamp = x.timestamp
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sfn.model.HistoryEvent = HistoryEvent(this)

        /**
         * construct an [aws.sdk.kotlin.services.sfn.model.ActivityFailedEventDetails] inside the given [block]
         */
        public fun activityFailedEventDetails(block: aws.sdk.kotlin.services.sfn.model.ActivityFailedEventDetails.Builder.() -> kotlin.Unit) {
            this.activityFailedEventDetails = aws.sdk.kotlin.services.sfn.model.ActivityFailedEventDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sfn.model.ActivityScheduleFailedEventDetails] inside the given [block]
         */
        public fun activityScheduleFailedEventDetails(block: aws.sdk.kotlin.services.sfn.model.ActivityScheduleFailedEventDetails.Builder.() -> kotlin.Unit) {
            this.activityScheduleFailedEventDetails = aws.sdk.kotlin.services.sfn.model.ActivityScheduleFailedEventDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sfn.model.ActivityScheduledEventDetails] inside the given [block]
         */
        public fun activityScheduledEventDetails(block: aws.sdk.kotlin.services.sfn.model.ActivityScheduledEventDetails.Builder.() -> kotlin.Unit) {
            this.activityScheduledEventDetails = aws.sdk.kotlin.services.sfn.model.ActivityScheduledEventDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sfn.model.ActivityStartedEventDetails] inside the given [block]
         */
        public fun activityStartedEventDetails(block: aws.sdk.kotlin.services.sfn.model.ActivityStartedEventDetails.Builder.() -> kotlin.Unit) {
            this.activityStartedEventDetails = aws.sdk.kotlin.services.sfn.model.ActivityStartedEventDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sfn.model.ActivitySucceededEventDetails] inside the given [block]
         */
        public fun activitySucceededEventDetails(block: aws.sdk.kotlin.services.sfn.model.ActivitySucceededEventDetails.Builder.() -> kotlin.Unit) {
            this.activitySucceededEventDetails = aws.sdk.kotlin.services.sfn.model.ActivitySucceededEventDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sfn.model.ActivityTimedOutEventDetails] inside the given [block]
         */
        public fun activityTimedOutEventDetails(block: aws.sdk.kotlin.services.sfn.model.ActivityTimedOutEventDetails.Builder.() -> kotlin.Unit) {
            this.activityTimedOutEventDetails = aws.sdk.kotlin.services.sfn.model.ActivityTimedOutEventDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sfn.model.ExecutionAbortedEventDetails] inside the given [block]
         */
        public fun executionAbortedEventDetails(block: aws.sdk.kotlin.services.sfn.model.ExecutionAbortedEventDetails.Builder.() -> kotlin.Unit) {
            this.executionAbortedEventDetails = aws.sdk.kotlin.services.sfn.model.ExecutionAbortedEventDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sfn.model.ExecutionFailedEventDetails] inside the given [block]
         */
        public fun executionFailedEventDetails(block: aws.sdk.kotlin.services.sfn.model.ExecutionFailedEventDetails.Builder.() -> kotlin.Unit) {
            this.executionFailedEventDetails = aws.sdk.kotlin.services.sfn.model.ExecutionFailedEventDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sfn.model.ExecutionRedrivenEventDetails] inside the given [block]
         */
        public fun executionRedrivenEventDetails(block: aws.sdk.kotlin.services.sfn.model.ExecutionRedrivenEventDetails.Builder.() -> kotlin.Unit) {
            this.executionRedrivenEventDetails = aws.sdk.kotlin.services.sfn.model.ExecutionRedrivenEventDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sfn.model.ExecutionStartedEventDetails] inside the given [block]
         */
        public fun executionStartedEventDetails(block: aws.sdk.kotlin.services.sfn.model.ExecutionStartedEventDetails.Builder.() -> kotlin.Unit) {
            this.executionStartedEventDetails = aws.sdk.kotlin.services.sfn.model.ExecutionStartedEventDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sfn.model.ExecutionSucceededEventDetails] inside the given [block]
         */
        public fun executionSucceededEventDetails(block: aws.sdk.kotlin.services.sfn.model.ExecutionSucceededEventDetails.Builder.() -> kotlin.Unit) {
            this.executionSucceededEventDetails = aws.sdk.kotlin.services.sfn.model.ExecutionSucceededEventDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sfn.model.ExecutionTimedOutEventDetails] inside the given [block]
         */
        public fun executionTimedOutEventDetails(block: aws.sdk.kotlin.services.sfn.model.ExecutionTimedOutEventDetails.Builder.() -> kotlin.Unit) {
            this.executionTimedOutEventDetails = aws.sdk.kotlin.services.sfn.model.ExecutionTimedOutEventDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sfn.model.LambdaFunctionFailedEventDetails] inside the given [block]
         */
        public fun lambdaFunctionFailedEventDetails(block: aws.sdk.kotlin.services.sfn.model.LambdaFunctionFailedEventDetails.Builder.() -> kotlin.Unit) {
            this.lambdaFunctionFailedEventDetails = aws.sdk.kotlin.services.sfn.model.LambdaFunctionFailedEventDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sfn.model.LambdaFunctionScheduleFailedEventDetails] inside the given [block]
         */
        public fun lambdaFunctionScheduleFailedEventDetails(block: aws.sdk.kotlin.services.sfn.model.LambdaFunctionScheduleFailedEventDetails.Builder.() -> kotlin.Unit) {
            this.lambdaFunctionScheduleFailedEventDetails = aws.sdk.kotlin.services.sfn.model.LambdaFunctionScheduleFailedEventDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sfn.model.LambdaFunctionScheduledEventDetails] inside the given [block]
         */
        public fun lambdaFunctionScheduledEventDetails(block: aws.sdk.kotlin.services.sfn.model.LambdaFunctionScheduledEventDetails.Builder.() -> kotlin.Unit) {
            this.lambdaFunctionScheduledEventDetails = aws.sdk.kotlin.services.sfn.model.LambdaFunctionScheduledEventDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sfn.model.LambdaFunctionStartFailedEventDetails] inside the given [block]
         */
        public fun lambdaFunctionStartFailedEventDetails(block: aws.sdk.kotlin.services.sfn.model.LambdaFunctionStartFailedEventDetails.Builder.() -> kotlin.Unit) {
            this.lambdaFunctionStartFailedEventDetails = aws.sdk.kotlin.services.sfn.model.LambdaFunctionStartFailedEventDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sfn.model.LambdaFunctionSucceededEventDetails] inside the given [block]
         */
        public fun lambdaFunctionSucceededEventDetails(block: aws.sdk.kotlin.services.sfn.model.LambdaFunctionSucceededEventDetails.Builder.() -> kotlin.Unit) {
            this.lambdaFunctionSucceededEventDetails = aws.sdk.kotlin.services.sfn.model.LambdaFunctionSucceededEventDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sfn.model.LambdaFunctionTimedOutEventDetails] inside the given [block]
         */
        public fun lambdaFunctionTimedOutEventDetails(block: aws.sdk.kotlin.services.sfn.model.LambdaFunctionTimedOutEventDetails.Builder.() -> kotlin.Unit) {
            this.lambdaFunctionTimedOutEventDetails = aws.sdk.kotlin.services.sfn.model.LambdaFunctionTimedOutEventDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sfn.model.MapIterationEventDetails] inside the given [block]
         */
        public fun mapIterationAbortedEventDetails(block: aws.sdk.kotlin.services.sfn.model.MapIterationEventDetails.Builder.() -> kotlin.Unit) {
            this.mapIterationAbortedEventDetails = aws.sdk.kotlin.services.sfn.model.MapIterationEventDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sfn.model.MapIterationEventDetails] inside the given [block]
         */
        public fun mapIterationFailedEventDetails(block: aws.sdk.kotlin.services.sfn.model.MapIterationEventDetails.Builder.() -> kotlin.Unit) {
            this.mapIterationFailedEventDetails = aws.sdk.kotlin.services.sfn.model.MapIterationEventDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sfn.model.MapIterationEventDetails] inside the given [block]
         */
        public fun mapIterationStartedEventDetails(block: aws.sdk.kotlin.services.sfn.model.MapIterationEventDetails.Builder.() -> kotlin.Unit) {
            this.mapIterationStartedEventDetails = aws.sdk.kotlin.services.sfn.model.MapIterationEventDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sfn.model.MapIterationEventDetails] inside the given [block]
         */
        public fun mapIterationSucceededEventDetails(block: aws.sdk.kotlin.services.sfn.model.MapIterationEventDetails.Builder.() -> kotlin.Unit) {
            this.mapIterationSucceededEventDetails = aws.sdk.kotlin.services.sfn.model.MapIterationEventDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sfn.model.MapRunFailedEventDetails] inside the given [block]
         */
        public fun mapRunFailedEventDetails(block: aws.sdk.kotlin.services.sfn.model.MapRunFailedEventDetails.Builder.() -> kotlin.Unit) {
            this.mapRunFailedEventDetails = aws.sdk.kotlin.services.sfn.model.MapRunFailedEventDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sfn.model.MapRunRedrivenEventDetails] inside the given [block]
         */
        public fun mapRunRedrivenEventDetails(block: aws.sdk.kotlin.services.sfn.model.MapRunRedrivenEventDetails.Builder.() -> kotlin.Unit) {
            this.mapRunRedrivenEventDetails = aws.sdk.kotlin.services.sfn.model.MapRunRedrivenEventDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sfn.model.MapRunStartedEventDetails] inside the given [block]
         */
        public fun mapRunStartedEventDetails(block: aws.sdk.kotlin.services.sfn.model.MapRunStartedEventDetails.Builder.() -> kotlin.Unit) {
            this.mapRunStartedEventDetails = aws.sdk.kotlin.services.sfn.model.MapRunStartedEventDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sfn.model.MapStateStartedEventDetails] inside the given [block]
         */
        public fun mapStateStartedEventDetails(block: aws.sdk.kotlin.services.sfn.model.MapStateStartedEventDetails.Builder.() -> kotlin.Unit) {
            this.mapStateStartedEventDetails = aws.sdk.kotlin.services.sfn.model.MapStateStartedEventDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sfn.model.StateEnteredEventDetails] inside the given [block]
         */
        public fun stateEnteredEventDetails(block: aws.sdk.kotlin.services.sfn.model.StateEnteredEventDetails.Builder.() -> kotlin.Unit) {
            this.stateEnteredEventDetails = aws.sdk.kotlin.services.sfn.model.StateEnteredEventDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sfn.model.StateExitedEventDetails] inside the given [block]
         */
        public fun stateExitedEventDetails(block: aws.sdk.kotlin.services.sfn.model.StateExitedEventDetails.Builder.() -> kotlin.Unit) {
            this.stateExitedEventDetails = aws.sdk.kotlin.services.sfn.model.StateExitedEventDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sfn.model.TaskFailedEventDetails] inside the given [block]
         */
        public fun taskFailedEventDetails(block: aws.sdk.kotlin.services.sfn.model.TaskFailedEventDetails.Builder.() -> kotlin.Unit) {
            this.taskFailedEventDetails = aws.sdk.kotlin.services.sfn.model.TaskFailedEventDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sfn.model.TaskScheduledEventDetails] inside the given [block]
         */
        public fun taskScheduledEventDetails(block: aws.sdk.kotlin.services.sfn.model.TaskScheduledEventDetails.Builder.() -> kotlin.Unit) {
            this.taskScheduledEventDetails = aws.sdk.kotlin.services.sfn.model.TaskScheduledEventDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sfn.model.TaskStartFailedEventDetails] inside the given [block]
         */
        public fun taskStartFailedEventDetails(block: aws.sdk.kotlin.services.sfn.model.TaskStartFailedEventDetails.Builder.() -> kotlin.Unit) {
            this.taskStartFailedEventDetails = aws.sdk.kotlin.services.sfn.model.TaskStartFailedEventDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sfn.model.TaskStartedEventDetails] inside the given [block]
         */
        public fun taskStartedEventDetails(block: aws.sdk.kotlin.services.sfn.model.TaskStartedEventDetails.Builder.() -> kotlin.Unit) {
            this.taskStartedEventDetails = aws.sdk.kotlin.services.sfn.model.TaskStartedEventDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sfn.model.TaskSubmitFailedEventDetails] inside the given [block]
         */
        public fun taskSubmitFailedEventDetails(block: aws.sdk.kotlin.services.sfn.model.TaskSubmitFailedEventDetails.Builder.() -> kotlin.Unit) {
            this.taskSubmitFailedEventDetails = aws.sdk.kotlin.services.sfn.model.TaskSubmitFailedEventDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sfn.model.TaskSubmittedEventDetails] inside the given [block]
         */
        public fun taskSubmittedEventDetails(block: aws.sdk.kotlin.services.sfn.model.TaskSubmittedEventDetails.Builder.() -> kotlin.Unit) {
            this.taskSubmittedEventDetails = aws.sdk.kotlin.services.sfn.model.TaskSubmittedEventDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sfn.model.TaskSucceededEventDetails] inside the given [block]
         */
        public fun taskSucceededEventDetails(block: aws.sdk.kotlin.services.sfn.model.TaskSucceededEventDetails.Builder.() -> kotlin.Unit) {
            this.taskSucceededEventDetails = aws.sdk.kotlin.services.sfn.model.TaskSucceededEventDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sfn.model.TaskTimedOutEventDetails] inside the given [block]
         */
        public fun taskTimedOutEventDetails(block: aws.sdk.kotlin.services.sfn.model.TaskTimedOutEventDetails.Builder.() -> kotlin.Unit) {
            this.taskTimedOutEventDetails = aws.sdk.kotlin.services.sfn.model.TaskTimedOutEventDetails.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (timestamp == null) timestamp = Instant.fromEpochSeconds(0)
            if (type == null) type = HistoryEventType.SdkUnknown("no value provided")
            return this
        }
    }
}
