// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sfn.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains details about an activity scheduled during an execution.
 */
public class ActivityScheduledEventDetails private constructor(builder: Builder) {
    /**
     * The maximum allowed duration between two heartbeats for the activity task.
     */
    public val heartbeatInSeconds: kotlin.Long? = builder.heartbeatInSeconds
    /**
     * The JSON data input to the activity task. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.
     */
    public val input: kotlin.String? = builder.input
    /**
     * Contains details about the input for an execution history event.
     */
    public val inputDetails: aws.sdk.kotlin.services.sfn.model.HistoryEventExecutionDataDetails? = builder.inputDetails
    /**
     * The Amazon Resource Name (ARN) of the scheduled activity.
     */
    public val resource: kotlin.String = requireNotNull(builder.resource) { "A non-null value must be provided for resource" }
    /**
     * The maximum allowed duration of the activity task.
     */
    public val timeoutInSeconds: kotlin.Long? = builder.timeoutInSeconds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sfn.model.ActivityScheduledEventDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ActivityScheduledEventDetails(")
        append("heartbeatInSeconds=$heartbeatInSeconds,")
        append("input=*** Sensitive Data Redacted ***,")
        append("inputDetails=$inputDetails,")
        append("resource=$resource,")
        append("timeoutInSeconds=$timeoutInSeconds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = heartbeatInSeconds?.hashCode() ?: 0
        result = 31 * result + (input?.hashCode() ?: 0)
        result = 31 * result + (inputDetails?.hashCode() ?: 0)
        result = 31 * result + (resource.hashCode())
        result = 31 * result + (timeoutInSeconds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ActivityScheduledEventDetails

        if (heartbeatInSeconds != other.heartbeatInSeconds) return false
        if (input != other.input) return false
        if (inputDetails != other.inputDetails) return false
        if (resource != other.resource) return false
        if (timeoutInSeconds != other.timeoutInSeconds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sfn.model.ActivityScheduledEventDetails = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The maximum allowed duration between two heartbeats for the activity task.
         */
        public var heartbeatInSeconds: kotlin.Long? = null
        /**
         * The JSON data input to the activity task. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.
         */
        public var input: kotlin.String? = null
        /**
         * Contains details about the input for an execution history event.
         */
        public var inputDetails: aws.sdk.kotlin.services.sfn.model.HistoryEventExecutionDataDetails? = null
        /**
         * The Amazon Resource Name (ARN) of the scheduled activity.
         */
        public var resource: kotlin.String? = null
        /**
         * The maximum allowed duration of the activity task.
         */
        public var timeoutInSeconds: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sfn.model.ActivityScheduledEventDetails) : this() {
            this.heartbeatInSeconds = x.heartbeatInSeconds
            this.input = x.input
            this.inputDetails = x.inputDetails
            this.resource = x.resource
            this.timeoutInSeconds = x.timeoutInSeconds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sfn.model.ActivityScheduledEventDetails = ActivityScheduledEventDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.sfn.model.HistoryEventExecutionDataDetails] inside the given [block]
         */
        public fun inputDetails(block: aws.sdk.kotlin.services.sfn.model.HistoryEventExecutionDataDetails.Builder.() -> kotlin.Unit) {
            this.inputDetails = aws.sdk.kotlin.services.sfn.model.HistoryEventExecutionDataDetails.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (resource == null) resource = ""
            return this
        }
    }
}
