// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sfn.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains details about an activity.
 */
public class ActivityListItem private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) that identifies the activity.
     */
    public val activityArn: kotlin.String = requireNotNull(builder.activityArn) { "A non-null value must be provided for activityArn" }
    /**
     * The date the activity is created.
     */
    public val creationDate: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.creationDate) { "A non-null value must be provided for creationDate" }
    /**
     * The name of the activity.
     *
     * A name must *not* contain:
     * + white space
     * + brackets `< > { } [ ]`
     * + wildcard characters `? *`
     * + special characters `" # % \ ^ | ~ ` $ & , ; : /`
     * + control characters (`U+0000-001F`, `U+007F-009F`)
     *
     * To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sfn.model.ActivityListItem = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ActivityListItem(")
        append("activityArn=$activityArn,")
        append("creationDate=$creationDate,")
        append("name=$name")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = activityArn.hashCode()
        result = 31 * result + (creationDate.hashCode())
        result = 31 * result + (name.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ActivityListItem

        if (activityArn != other.activityArn) return false
        if (creationDate != other.creationDate) return false
        if (name != other.name) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sfn.model.ActivityListItem = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) that identifies the activity.
         */
        public var activityArn: kotlin.String? = null
        /**
         * The date the activity is created.
         */
        public var creationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the activity.
         *
         * A name must *not* contain:
         * + white space
         * + brackets `< > { } [ ]`
         * + wildcard characters `? *`
         * + special characters `" # % \ ^ | ~ ` $ & , ; : /`
         * + control characters (`U+0000-001F`, `U+007F-009F`)
         *
         * To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.
         */
        public var name: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sfn.model.ActivityListItem) : this() {
            this.activityArn = x.activityArn
            this.creationDate = x.creationDate
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sfn.model.ActivityListItem = ActivityListItem(this)

        internal fun correctErrors(): Builder {
            if (activityArn == null) activityArn = ""
            if (creationDate == null) creationDate = Instant.fromEpochSeconds(0)
            if (name == null) name = ""
            return this
        }
    }
}
