// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sfn

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.sfn.auth.DefaultSfnAuthSchemeProvider
import aws.sdk.kotlin.services.sfn.auth.SfnAuthSchemeProvider
import aws.sdk.kotlin.services.sfn.endpoints.DefaultSfnEndpointProvider
import aws.sdk.kotlin.services.sfn.endpoints.SfnEndpointParameters
import aws.sdk.kotlin.services.sfn.endpoints.SfnEndpointProvider
import aws.sdk.kotlin.services.sfn.model.CreateActivityRequest
import aws.sdk.kotlin.services.sfn.model.CreateActivityResponse
import aws.sdk.kotlin.services.sfn.model.CreateStateMachineAliasRequest
import aws.sdk.kotlin.services.sfn.model.CreateStateMachineAliasResponse
import aws.sdk.kotlin.services.sfn.model.CreateStateMachineRequest
import aws.sdk.kotlin.services.sfn.model.CreateStateMachineResponse
import aws.sdk.kotlin.services.sfn.model.DeleteActivityRequest
import aws.sdk.kotlin.services.sfn.model.DeleteActivityResponse
import aws.sdk.kotlin.services.sfn.model.DeleteStateMachineAliasRequest
import aws.sdk.kotlin.services.sfn.model.DeleteStateMachineAliasResponse
import aws.sdk.kotlin.services.sfn.model.DeleteStateMachineRequest
import aws.sdk.kotlin.services.sfn.model.DeleteStateMachineResponse
import aws.sdk.kotlin.services.sfn.model.DeleteStateMachineVersionRequest
import aws.sdk.kotlin.services.sfn.model.DeleteStateMachineVersionResponse
import aws.sdk.kotlin.services.sfn.model.DescribeActivityRequest
import aws.sdk.kotlin.services.sfn.model.DescribeActivityResponse
import aws.sdk.kotlin.services.sfn.model.DescribeExecutionRequest
import aws.sdk.kotlin.services.sfn.model.DescribeExecutionResponse
import aws.sdk.kotlin.services.sfn.model.DescribeMapRunRequest
import aws.sdk.kotlin.services.sfn.model.DescribeMapRunResponse
import aws.sdk.kotlin.services.sfn.model.DescribeStateMachineAliasRequest
import aws.sdk.kotlin.services.sfn.model.DescribeStateMachineAliasResponse
import aws.sdk.kotlin.services.sfn.model.DescribeStateMachineForExecutionRequest
import aws.sdk.kotlin.services.sfn.model.DescribeStateMachineForExecutionResponse
import aws.sdk.kotlin.services.sfn.model.DescribeStateMachineRequest
import aws.sdk.kotlin.services.sfn.model.DescribeStateMachineResponse
import aws.sdk.kotlin.services.sfn.model.GetActivityTaskRequest
import aws.sdk.kotlin.services.sfn.model.GetActivityTaskResponse
import aws.sdk.kotlin.services.sfn.model.GetExecutionHistoryRequest
import aws.sdk.kotlin.services.sfn.model.GetExecutionHistoryResponse
import aws.sdk.kotlin.services.sfn.model.ListActivitiesRequest
import aws.sdk.kotlin.services.sfn.model.ListActivitiesResponse
import aws.sdk.kotlin.services.sfn.model.ListExecutionsRequest
import aws.sdk.kotlin.services.sfn.model.ListExecutionsResponse
import aws.sdk.kotlin.services.sfn.model.ListMapRunsRequest
import aws.sdk.kotlin.services.sfn.model.ListMapRunsResponse
import aws.sdk.kotlin.services.sfn.model.ListStateMachineAliasesRequest
import aws.sdk.kotlin.services.sfn.model.ListStateMachineAliasesResponse
import aws.sdk.kotlin.services.sfn.model.ListStateMachineVersionsRequest
import aws.sdk.kotlin.services.sfn.model.ListStateMachineVersionsResponse
import aws.sdk.kotlin.services.sfn.model.ListStateMachinesRequest
import aws.sdk.kotlin.services.sfn.model.ListStateMachinesResponse
import aws.sdk.kotlin.services.sfn.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.sfn.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.sfn.model.PublishStateMachineVersionRequest
import aws.sdk.kotlin.services.sfn.model.PublishStateMachineVersionResponse
import aws.sdk.kotlin.services.sfn.model.RedriveExecutionRequest
import aws.sdk.kotlin.services.sfn.model.RedriveExecutionResponse
import aws.sdk.kotlin.services.sfn.model.SendTaskFailureRequest
import aws.sdk.kotlin.services.sfn.model.SendTaskFailureResponse
import aws.sdk.kotlin.services.sfn.model.SendTaskHeartbeatRequest
import aws.sdk.kotlin.services.sfn.model.SendTaskHeartbeatResponse
import aws.sdk.kotlin.services.sfn.model.SendTaskSuccessRequest
import aws.sdk.kotlin.services.sfn.model.SendTaskSuccessResponse
import aws.sdk.kotlin.services.sfn.model.StartExecutionRequest
import aws.sdk.kotlin.services.sfn.model.StartExecutionResponse
import aws.sdk.kotlin.services.sfn.model.StartSyncExecutionRequest
import aws.sdk.kotlin.services.sfn.model.StartSyncExecutionResponse
import aws.sdk.kotlin.services.sfn.model.StopExecutionRequest
import aws.sdk.kotlin.services.sfn.model.StopExecutionResponse
import aws.sdk.kotlin.services.sfn.model.TagResourceRequest
import aws.sdk.kotlin.services.sfn.model.TagResourceResponse
import aws.sdk.kotlin.services.sfn.model.TestStateRequest
import aws.sdk.kotlin.services.sfn.model.TestStateResponse
import aws.sdk.kotlin.services.sfn.model.UntagResourceRequest
import aws.sdk.kotlin.services.sfn.model.UntagResourceResponse
import aws.sdk.kotlin.services.sfn.model.UpdateMapRunRequest
import aws.sdk.kotlin.services.sfn.model.UpdateMapRunResponse
import aws.sdk.kotlin.services.sfn.model.UpdateStateMachineAliasRequest
import aws.sdk.kotlin.services.sfn.model.UpdateStateMachineAliasResponse
import aws.sdk.kotlin.services.sfn.model.UpdateStateMachineRequest
import aws.sdk.kotlin.services.sfn.model.UpdateStateMachineResponse
import aws.sdk.kotlin.services.sfn.model.ValidateStateMachineDefinitionRequest
import aws.sdk.kotlin.services.sfn.model.ValidateStateMachineDefinitionResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "SFN"
public const val SdkVersion: String = "1.3.29"
public const val ServiceApiVersion: String = "2016-11-23"

/**
 * # Step Functions
 * Step Functions coordinates the components of distributed applications and microservices using visual workflows.
 *
 * You can use Step Functions to build applications from individual components, each of which performs a discrete function, or *task*, allowing you to scale and change applications quickly. Step Functions provides a console that helps visualize the components of your application as a series of steps. Step Functions automatically triggers and tracks each step, and retries steps when there are errors, so your application executes predictably and in the right order every time. Step Functions logs the state of each step, so you can quickly diagnose and debug any issues.
 *
 * Step Functions manages operations and underlying infrastructure to ensure your application is available at any scale. You can run tasks on Amazon Web Services, your own servers, or any system that has access to Amazon Web Services. You can access and use Step Functions using the console, the Amazon Web Services SDKs, or an HTTP API. For more information about Step Functions, see the *[Step Functions Developer Guide](https://docs.aws.amazon.com/step-functions/latest/dg/welcome.html)*.
 *
 * If you use the Step Functions API actions using Amazon Web Services SDK integrations, make sure the API actions are in camel case and parameter names are in Pascal case. For example, you could use Step Functions API action `startSyncExecution` and specify its parameter as `StateMachineArn`.
 */
public interface SfnClient : SdkClient {
    /**
     * SfnClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, SfnClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "Sfn",
                "SFN",
                "sfn",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, SfnClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): SfnClient = DefaultSfnClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: SfnEndpointProvider = builder.endpointProvider ?: DefaultSfnEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: SfnAuthSchemeProvider = builder.authSchemeProvider ?: DefaultSfnAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "SFN"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: SfnEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: SfnAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Creates an activity. An activity is a task that you write in any programming language and host on any machine that has access to Step Functions. Activities must poll Step Functions using the `GetActivityTask` API action and respond using `SendTask*` API actions. This function lets Step Functions know the existence of your activity and returns an identifier for use in a state machine and when polling from the activity.
     *
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.
     *
     * `CreateActivity` is an idempotent API. Subsequent requests won’t create a duplicate resource if it was already created. `CreateActivity`'s idempotency check is based on the activity `name`. If a following request has different `tags` values, Step Functions will ignore these differences and treat it as an idempotent request of the previous. In this case, `tags` will not be updated, even if they are different.
     */
    public suspend fun createActivity(input: CreateActivityRequest): CreateActivityResponse

    /**
     * Creates a state machine. A state machine consists of a collection of states that can do work (`Task` states), determine to which states to transition next (`Choice` states), stop an execution with an error (`Fail` states), and so on. State machines are specified using a JSON-based, structured language. For more information, see [Amazon States Language](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html) in the Step Functions User Guide.
     *
     * If you set the `publish` parameter of this API action to `true`, it publishes version `1` as the first revision of the state machine.
     *
     *  For additional control over security, you can encrypt your data using a **customer-managed key** for Step Functions state machines. You can configure a symmetric KMS key and data key reuse period when creating or updating a **State Machine**. The execution history and state machine definition will be encrypted with the key applied to the State Machine.
     *
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.
     *
     * `CreateStateMachine` is an idempotent API. Subsequent requests won’t create a duplicate resource if it was already created. `CreateStateMachine`'s idempotency check is based on the state machine `name`, `definition`, `type`, `LoggingConfiguration`, `TracingConfiguration`, and `EncryptionConfiguration` The check is also based on the `publish` and `versionDescription` parameters. If a following request has a different `roleArn` or `tags`, Step Functions will ignore these differences and treat it as an idempotent request of the previous. In this case, `roleArn` and `tags` will not be updated, even if they are different.
     */
    public suspend fun createStateMachine(input: CreateStateMachineRequest): CreateStateMachineResponse

    /**
     * Creates an [alias](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html) for a state machine that points to one or two [versions](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html) of the same state machine. You can set your application to call StartExecution with an alias and update the version the alias uses without changing the client's code.
     *
     * You can also map an alias to split StartExecution requests between two versions of a state machine. To do this, add a second `RoutingConfig` object in the `routingConfiguration` parameter. You must also specify the percentage of execution run requests each version should receive in both `RoutingConfig` objects. Step Functions randomly chooses which version runs a given execution based on the percentage you specify.
     *
     * To create an alias that points to a single version, specify a single `RoutingConfig` object with a `weight` set to 100.
     *
     * You can create up to 100 aliases for each state machine. You must delete unused aliases using the DeleteStateMachineAlias API action.
     *
     * `CreateStateMachineAlias` is an idempotent API. Step Functions bases the idempotency check on the `stateMachineArn`, `description`, `name`, and `routingConfiguration` parameters. Requests that contain the same values for these parameters return a successful idempotent response without creating a duplicate resource.
     *
     * **Related operations:**
     * + DescribeStateMachineAlias
     * + ListStateMachineAliases
     * + UpdateStateMachineAlias
     * + DeleteStateMachineAlias
     */
    public suspend fun createStateMachineAlias(input: CreateStateMachineAliasRequest): CreateStateMachineAliasResponse

    /**
     * Deletes an activity.
     */
    public suspend fun deleteActivity(input: DeleteActivityRequest): DeleteActivityResponse

    /**
     * Deletes a state machine. This is an asynchronous operation. It sets the state machine's status to `DELETING` and begins the deletion process. A state machine is deleted only when all its executions are completed. On the next state transition, the state machine's executions are terminated.
     *
     * A qualified state machine ARN can either refer to a *Distributed Map state* defined within a state machine, a version ARN, or an alias ARN.
     *
     * The following are some examples of qualified and unqualified state machine ARNs:
     * + The following qualified state machine ARN refers to a *Distributed Map state* with a label `mapStateLabel` in a state machine named `myStateMachine`.`arn:partition:states:region:account-id:stateMachine:myStateMachine/mapStateLabel`If you provide a qualified state machine ARN that refers to a *Distributed Map state*, the request fails with `ValidationException`.
     * + The following unqualified state machine ARN refers to a state machine named `myStateMachine`.`arn:partition:states:region:account-id:stateMachine:myStateMachine`
     *
     * This API action also deletes all [versions](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html) and [aliases](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html) associated with a state machine.
     *
     * For `EXPRESS` state machines, the deletion happens eventually (usually in less than a minute). Running executions may emit logs after `DeleteStateMachine` API is called.
     */
    public suspend fun deleteStateMachine(input: DeleteStateMachineRequest): DeleteStateMachineResponse

    /**
     * Deletes a state machine [alias](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html).
     *
     * After you delete a state machine alias, you can't use it to start executions. When you delete a state machine alias, Step Functions doesn't delete the state machine versions that alias references.
     *
     * **Related operations:**
     * + CreateStateMachineAlias
     * + DescribeStateMachineAlias
     * + ListStateMachineAliases
     * + UpdateStateMachineAlias
     */
    public suspend fun deleteStateMachineAlias(input: DeleteStateMachineAliasRequest): DeleteStateMachineAliasResponse

    /**
     * Deletes a state machine [version](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html). After you delete a version, you can't call StartExecution using that version's ARN or use the version with a state machine [alias](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html).
     *
     * Deleting a state machine version won't terminate its in-progress executions.
     *
     * You can't delete a state machine version currently referenced by one or more aliases. Before you delete a version, you must either delete the aliases or update them to point to another state machine version.
     *
     * **Related operations:**
     * + PublishStateMachineVersion
     * + ListStateMachineVersions
     */
    public suspend fun deleteStateMachineVersion(input: DeleteStateMachineVersionRequest): DeleteStateMachineVersionResponse

    /**
     * Describes an activity.
     *
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.
     */
    public suspend fun describeActivity(input: DescribeActivityRequest): DescribeActivityResponse

    /**
     * Provides information about a state machine execution, such as the state machine associated with the execution, the execution input and output, and relevant execution metadata. If you've [redriven](https://docs.aws.amazon.com/step-functions/latest/dg/redrive-executions.html) an execution, you can use this API action to return information about the redrives of that execution. In addition, you can use this API action to return the Map Run Amazon Resource Name (ARN) if the execution was dispatched by a Map Run.
     *
     * If you specify a version or alias ARN when you call the StartExecution API action, `DescribeExecution` returns that ARN.
     *
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.
     *
     * Executions of an `EXPRESS` state machine aren't supported by `DescribeExecution` unless a Map Run dispatched them.
     */
    public suspend fun describeExecution(input: DescribeExecutionRequest): DescribeExecutionResponse

    /**
     * Provides information about a Map Run's configuration, progress, and results. If you've [redriven](https://docs.aws.amazon.com/step-functions/latest/dg/redrive-map-run.html) a Map Run, this API action also returns information about the redrives of that Map Run. For more information, see [Examining Map Run](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-examine-map-run.html) in the *Step Functions Developer Guide*.
     */
    public suspend fun describeMapRun(input: DescribeMapRunRequest): DescribeMapRunResponse

    /**
     * Provides information about a state machine's definition, its IAM role Amazon Resource Name (ARN), and configuration.
     *
     * A qualified state machine ARN can either refer to a *Distributed Map state* defined within a state machine, a version ARN, or an alias ARN.
     *
     * The following are some examples of qualified and unqualified state machine ARNs:
     * + The following qualified state machine ARN refers to a *Distributed Map state* with a label `mapStateLabel` in a state machine named `myStateMachine`.`arn:partition:states:region:account-id:stateMachine:myStateMachine/mapStateLabel`If you provide a qualified state machine ARN that refers to a *Distributed Map state*, the request fails with `ValidationException`.
     * + The following qualified state machine ARN refers to an alias named `PROD`.`arn:<partition>:states:<region>:<account-id>:stateMachine:<myStateMachine:PROD>`If you provide a qualified state machine ARN that refers to a version ARN or an alias ARN, the request starts execution for that version or alias.
     * + The following unqualified state machine ARN refers to a state machine named `myStateMachine`.`arn:<partition>:states:<region>:<account-id>:stateMachine:<myStateMachine>`
     *
     * This API action returns the details for a state machine version if the `stateMachineArn` you specify is a state machine version ARN.
     *
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.
     */
    public suspend fun describeStateMachine(input: DescribeStateMachineRequest): DescribeStateMachineResponse

    /**
     * Returns details about a state machine [alias](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html).
     *
     * **Related operations:**
     * + CreateStateMachineAlias
     * + ListStateMachineAliases
     * + UpdateStateMachineAlias
     * + DeleteStateMachineAlias
     */
    public suspend fun describeStateMachineAlias(input: DescribeStateMachineAliasRequest): DescribeStateMachineAliasResponse

    /**
     * Provides information about a state machine's definition, its execution role ARN, and configuration. If a Map Run dispatched the execution, this action returns the Map Run Amazon Resource Name (ARN) in the response. The state machine returned is the state machine associated with the Map Run.
     *
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.
     *
     * This API action is not supported by `EXPRESS` state machines.
     */
    public suspend fun describeStateMachineForExecution(input: DescribeStateMachineForExecutionRequest): DescribeStateMachineForExecutionResponse

    /**
     * Used by workers to retrieve a task (with the specified activity ARN) which has been scheduled for execution by a running state machine. This initiates a long poll, where the service holds the HTTP connection open and responds as soon as a task becomes available (i.e. an execution of a task of this type is needed.) The maximum time the service holds on to the request before responding is 60 seconds. If no task is available within 60 seconds, the poll returns a `taskToken` with a null string.
     *
     * This API action isn't logged in CloudTrail.
     *
     * Workers should set their client side socket timeout to at least 65 seconds (5 seconds higher than the maximum time the service may hold the poll request).
     *
     * Polling with `GetActivityTask` can cause latency in some implementations. See [Avoid Latency When Polling for Activity Tasks](https://docs.aws.amazon.com/step-functions/latest/dg/bp-activity-pollers.html) in the Step Functions Developer Guide.
     */
    public suspend fun getActivityTask(input: GetActivityTaskRequest): GetActivityTaskResponse

    /**
     * Returns the history of the specified execution as a list of events. By default, the results are returned in ascending order of the `timeStamp` of the events. Use the `reverseOrder` parameter to get the latest events first.
     *
     * If `nextToken` is returned, there are more results available. The value of `nextToken` is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an *HTTP 400 InvalidToken* error.
     *
     * This API action is not supported by `EXPRESS` state machines.
     */
    public suspend fun getExecutionHistory(input: GetExecutionHistoryRequest): GetExecutionHistoryResponse

    /**
     * Lists the existing activities.
     *
     * If `nextToken` is returned, there are more results available. The value of `nextToken` is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an *HTTP 400 InvalidToken* error.
     *
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.
     */
    public suspend fun listActivities(input: ListActivitiesRequest = ListActivitiesRequest { }): ListActivitiesResponse

    /**
     * Lists all executions of a state machine or a Map Run. You can list all executions related to a state machine by specifying a state machine Amazon Resource Name (ARN), or those related to a Map Run by specifying a Map Run ARN. Using this API action, you can also list all [redriven](https://docs.aws.amazon.com/step-functions/latest/dg/redrive-executions.html) executions.
     *
     * You can also provide a state machine [alias](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html) ARN or [version](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html) ARN to list the executions associated with a specific alias or version.
     *
     * Results are sorted by time, with the most recent execution first.
     *
     * If `nextToken` is returned, there are more results available. The value of `nextToken` is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an *HTTP 400 InvalidToken* error.
     *
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.
     *
     * This API action is not supported by `EXPRESS` state machines.
     */
    public suspend fun listExecutions(input: ListExecutionsRequest = ListExecutionsRequest { }): ListExecutionsResponse

    /**
     * Lists all Map Runs that were started by a given state machine execution. Use this API action to obtain Map Run ARNs, and then call `DescribeMapRun` to obtain more information, if needed.
     */
    public suspend fun listMapRuns(input: ListMapRunsRequest): ListMapRunsResponse

    /**
     * Lists [aliases](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html) for a specified state machine ARN. Results are sorted by time, with the most recently created aliases listed first.
     *
     * To list aliases that reference a state machine [version](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html), you can specify the version ARN in the `stateMachineArn` parameter.
     *
     * If `nextToken` is returned, there are more results available. The value of `nextToken` is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an *HTTP 400 InvalidToken* error.
     *
     * **Related operations:**
     * + CreateStateMachineAlias
     * + DescribeStateMachineAlias
     * + UpdateStateMachineAlias
     * + DeleteStateMachineAlias
     */
    public suspend fun listStateMachineAliases(input: ListStateMachineAliasesRequest): ListStateMachineAliasesResponse

    /**
     * Lists [versions](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html) for the specified state machine Amazon Resource Name (ARN).
     *
     * The results are sorted in descending order of the version creation time.
     *
     * If `nextToken` is returned, there are more results available. The value of `nextToken` is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an *HTTP 400 InvalidToken* error.
     *
     * **Related operations:**
     * + PublishStateMachineVersion
     * + DeleteStateMachineVersion
     */
    public suspend fun listStateMachineVersions(input: ListStateMachineVersionsRequest): ListStateMachineVersionsResponse

    /**
     * Lists the existing state machines.
     *
     * If `nextToken` is returned, there are more results available. The value of `nextToken` is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an *HTTP 400 InvalidToken* error.
     *
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.
     */
    public suspend fun listStateMachines(input: ListStateMachinesRequest = ListStateMachinesRequest { }): ListStateMachinesResponse

    /**
     * List tags for a given resource.
     *
     * Tags may only contain Unicode letters, digits, white space, or these symbols: `_ . : / = + - @`.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Creates a [version](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html) from the current revision of a state machine. Use versions to create immutable snapshots of your state machine. You can start executions from versions either directly or with an alias. To create an alias, use CreateStateMachineAlias.
     *
     * You can publish up to 1000 versions for each state machine. You must manually delete unused versions using the DeleteStateMachineVersion API action.
     *
     * `PublishStateMachineVersion` is an idempotent API. It doesn't create a duplicate state machine version if it already exists for the current revision. Step Functions bases `PublishStateMachineVersion`'s idempotency check on the `stateMachineArn`, `name`, and `revisionId` parameters. Requests with the same parameters return a successful idempotent response. If you don't specify a `revisionId`, Step Functions checks for a previously published version of the state machine's current revision.
     *
     * **Related operations:**
     * + DeleteStateMachineVersion
     * + ListStateMachineVersions
     */
    public suspend fun publishStateMachineVersion(input: PublishStateMachineVersionRequest): PublishStateMachineVersionResponse

    /**
     * Restarts unsuccessful executions of Standard workflows that didn't complete successfully in the last 14 days. These include failed, aborted, or timed out executions. When you [redrive](https://docs.aws.amazon.com/step-functions/latest/dg/redrive-executions.html) an execution, it continues the failed execution from the unsuccessful step and uses the same input. Step Functions preserves the results and execution history of the successful steps, and doesn't rerun these steps when you redrive an execution. Redriven executions use the same state machine definition and execution ARN as the original execution attempt.
     *
     * For workflows that include an [Inline Map](https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-map-state.html) or [Parallel](https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-parallel-state.html) state, `RedriveExecution` API action reschedules and redrives only the iterations and branches that failed or aborted.
     *
     * To redrive a workflow that includes a Distributed Map state whose Map Run failed, you must redrive the [parent workflow](https://docs.aws.amazon.com/step-functions/latest/dg/use-dist-map-orchestrate-large-scale-parallel-workloads.html#dist-map-orchestrate-parallel-workloads-key-terms). The parent workflow redrives all the unsuccessful states, including a failed Map Run. If a Map Run was not started in the original execution attempt, the redriven parent workflow starts the Map Run.
     *
     * This API action is not supported by `EXPRESS` state machines.
     *
     * However, you can restart the unsuccessful executions of Express child workflows in a Distributed Map by redriving its Map Run. When you redrive a Map Run, the Express child workflows are rerun using the StartExecution API action. For more information, see [Redriving Map Runs](https://docs.aws.amazon.com/step-functions/latest/dg/redrive-map-run.html).
     *
     * You can redrive executions if your original execution meets the following conditions:
     * + The execution status isn't `SUCCEEDED`.
     * + Your workflow execution has not exceeded the redrivable period of 14 days. Redrivable period refers to the time during which you can redrive a given execution. This period starts from the day a state machine completes its execution.
     * + The workflow execution has not exceeded the maximum open time of one year. For more information about state machine quotas, see [Quotas related to state machine executions](https://docs.aws.amazon.com/step-functions/latest/dg/limits-overview.html#service-limits-state-machine-executions).
     * + The execution event history count is less than 24,999. Redriven executions append their event history to the existing event history. Make sure your workflow execution contains less than 24,999 events to accommodate the `ExecutionRedriven` history event and at least one other history event.
     */
    public suspend fun redriveExecution(input: RedriveExecutionRequest): RedriveExecutionResponse

    /**
     * Used by activity workers, Task states using the [callback](https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token) pattern, and optionally Task states using the [job run](https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-sync) pattern to report that the task identified by the `taskToken` failed.
     *
     * For an execution with encryption enabled, Step Functions will encrypt the error and cause fields using the KMS key for the execution role.
     *
     * A caller can mark a task as fail without using any KMS permissions in the execution role if the caller provides a null value for both `error` and `cause` fields because no data needs to be encrypted.
     */
    public suspend fun sendTaskFailure(input: SendTaskFailureRequest): SendTaskFailureResponse

    /**
     * Used by activity workers and Task states using the [callback](https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token) pattern, and optionally Task states using the [job run](https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-sync) pattern to report to Step Functions that the task represented by the specified `taskToken` is still making progress. This action resets the `Heartbeat` clock. The `Heartbeat` threshold is specified in the state machine's Amazon States Language definition (`HeartbeatSeconds`). This action does not in itself create an event in the execution history. However, if the task times out, the execution history contains an `ActivityTimedOut` entry for activities, or a `TaskTimedOut` entry for tasks using the [job run](https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-sync) or [callback](https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token) pattern.
     *
     * The `Timeout` of a task, defined in the state machine's Amazon States Language definition, is its maximum allowed duration, regardless of the number of SendTaskHeartbeat requests received. Use `HeartbeatSeconds` to configure the timeout interval for heartbeats.
     */
    public suspend fun sendTaskHeartbeat(input: SendTaskHeartbeatRequest): SendTaskHeartbeatResponse

    /**
     * Used by activity workers, Task states using the [callback](https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token) pattern, and optionally Task states using the [job run](https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-sync) pattern to report that the task identified by the `taskToken` completed successfully.
     */
    public suspend fun sendTaskSuccess(input: SendTaskSuccessRequest): SendTaskSuccessResponse

    /**
     * Starts a state machine execution.
     *
     * A qualified state machine ARN can either refer to a *Distributed Map state* defined within a state machine, a version ARN, or an alias ARN.
     *
     * The following are some examples of qualified and unqualified state machine ARNs:
     * + The following qualified state machine ARN refers to a *Distributed Map state* with a label `mapStateLabel` in a state machine named `myStateMachine`.`arn:partition:states:region:account-id:stateMachine:myStateMachine/mapStateLabel`If you provide a qualified state machine ARN that refers to a *Distributed Map state*, the request fails with `ValidationException`.
     * + The following qualified state machine ARN refers to an alias named `PROD`.`arn:<partition>:states:<region>:<account-id>:stateMachine:<myStateMachine:PROD>`If you provide a qualified state machine ARN that refers to a version ARN or an alias ARN, the request starts execution for that version or alias.
     * + The following unqualified state machine ARN refers to a state machine named `myStateMachine`.`arn:<partition>:states:<region>:<account-id>:stateMachine:<myStateMachine>`
     *
     * If you start an execution with an unqualified state machine ARN, Step Functions uses the latest revision of the state machine for the execution.
     *
     * To start executions of a state machine [version](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html), call `StartExecution` and provide the version ARN or the ARN of an [alias](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html) that points to the version.
     *
     * `StartExecution` is idempotent for `STANDARD` workflows. For a `STANDARD` workflow, if you call `StartExecution` with the same name and input as a running execution, the call succeeds and return the same response as the original request. If the execution is closed or if the input is different, it returns a `400 ExecutionAlreadyExists` error. You can reuse names after 90 days.
     *
     * `StartExecution` isn't idempotent for `EXPRESS` workflows.
     */
    public suspend fun startExecution(input: StartExecutionRequest): StartExecutionResponse

    /**
     * Starts a Synchronous Express state machine execution. `StartSyncExecution` is not available for `STANDARD` workflows.
     *
     * `StartSyncExecution` will return a `200 OK` response, even if your execution fails, because the status code in the API response doesn't reflect function errors. Error codes are reserved for errors that prevent your execution from running, such as permissions errors, limit errors, or issues with your state machine code and configuration.
     *
     * This API action isn't logged in CloudTrail.
     */
    public suspend fun startSyncExecution(input: StartSyncExecutionRequest): StartSyncExecutionResponse

    /**
     * Stops an execution.
     *
     * This API action is not supported by `EXPRESS` state machines.
     *
     * For an execution with encryption enabled, Step Functions will encrypt the error and cause fields using the KMS key for the execution role.
     *
     * A caller can stop an execution without using any KMS permissions in the execution role if the caller provides a null value for both `error` and `cause` fields because no data needs to be encrypted.
     */
    public suspend fun stopExecution(input: StopExecutionRequest): StopExecutionResponse

    /**
     * Add a tag to a Step Functions resource.
     *
     * An array of key-value pairs. For more information, see [Using Cost Allocation Tags](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html) in the *Amazon Web Services Billing and Cost Management User Guide*, and [Controlling Access Using IAM Tags](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html).
     *
     * Tags may only contain Unicode letters, digits, white space, or these symbols: `_ . : / = + - @`.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Accepts the definition of a single state and executes it. You can test a state without creating a state machine or updating an existing state machine. Using this API, you can test the following:
     * + A state's [input and output processing](https://docs.aws.amazon.com/step-functions/latest/dg/test-state-isolation.html#test-state-input-output-dataflow) data flow
     * + An [Amazon Web Services service integration](https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-services.html) request and response
     * + An [HTTP Task](https://docs.aws.amazon.com/step-functions/latest/dg/connect-third-party-apis.html) request and response
     *
     * You can call this API on only one state at a time. The states that you can test include the following:
     * + [All Task types](https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-task-state.html#task-types) except [Activity](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-activities.html)
     * + [Pass](https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-pass-state.html)
     * + [Wait](https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-wait-state.html)
     * + [Choice](https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-choice-state.html)
     * + [Succeed](https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-succeed-state.html)
     * + [Fail](https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-fail-state.html)
     *
     * The `TestState` API assumes an IAM role which must contain the required IAM permissions for the resources your state is accessing. For information about the permissions a state might need, see [IAM permissions to test a state](https://docs.aws.amazon.com/step-functions/latest/dg/test-state-isolation.html#test-state-permissions).
     *
     * The `TestState` API can run for up to five minutes. If the execution of a state exceeds this duration, it fails with the `States.Timeout` error.
     *
     * `TestState` doesn't support [Activity tasks](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-activities.html), `.sync` or `.waitForTaskToken`[service integration patterns](https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html), [Parallel](https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-parallel-state.html), or [Map](https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-map-state.html) states.
     */
    public suspend fun testState(input: TestStateRequest): TestStateResponse

    /**
     * Remove a tag from a Step Functions resource
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates an in-progress Map Run's configuration to include changes to the settings that control maximum concurrency and Map Run failure.
     */
    public suspend fun updateMapRun(input: UpdateMapRunRequest): UpdateMapRunResponse

    /**
     * Updates an existing state machine by modifying its `definition`, `roleArn`, `loggingConfiguration`, or `EncryptionConfiguration`. Running executions will continue to use the previous `definition` and `roleArn`. You must include at least one of `definition` or `roleArn` or you will receive a `MissingRequiredParameter` error.
     *
     * A qualified state machine ARN refers to a *Distributed Map state* defined within a state machine. For example, the qualified state machine ARN `arn:partition:states:region:account-id:stateMachine:stateMachineName/mapStateLabel` refers to a *Distributed Map state* with a label `mapStateLabel` in the state machine named `stateMachineName`.
     *
     * A qualified state machine ARN can either refer to a *Distributed Map state* defined within a state machine, a version ARN, or an alias ARN.
     *
     * The following are some examples of qualified and unqualified state machine ARNs:
     * + The following qualified state machine ARN refers to a *Distributed Map state* with a label `mapStateLabel` in a state machine named `myStateMachine`.`arn:partition:states:region:account-id:stateMachine:myStateMachine/mapStateLabel`If you provide a qualified state machine ARN that refers to a *Distributed Map state*, the request fails with `ValidationException`.
     * + The following qualified state machine ARN refers to an alias named `PROD`.`arn:<partition>:states:<region>:<account-id>:stateMachine:<myStateMachine:PROD>`If you provide a qualified state machine ARN that refers to a version ARN or an alias ARN, the request starts execution for that version or alias.
     * + The following unqualified state machine ARN refers to a state machine named `myStateMachine`.`arn:<partition>:states:<region>:<account-id>:stateMachine:<myStateMachine>`
     *
     * After you update your state machine, you can set the `publish` parameter to `true` in the same action to publish a new [version](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html). This way, you can opt-in to strict versioning of your state machine.
     *
     * Step Functions assigns monotonically increasing integers for state machine versions, starting at version number 1.
     *
     * All `StartExecution` calls within a few seconds use the updated `definition` and `roleArn`. Executions started immediately after you call `UpdateStateMachine` may use the previous state machine `definition` and `roleArn`.
     */
    public suspend fun updateStateMachine(input: UpdateStateMachineRequest): UpdateStateMachineResponse

    /**
     * Updates the configuration of an existing state machine [alias](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html) by modifying its `description` or `routingConfiguration`.
     *
     * You must specify at least one of the `description` or `routingConfiguration` parameters to update a state machine alias.
     *
     * `UpdateStateMachineAlias` is an idempotent API. Step Functions bases the idempotency check on the `stateMachineAliasArn`, `description`, and `routingConfiguration` parameters. Requests with the same parameters return an idempotent response.
     *
     * This operation is eventually consistent. All StartExecution requests made within a few seconds use the latest alias configuration. Executions started immediately after calling `UpdateStateMachineAlias` may use the previous routing configuration.
     *
     * **Related operations:**
     * + CreateStateMachineAlias
     * + DescribeStateMachineAlias
     * + ListStateMachineAliases
     * + DeleteStateMachineAlias
     */
    public suspend fun updateStateMachineAlias(input: UpdateStateMachineAliasRequest): UpdateStateMachineAliasResponse

    /**
     * Validates the syntax of a state machine definition.
     *
     * You can validate that a state machine definition is correct without creating a state machine resource. Step Functions will implicitly perform the same syntax check when you invoke `CreateStateMachine` and `UpdateStateMachine`. State machine definitions are specified using a JSON-based, structured language. For more information on Amazon States Language see [Amazon States Language](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html) (ASL).
     *
     * Suggested uses for `ValidateStateMachineDefinition`:
     * + Integrate automated checks into your code review or Continuous Integration (CI) process to validate state machine definitions before starting deployments.
     * + Run the validation from a Git pre-commit hook to check your state machine definitions before committing them to your source repository.
     *
     * Errors found in the state machine definition will be returned in the response as a list of **diagnostic elements**, rather than raise an exception.
     */
    public suspend fun validateStateMachineDefinition(input: ValidateStateMachineDefinitionRequest): ValidateStateMachineDefinitionResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun SfnClient.withConfig(block: SfnClient.Config.Builder.() -> Unit): SfnClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultSfnClient(newConfig)
}

/**
 * Creates an activity. An activity is a task that you write in any programming language and host on any machine that has access to Step Functions. Activities must poll Step Functions using the `GetActivityTask` API action and respond using `SendTask*` API actions. This function lets Step Functions know the existence of your activity and returns an identifier for use in a state machine and when polling from the activity.
 *
 * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.
 *
 * `CreateActivity` is an idempotent API. Subsequent requests won’t create a duplicate resource if it was already created. `CreateActivity`'s idempotency check is based on the activity `name`. If a following request has different `tags` values, Step Functions will ignore these differences and treat it as an idempotent request of the previous. In this case, `tags` will not be updated, even if they are different.
 */
public suspend inline fun SfnClient.createActivity(crossinline block: CreateActivityRequest.Builder.() -> Unit): CreateActivityResponse = createActivity(CreateActivityRequest.Builder().apply(block).build())

/**
 * Creates a state machine. A state machine consists of a collection of states that can do work (`Task` states), determine to which states to transition next (`Choice` states), stop an execution with an error (`Fail` states), and so on. State machines are specified using a JSON-based, structured language. For more information, see [Amazon States Language](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html) in the Step Functions User Guide.
 *
 * If you set the `publish` parameter of this API action to `true`, it publishes version `1` as the first revision of the state machine.
 *
 *  For additional control over security, you can encrypt your data using a **customer-managed key** for Step Functions state machines. You can configure a symmetric KMS key and data key reuse period when creating or updating a **State Machine**. The execution history and state machine definition will be encrypted with the key applied to the State Machine.
 *
 * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.
 *
 * `CreateStateMachine` is an idempotent API. Subsequent requests won’t create a duplicate resource if it was already created. `CreateStateMachine`'s idempotency check is based on the state machine `name`, `definition`, `type`, `LoggingConfiguration`, `TracingConfiguration`, and `EncryptionConfiguration` The check is also based on the `publish` and `versionDescription` parameters. If a following request has a different `roleArn` or `tags`, Step Functions will ignore these differences and treat it as an idempotent request of the previous. In this case, `roleArn` and `tags` will not be updated, even if they are different.
 */
public suspend inline fun SfnClient.createStateMachine(crossinline block: CreateStateMachineRequest.Builder.() -> Unit): CreateStateMachineResponse = createStateMachine(CreateStateMachineRequest.Builder().apply(block).build())

/**
 * Creates an [alias](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html) for a state machine that points to one or two [versions](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html) of the same state machine. You can set your application to call StartExecution with an alias and update the version the alias uses without changing the client's code.
 *
 * You can also map an alias to split StartExecution requests between two versions of a state machine. To do this, add a second `RoutingConfig` object in the `routingConfiguration` parameter. You must also specify the percentage of execution run requests each version should receive in both `RoutingConfig` objects. Step Functions randomly chooses which version runs a given execution based on the percentage you specify.
 *
 * To create an alias that points to a single version, specify a single `RoutingConfig` object with a `weight` set to 100.
 *
 * You can create up to 100 aliases for each state machine. You must delete unused aliases using the DeleteStateMachineAlias API action.
 *
 * `CreateStateMachineAlias` is an idempotent API. Step Functions bases the idempotency check on the `stateMachineArn`, `description`, `name`, and `routingConfiguration` parameters. Requests that contain the same values for these parameters return a successful idempotent response without creating a duplicate resource.
 *
 * **Related operations:**
 * + DescribeStateMachineAlias
 * + ListStateMachineAliases
 * + UpdateStateMachineAlias
 * + DeleteStateMachineAlias
 */
public suspend inline fun SfnClient.createStateMachineAlias(crossinline block: CreateStateMachineAliasRequest.Builder.() -> Unit): CreateStateMachineAliasResponse = createStateMachineAlias(CreateStateMachineAliasRequest.Builder().apply(block).build())

/**
 * Deletes an activity.
 */
public suspend inline fun SfnClient.deleteActivity(crossinline block: DeleteActivityRequest.Builder.() -> Unit): DeleteActivityResponse = deleteActivity(DeleteActivityRequest.Builder().apply(block).build())

/**
 * Deletes a state machine. This is an asynchronous operation. It sets the state machine's status to `DELETING` and begins the deletion process. A state machine is deleted only when all its executions are completed. On the next state transition, the state machine's executions are terminated.
 *
 * A qualified state machine ARN can either refer to a *Distributed Map state* defined within a state machine, a version ARN, or an alias ARN.
 *
 * The following are some examples of qualified and unqualified state machine ARNs:
 * + The following qualified state machine ARN refers to a *Distributed Map state* with a label `mapStateLabel` in a state machine named `myStateMachine`.`arn:partition:states:region:account-id:stateMachine:myStateMachine/mapStateLabel`If you provide a qualified state machine ARN that refers to a *Distributed Map state*, the request fails with `ValidationException`.
 * + The following unqualified state machine ARN refers to a state machine named `myStateMachine`.`arn:partition:states:region:account-id:stateMachine:myStateMachine`
 *
 * This API action also deletes all [versions](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html) and [aliases](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html) associated with a state machine.
 *
 * For `EXPRESS` state machines, the deletion happens eventually (usually in less than a minute). Running executions may emit logs after `DeleteStateMachine` API is called.
 */
public suspend inline fun SfnClient.deleteStateMachine(crossinline block: DeleteStateMachineRequest.Builder.() -> Unit): DeleteStateMachineResponse = deleteStateMachine(DeleteStateMachineRequest.Builder().apply(block).build())

/**
 * Deletes a state machine [alias](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html).
 *
 * After you delete a state machine alias, you can't use it to start executions. When you delete a state machine alias, Step Functions doesn't delete the state machine versions that alias references.
 *
 * **Related operations:**
 * + CreateStateMachineAlias
 * + DescribeStateMachineAlias
 * + ListStateMachineAliases
 * + UpdateStateMachineAlias
 */
public suspend inline fun SfnClient.deleteStateMachineAlias(crossinline block: DeleteStateMachineAliasRequest.Builder.() -> Unit): DeleteStateMachineAliasResponse = deleteStateMachineAlias(DeleteStateMachineAliasRequest.Builder().apply(block).build())

/**
 * Deletes a state machine [version](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html). After you delete a version, you can't call StartExecution using that version's ARN or use the version with a state machine [alias](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html).
 *
 * Deleting a state machine version won't terminate its in-progress executions.
 *
 * You can't delete a state machine version currently referenced by one or more aliases. Before you delete a version, you must either delete the aliases or update them to point to another state machine version.
 *
 * **Related operations:**
 * + PublishStateMachineVersion
 * + ListStateMachineVersions
 */
public suspend inline fun SfnClient.deleteStateMachineVersion(crossinline block: DeleteStateMachineVersionRequest.Builder.() -> Unit): DeleteStateMachineVersionResponse = deleteStateMachineVersion(DeleteStateMachineVersionRequest.Builder().apply(block).build())

/**
 * Describes an activity.
 *
 * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.
 */
public suspend inline fun SfnClient.describeActivity(crossinline block: DescribeActivityRequest.Builder.() -> Unit): DescribeActivityResponse = describeActivity(DescribeActivityRequest.Builder().apply(block).build())

/**
 * Provides information about a state machine execution, such as the state machine associated with the execution, the execution input and output, and relevant execution metadata. If you've [redriven](https://docs.aws.amazon.com/step-functions/latest/dg/redrive-executions.html) an execution, you can use this API action to return information about the redrives of that execution. In addition, you can use this API action to return the Map Run Amazon Resource Name (ARN) if the execution was dispatched by a Map Run.
 *
 * If you specify a version or alias ARN when you call the StartExecution API action, `DescribeExecution` returns that ARN.
 *
 * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.
 *
 * Executions of an `EXPRESS` state machine aren't supported by `DescribeExecution` unless a Map Run dispatched them.
 */
public suspend inline fun SfnClient.describeExecution(crossinline block: DescribeExecutionRequest.Builder.() -> Unit): DescribeExecutionResponse = describeExecution(DescribeExecutionRequest.Builder().apply(block).build())

/**
 * Provides information about a Map Run's configuration, progress, and results. If you've [redriven](https://docs.aws.amazon.com/step-functions/latest/dg/redrive-map-run.html) a Map Run, this API action also returns information about the redrives of that Map Run. For more information, see [Examining Map Run](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-examine-map-run.html) in the *Step Functions Developer Guide*.
 */
public suspend inline fun SfnClient.describeMapRun(crossinline block: DescribeMapRunRequest.Builder.() -> Unit): DescribeMapRunResponse = describeMapRun(DescribeMapRunRequest.Builder().apply(block).build())

/**
 * Provides information about a state machine's definition, its IAM role Amazon Resource Name (ARN), and configuration.
 *
 * A qualified state machine ARN can either refer to a *Distributed Map state* defined within a state machine, a version ARN, or an alias ARN.
 *
 * The following are some examples of qualified and unqualified state machine ARNs:
 * + The following qualified state machine ARN refers to a *Distributed Map state* with a label `mapStateLabel` in a state machine named `myStateMachine`.`arn:partition:states:region:account-id:stateMachine:myStateMachine/mapStateLabel`If you provide a qualified state machine ARN that refers to a *Distributed Map state*, the request fails with `ValidationException`.
 * + The following qualified state machine ARN refers to an alias named `PROD`.`arn:<partition>:states:<region>:<account-id>:stateMachine:<myStateMachine:PROD>`If you provide a qualified state machine ARN that refers to a version ARN or an alias ARN, the request starts execution for that version or alias.
 * + The following unqualified state machine ARN refers to a state machine named `myStateMachine`.`arn:<partition>:states:<region>:<account-id>:stateMachine:<myStateMachine>`
 *
 * This API action returns the details for a state machine version if the `stateMachineArn` you specify is a state machine version ARN.
 *
 * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.
 */
public suspend inline fun SfnClient.describeStateMachine(crossinline block: DescribeStateMachineRequest.Builder.() -> Unit): DescribeStateMachineResponse = describeStateMachine(DescribeStateMachineRequest.Builder().apply(block).build())

/**
 * Returns details about a state machine [alias](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html).
 *
 * **Related operations:**
 * + CreateStateMachineAlias
 * + ListStateMachineAliases
 * + UpdateStateMachineAlias
 * + DeleteStateMachineAlias
 */
public suspend inline fun SfnClient.describeStateMachineAlias(crossinline block: DescribeStateMachineAliasRequest.Builder.() -> Unit): DescribeStateMachineAliasResponse = describeStateMachineAlias(DescribeStateMachineAliasRequest.Builder().apply(block).build())

/**
 * Provides information about a state machine's definition, its execution role ARN, and configuration. If a Map Run dispatched the execution, this action returns the Map Run Amazon Resource Name (ARN) in the response. The state machine returned is the state machine associated with the Map Run.
 *
 * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.
 *
 * This API action is not supported by `EXPRESS` state machines.
 */
public suspend inline fun SfnClient.describeStateMachineForExecution(crossinline block: DescribeStateMachineForExecutionRequest.Builder.() -> Unit): DescribeStateMachineForExecutionResponse = describeStateMachineForExecution(DescribeStateMachineForExecutionRequest.Builder().apply(block).build())

/**
 * Used by workers to retrieve a task (with the specified activity ARN) which has been scheduled for execution by a running state machine. This initiates a long poll, where the service holds the HTTP connection open and responds as soon as a task becomes available (i.e. an execution of a task of this type is needed.) The maximum time the service holds on to the request before responding is 60 seconds. If no task is available within 60 seconds, the poll returns a `taskToken` with a null string.
 *
 * This API action isn't logged in CloudTrail.
 *
 * Workers should set their client side socket timeout to at least 65 seconds (5 seconds higher than the maximum time the service may hold the poll request).
 *
 * Polling with `GetActivityTask` can cause latency in some implementations. See [Avoid Latency When Polling for Activity Tasks](https://docs.aws.amazon.com/step-functions/latest/dg/bp-activity-pollers.html) in the Step Functions Developer Guide.
 */
public suspend inline fun SfnClient.getActivityTask(crossinline block: GetActivityTaskRequest.Builder.() -> Unit): GetActivityTaskResponse = getActivityTask(GetActivityTaskRequest.Builder().apply(block).build())

/**
 * Returns the history of the specified execution as a list of events. By default, the results are returned in ascending order of the `timeStamp` of the events. Use the `reverseOrder` parameter to get the latest events first.
 *
 * If `nextToken` is returned, there are more results available. The value of `nextToken` is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an *HTTP 400 InvalidToken* error.
 *
 * This API action is not supported by `EXPRESS` state machines.
 */
public suspend inline fun SfnClient.getExecutionHistory(crossinline block: GetExecutionHistoryRequest.Builder.() -> Unit): GetExecutionHistoryResponse = getExecutionHistory(GetExecutionHistoryRequest.Builder().apply(block).build())

/**
 * Lists the existing activities.
 *
 * If `nextToken` is returned, there are more results available. The value of `nextToken` is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an *HTTP 400 InvalidToken* error.
 *
 * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.
 */
public suspend inline fun SfnClient.listActivities(crossinline block: ListActivitiesRequest.Builder.() -> Unit): ListActivitiesResponse = listActivities(ListActivitiesRequest.Builder().apply(block).build())

/**
 * Lists all executions of a state machine or a Map Run. You can list all executions related to a state machine by specifying a state machine Amazon Resource Name (ARN), or those related to a Map Run by specifying a Map Run ARN. Using this API action, you can also list all [redriven](https://docs.aws.amazon.com/step-functions/latest/dg/redrive-executions.html) executions.
 *
 * You can also provide a state machine [alias](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html) ARN or [version](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html) ARN to list the executions associated with a specific alias or version.
 *
 * Results are sorted by time, with the most recent execution first.
 *
 * If `nextToken` is returned, there are more results available. The value of `nextToken` is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an *HTTP 400 InvalidToken* error.
 *
 * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.
 *
 * This API action is not supported by `EXPRESS` state machines.
 */
public suspend inline fun SfnClient.listExecutions(crossinline block: ListExecutionsRequest.Builder.() -> Unit): ListExecutionsResponse = listExecutions(ListExecutionsRequest.Builder().apply(block).build())

/**
 * Lists all Map Runs that were started by a given state machine execution. Use this API action to obtain Map Run ARNs, and then call `DescribeMapRun` to obtain more information, if needed.
 */
public suspend inline fun SfnClient.listMapRuns(crossinline block: ListMapRunsRequest.Builder.() -> Unit): ListMapRunsResponse = listMapRuns(ListMapRunsRequest.Builder().apply(block).build())

/**
 * Lists [aliases](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html) for a specified state machine ARN. Results are sorted by time, with the most recently created aliases listed first.
 *
 * To list aliases that reference a state machine [version](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html), you can specify the version ARN in the `stateMachineArn` parameter.
 *
 * If `nextToken` is returned, there are more results available. The value of `nextToken` is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an *HTTP 400 InvalidToken* error.
 *
 * **Related operations:**
 * + CreateStateMachineAlias
 * + DescribeStateMachineAlias
 * + UpdateStateMachineAlias
 * + DeleteStateMachineAlias
 */
public suspend inline fun SfnClient.listStateMachineAliases(crossinline block: ListStateMachineAliasesRequest.Builder.() -> Unit): ListStateMachineAliasesResponse = listStateMachineAliases(ListStateMachineAliasesRequest.Builder().apply(block).build())

/**
 * Lists [versions](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html) for the specified state machine Amazon Resource Name (ARN).
 *
 * The results are sorted in descending order of the version creation time.
 *
 * If `nextToken` is returned, there are more results available. The value of `nextToken` is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an *HTTP 400 InvalidToken* error.
 *
 * **Related operations:**
 * + PublishStateMachineVersion
 * + DeleteStateMachineVersion
 */
public suspend inline fun SfnClient.listStateMachineVersions(crossinline block: ListStateMachineVersionsRequest.Builder.() -> Unit): ListStateMachineVersionsResponse = listStateMachineVersions(ListStateMachineVersionsRequest.Builder().apply(block).build())

/**
 * Lists the existing state machines.
 *
 * If `nextToken` is returned, there are more results available. The value of `nextToken` is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an *HTTP 400 InvalidToken* error.
 *
 * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.
 */
public suspend inline fun SfnClient.listStateMachines(crossinline block: ListStateMachinesRequest.Builder.() -> Unit): ListStateMachinesResponse = listStateMachines(ListStateMachinesRequest.Builder().apply(block).build())

/**
 * List tags for a given resource.
 *
 * Tags may only contain Unicode letters, digits, white space, or these symbols: `_ . : / = + - @`.
 */
public suspend inline fun SfnClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Creates a [version](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html) from the current revision of a state machine. Use versions to create immutable snapshots of your state machine. You can start executions from versions either directly or with an alias. To create an alias, use CreateStateMachineAlias.
 *
 * You can publish up to 1000 versions for each state machine. You must manually delete unused versions using the DeleteStateMachineVersion API action.
 *
 * `PublishStateMachineVersion` is an idempotent API. It doesn't create a duplicate state machine version if it already exists for the current revision. Step Functions bases `PublishStateMachineVersion`'s idempotency check on the `stateMachineArn`, `name`, and `revisionId` parameters. Requests with the same parameters return a successful idempotent response. If you don't specify a `revisionId`, Step Functions checks for a previously published version of the state machine's current revision.
 *
 * **Related operations:**
 * + DeleteStateMachineVersion
 * + ListStateMachineVersions
 */
public suspend inline fun SfnClient.publishStateMachineVersion(crossinline block: PublishStateMachineVersionRequest.Builder.() -> Unit): PublishStateMachineVersionResponse = publishStateMachineVersion(PublishStateMachineVersionRequest.Builder().apply(block).build())

/**
 * Restarts unsuccessful executions of Standard workflows that didn't complete successfully in the last 14 days. These include failed, aborted, or timed out executions. When you [redrive](https://docs.aws.amazon.com/step-functions/latest/dg/redrive-executions.html) an execution, it continues the failed execution from the unsuccessful step and uses the same input. Step Functions preserves the results and execution history of the successful steps, and doesn't rerun these steps when you redrive an execution. Redriven executions use the same state machine definition and execution ARN as the original execution attempt.
 *
 * For workflows that include an [Inline Map](https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-map-state.html) or [Parallel](https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-parallel-state.html) state, `RedriveExecution` API action reschedules and redrives only the iterations and branches that failed or aborted.
 *
 * To redrive a workflow that includes a Distributed Map state whose Map Run failed, you must redrive the [parent workflow](https://docs.aws.amazon.com/step-functions/latest/dg/use-dist-map-orchestrate-large-scale-parallel-workloads.html#dist-map-orchestrate-parallel-workloads-key-terms). The parent workflow redrives all the unsuccessful states, including a failed Map Run. If a Map Run was not started in the original execution attempt, the redriven parent workflow starts the Map Run.
 *
 * This API action is not supported by `EXPRESS` state machines.
 *
 * However, you can restart the unsuccessful executions of Express child workflows in a Distributed Map by redriving its Map Run. When you redrive a Map Run, the Express child workflows are rerun using the StartExecution API action. For more information, see [Redriving Map Runs](https://docs.aws.amazon.com/step-functions/latest/dg/redrive-map-run.html).
 *
 * You can redrive executions if your original execution meets the following conditions:
 * + The execution status isn't `SUCCEEDED`.
 * + Your workflow execution has not exceeded the redrivable period of 14 days. Redrivable period refers to the time during which you can redrive a given execution. This period starts from the day a state machine completes its execution.
 * + The workflow execution has not exceeded the maximum open time of one year. For more information about state machine quotas, see [Quotas related to state machine executions](https://docs.aws.amazon.com/step-functions/latest/dg/limits-overview.html#service-limits-state-machine-executions).
 * + The execution event history count is less than 24,999. Redriven executions append their event history to the existing event history. Make sure your workflow execution contains less than 24,999 events to accommodate the `ExecutionRedriven` history event and at least one other history event.
 */
public suspend inline fun SfnClient.redriveExecution(crossinline block: RedriveExecutionRequest.Builder.() -> Unit): RedriveExecutionResponse = redriveExecution(RedriveExecutionRequest.Builder().apply(block).build())

/**
 * Used by activity workers, Task states using the [callback](https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token) pattern, and optionally Task states using the [job run](https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-sync) pattern to report that the task identified by the `taskToken` failed.
 *
 * For an execution with encryption enabled, Step Functions will encrypt the error and cause fields using the KMS key for the execution role.
 *
 * A caller can mark a task as fail without using any KMS permissions in the execution role if the caller provides a null value for both `error` and `cause` fields because no data needs to be encrypted.
 */
public suspend inline fun SfnClient.sendTaskFailure(crossinline block: SendTaskFailureRequest.Builder.() -> Unit): SendTaskFailureResponse = sendTaskFailure(SendTaskFailureRequest.Builder().apply(block).build())

/**
 * Used by activity workers and Task states using the [callback](https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token) pattern, and optionally Task states using the [job run](https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-sync) pattern to report to Step Functions that the task represented by the specified `taskToken` is still making progress. This action resets the `Heartbeat` clock. The `Heartbeat` threshold is specified in the state machine's Amazon States Language definition (`HeartbeatSeconds`). This action does not in itself create an event in the execution history. However, if the task times out, the execution history contains an `ActivityTimedOut` entry for activities, or a `TaskTimedOut` entry for tasks using the [job run](https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-sync) or [callback](https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token) pattern.
 *
 * The `Timeout` of a task, defined in the state machine's Amazon States Language definition, is its maximum allowed duration, regardless of the number of SendTaskHeartbeat requests received. Use `HeartbeatSeconds` to configure the timeout interval for heartbeats.
 */
public suspend inline fun SfnClient.sendTaskHeartbeat(crossinline block: SendTaskHeartbeatRequest.Builder.() -> Unit): SendTaskHeartbeatResponse = sendTaskHeartbeat(SendTaskHeartbeatRequest.Builder().apply(block).build())

/**
 * Used by activity workers, Task states using the [callback](https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token) pattern, and optionally Task states using the [job run](https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-sync) pattern to report that the task identified by the `taskToken` completed successfully.
 */
public suspend inline fun SfnClient.sendTaskSuccess(crossinline block: SendTaskSuccessRequest.Builder.() -> Unit): SendTaskSuccessResponse = sendTaskSuccess(SendTaskSuccessRequest.Builder().apply(block).build())

/**
 * Starts a state machine execution.
 *
 * A qualified state machine ARN can either refer to a *Distributed Map state* defined within a state machine, a version ARN, or an alias ARN.
 *
 * The following are some examples of qualified and unqualified state machine ARNs:
 * + The following qualified state machine ARN refers to a *Distributed Map state* with a label `mapStateLabel` in a state machine named `myStateMachine`.`arn:partition:states:region:account-id:stateMachine:myStateMachine/mapStateLabel`If you provide a qualified state machine ARN that refers to a *Distributed Map state*, the request fails with `ValidationException`.
 * + The following qualified state machine ARN refers to an alias named `PROD`.`arn:<partition>:states:<region>:<account-id>:stateMachine:<myStateMachine:PROD>`If you provide a qualified state machine ARN that refers to a version ARN or an alias ARN, the request starts execution for that version or alias.
 * + The following unqualified state machine ARN refers to a state machine named `myStateMachine`.`arn:<partition>:states:<region>:<account-id>:stateMachine:<myStateMachine>`
 *
 * If you start an execution with an unqualified state machine ARN, Step Functions uses the latest revision of the state machine for the execution.
 *
 * To start executions of a state machine [version](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html), call `StartExecution` and provide the version ARN or the ARN of an [alias](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html) that points to the version.
 *
 * `StartExecution` is idempotent for `STANDARD` workflows. For a `STANDARD` workflow, if you call `StartExecution` with the same name and input as a running execution, the call succeeds and return the same response as the original request. If the execution is closed or if the input is different, it returns a `400 ExecutionAlreadyExists` error. You can reuse names after 90 days.
 *
 * `StartExecution` isn't idempotent for `EXPRESS` workflows.
 */
public suspend inline fun SfnClient.startExecution(crossinline block: StartExecutionRequest.Builder.() -> Unit): StartExecutionResponse = startExecution(StartExecutionRequest.Builder().apply(block).build())

/**
 * Starts a Synchronous Express state machine execution. `StartSyncExecution` is not available for `STANDARD` workflows.
 *
 * `StartSyncExecution` will return a `200 OK` response, even if your execution fails, because the status code in the API response doesn't reflect function errors. Error codes are reserved for errors that prevent your execution from running, such as permissions errors, limit errors, or issues with your state machine code and configuration.
 *
 * This API action isn't logged in CloudTrail.
 */
public suspend inline fun SfnClient.startSyncExecution(crossinline block: StartSyncExecutionRequest.Builder.() -> Unit): StartSyncExecutionResponse = startSyncExecution(StartSyncExecutionRequest.Builder().apply(block).build())

/**
 * Stops an execution.
 *
 * This API action is not supported by `EXPRESS` state machines.
 *
 * For an execution with encryption enabled, Step Functions will encrypt the error and cause fields using the KMS key for the execution role.
 *
 * A caller can stop an execution without using any KMS permissions in the execution role if the caller provides a null value for both `error` and `cause` fields because no data needs to be encrypted.
 */
public suspend inline fun SfnClient.stopExecution(crossinline block: StopExecutionRequest.Builder.() -> Unit): StopExecutionResponse = stopExecution(StopExecutionRequest.Builder().apply(block).build())

/**
 * Add a tag to a Step Functions resource.
 *
 * An array of key-value pairs. For more information, see [Using Cost Allocation Tags](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html) in the *Amazon Web Services Billing and Cost Management User Guide*, and [Controlling Access Using IAM Tags](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html).
 *
 * Tags may only contain Unicode letters, digits, white space, or these symbols: `_ . : / = + - @`.
 */
public suspend inline fun SfnClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Accepts the definition of a single state and executes it. You can test a state without creating a state machine or updating an existing state machine. Using this API, you can test the following:
 * + A state's [input and output processing](https://docs.aws.amazon.com/step-functions/latest/dg/test-state-isolation.html#test-state-input-output-dataflow) data flow
 * + An [Amazon Web Services service integration](https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-services.html) request and response
 * + An [HTTP Task](https://docs.aws.amazon.com/step-functions/latest/dg/connect-third-party-apis.html) request and response
 *
 * You can call this API on only one state at a time. The states that you can test include the following:
 * + [All Task types](https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-task-state.html#task-types) except [Activity](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-activities.html)
 * + [Pass](https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-pass-state.html)
 * + [Wait](https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-wait-state.html)
 * + [Choice](https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-choice-state.html)
 * + [Succeed](https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-succeed-state.html)
 * + [Fail](https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-fail-state.html)
 *
 * The `TestState` API assumes an IAM role which must contain the required IAM permissions for the resources your state is accessing. For information about the permissions a state might need, see [IAM permissions to test a state](https://docs.aws.amazon.com/step-functions/latest/dg/test-state-isolation.html#test-state-permissions).
 *
 * The `TestState` API can run for up to five minutes. If the execution of a state exceeds this duration, it fails with the `States.Timeout` error.
 *
 * `TestState` doesn't support [Activity tasks](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-activities.html), `.sync` or `.waitForTaskToken`[service integration patterns](https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html), [Parallel](https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-parallel-state.html), or [Map](https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-map-state.html) states.
 */
public suspend inline fun SfnClient.testState(crossinline block: TestStateRequest.Builder.() -> Unit): TestStateResponse = testState(TestStateRequest.Builder().apply(block).build())

/**
 * Remove a tag from a Step Functions resource
 */
public suspend inline fun SfnClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates an in-progress Map Run's configuration to include changes to the settings that control maximum concurrency and Map Run failure.
 */
public suspend inline fun SfnClient.updateMapRun(crossinline block: UpdateMapRunRequest.Builder.() -> Unit): UpdateMapRunResponse = updateMapRun(UpdateMapRunRequest.Builder().apply(block).build())

/**
 * Updates an existing state machine by modifying its `definition`, `roleArn`, `loggingConfiguration`, or `EncryptionConfiguration`. Running executions will continue to use the previous `definition` and `roleArn`. You must include at least one of `definition` or `roleArn` or you will receive a `MissingRequiredParameter` error.
 *
 * A qualified state machine ARN refers to a *Distributed Map state* defined within a state machine. For example, the qualified state machine ARN `arn:partition:states:region:account-id:stateMachine:stateMachineName/mapStateLabel` refers to a *Distributed Map state* with a label `mapStateLabel` in the state machine named `stateMachineName`.
 *
 * A qualified state machine ARN can either refer to a *Distributed Map state* defined within a state machine, a version ARN, or an alias ARN.
 *
 * The following are some examples of qualified and unqualified state machine ARNs:
 * + The following qualified state machine ARN refers to a *Distributed Map state* with a label `mapStateLabel` in a state machine named `myStateMachine`.`arn:partition:states:region:account-id:stateMachine:myStateMachine/mapStateLabel`If you provide a qualified state machine ARN that refers to a *Distributed Map state*, the request fails with `ValidationException`.
 * + The following qualified state machine ARN refers to an alias named `PROD`.`arn:<partition>:states:<region>:<account-id>:stateMachine:<myStateMachine:PROD>`If you provide a qualified state machine ARN that refers to a version ARN or an alias ARN, the request starts execution for that version or alias.
 * + The following unqualified state machine ARN refers to a state machine named `myStateMachine`.`arn:<partition>:states:<region>:<account-id>:stateMachine:<myStateMachine>`
 *
 * After you update your state machine, you can set the `publish` parameter to `true` in the same action to publish a new [version](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html). This way, you can opt-in to strict versioning of your state machine.
 *
 * Step Functions assigns monotonically increasing integers for state machine versions, starting at version number 1.
 *
 * All `StartExecution` calls within a few seconds use the updated `definition` and `roleArn`. Executions started immediately after you call `UpdateStateMachine` may use the previous state machine `definition` and `roleArn`.
 */
public suspend inline fun SfnClient.updateStateMachine(crossinline block: UpdateStateMachineRequest.Builder.() -> Unit): UpdateStateMachineResponse = updateStateMachine(UpdateStateMachineRequest.Builder().apply(block).build())

/**
 * Updates the configuration of an existing state machine [alias](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html) by modifying its `description` or `routingConfiguration`.
 *
 * You must specify at least one of the `description` or `routingConfiguration` parameters to update a state machine alias.
 *
 * `UpdateStateMachineAlias` is an idempotent API. Step Functions bases the idempotency check on the `stateMachineAliasArn`, `description`, and `routingConfiguration` parameters. Requests with the same parameters return an idempotent response.
 *
 * This operation is eventually consistent. All StartExecution requests made within a few seconds use the latest alias configuration. Executions started immediately after calling `UpdateStateMachineAlias` may use the previous routing configuration.
 *
 * **Related operations:**
 * + CreateStateMachineAlias
 * + DescribeStateMachineAlias
 * + ListStateMachineAliases
 * + DeleteStateMachineAlias
 */
public suspend inline fun SfnClient.updateStateMachineAlias(crossinline block: UpdateStateMachineAliasRequest.Builder.() -> Unit): UpdateStateMachineAliasResponse = updateStateMachineAlias(UpdateStateMachineAliasRequest.Builder().apply(block).build())

/**
 * Validates the syntax of a state machine definition.
 *
 * You can validate that a state machine definition is correct without creating a state machine resource. Step Functions will implicitly perform the same syntax check when you invoke `CreateStateMachine` and `UpdateStateMachine`. State machine definitions are specified using a JSON-based, structured language. For more information on Amazon States Language see [Amazon States Language](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html) (ASL).
 *
 * Suggested uses for `ValidateStateMachineDefinition`:
 * + Integrate automated checks into your code review or Continuous Integration (CI) process to validate state machine definitions before starting deployments.
 * + Run the validation from a Git pre-commit hook to check your state machine definitions before committing them to your source repository.
 *
 * Errors found in the state machine definition will be returned in the response as a list of **diagnostic elements**, rather than raise an exception.
 */
public suspend inline fun SfnClient.validateStateMachineDefinition(crossinline block: ValidateStateMachineDefinitionRequest.Builder.() -> Unit): ValidateStateMachineDefinitionResponse = validateStateMachineDefinition(ValidateStateMachineDefinitionRequest.Builder().apply(block).build())
